import { Cipher } from './Cipher';
import { WordArray } from './WordArray';
import { BufferedBlockAlgorithmConfig } from './BufferedBlockAlgorithmConfig';
import { BlockCipherModeAlgorithm } from '../mode/BlockCipherModeAlgorithm';
export declare abstract class BlockCipher extends Cipher {
    _mode: BlockCipherModeAlgorithm;
    constructor(xformMode: number, key: WordArray, cfg?: BufferedBlockAlgorithmConfig);
    reset(): void;
    _doProcessBlock(words: Array<number>, offset: number): void;
    _doFinalize(): WordArray;
    abstract encryptBlock(M: Array<number>, offset: number): void;
    abstract decryptBlock(M: Array<number>, offset: number): void;
}
