// ********************************************************** user controller ********************************************* //

const mongoose = require("mongoose");
const config = require("../config");
const async = require("async");
const _ = require("lodash");
const CryptoTS = require("crypto-ts");
const userSchema = mongoose.model("user");
const emploiSchema = mongoose.model("emploi");
const fs = require("fs");

// ********************************************************* User API *********************************************** //
/* FIXME: : search on all colunne */

exports.getUsers = (req, res) => {
  var receivedValues = req.body;
  const offset = (req.body.pageOffset - 1) * req.body.limit;
  userSchema
    .find({
      firstName: {
        $regex: new RegExp(
          ".*" + receivedValues.firstName.toLowerCase() + ".*",
          "i"
        ),
      },
      userDeleted: false,
      userRole: { $ne: 'superAdmin' }
    })
    .lean()
    .countDocuments()
    .then((counts) => {
      return counts;
    })
    .then((totalUsers) => {
      if (!totalUsers || totalUsers === 0) {
        res.json({
          code: config.successCode,
          status: "Error",
          message: "Aucun utilisateur trouvé.",
        });
        return;
      } else {
        userSchema
          .find({
            firstName: {
              $regex: new RegExp(
                ".*" + receivedValues.firstName.toLowerCase() + ".*",
                "i"
              ),
            },
            userDeleted: false,
            userRole: { $ne: 'superAdmin' }
          })

          .sort({ [req.body.sortBy]: req.body.orderBy })
          .skip(offset)
          .limit(req.body.limit)
          .select({ __v: 0, password: 0 })
          .lean()
          .populate("clientID")
          .exec((err, listusers) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              res.json({
                code: config.successCode,
                status: "success",
                data: {
                  listUsers: listusers,
                  totalUsers: totalUsers,
                  totalPages: Math.ceil(totalUsers / req.body.limit),
                },
              });
            }
          });
      }
    });
  // }
};

exports.getUserByID = (req, res) => {
  var receivedValues = req.body;
  userID = receivedValues.userID;
  if (req.user.userRole != "admin" && req.user.userRole != "superAdmin") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Accès non autorisé.",
    });
  } else {
    userSchema
      .findOne({
        _id: userID,
      })
      .select({ __v: 0, password: 0 })
      .populate("clientID")
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          res.json({
            code: config.successCode,
            status: "success",
            data: user,
          });
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "Aucun utilisateur trouvé.",
          });
        }
      });
  }
};

exports.activatedUser = (req, res) => {
  if (req.user.userRole != "admin" && req.user.userRole != "superAdmin") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Accès non autorisé.",
    });
  } else {
    var receivedValues = req.body;
    if (
      JSON.stringify(receivedValues) === "{}" ||
      receivedValues === undefined ||
      receivedValues === null
    ) {
      res.json({
        code: config.errCode,
        status: "Error",
        message: "Les données entrées ne sont pas valides.",
      });
      return;
    } else {
      userSchema
        .findOne({
          _id: receivedValues.userID,
        })
        .select({})
        .exec((err, user) => {
          if (err) {
            res.json({
              code: config.errCode,
              status: "Error",
              message: err.message,
            });
            return;
          }
          if (user) {
            let fieldToSet;
            fieldToSet = {
              userActivated: receivedValues.userActivated,
            };
            let Option = {
              new: true,
            };
            userSchema.findByIdAndUpdate(
              receivedValues.userID,
              fieldToSet,
              Option,
              (err, updatedData) => {
                if (err) {
                  console.log(err);
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                  return;
                } else {
                  res.json({
                    code: config.successCode,
                    status: "Success",
                    message: "L'utilisateur a été modifié avec succès.",
                    data: updatedData,
                  });
                }
              }
            );
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "L'utilisateur n'existe pas.",
            });
          }
        });
    }
  }
};

exports.deletedUser = (req, res) => {
  if (req.user.userRole != "admin" && req.user.userRole != "superAdmin") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Accès non autorisé.",
    });
  } else {
    var receivedValues = req.body;
    if (
      JSON.stringify(receivedValues) === "{}" ||
      receivedValues === undefined ||
      receivedValues === null
    ) {
      res.json({
        code: config.errCode,
        status: "Error",
        message: "Les données entrées ne sont pas valides.",
      });
      return;
    } else {
      userSchema
        .findOne({
          _id: receivedValues.userID,
        })
        .select({})
        .exec((err, user) => {
          if (err) {
            res.json({
              code: config.errCode,
              status: "Error",
              message: err.message,
            });
            return;
          }
          if (user) {
            emploiSchema.find({
              $or: [
                { userID: receivedValues.userID },
                { userValidatorID: receivedValues.userID }
              ]
            })
              .lean()
              .countDocuments()
              .then(counts => {
                return counts;
              }).then((totalEmplois) => {
                if (!totalEmplois || totalEmplois === 0) {

                  //delete user
                  userSchema.deleteOne({
                    _id: receivedValues.userID
                  }).exec((err, userInfo) => {
                    if (err) {
                      console.log(err);
                      res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                      });
                      return;
                    }
                    if (userInfo.deletedCount === 1) {
                      res.json({
                        "code": config.successCode,
                        "status": "success",
                        "message": "L'utilisateur a été supprimé avec succès.",
                      });
                    } else {
                      res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                      });
                    }
                  });

                } else {
                  res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Impossible de supprimer l'utilisateur, des emplois sont liés à ce dernier.",
                  });
                  return;
                }

              });

            // let fieldToSet;
            // fieldToSet = {
            //   userDeleted: receivedValues.userDeleted,
            // };
            // let Option = {
            //   new: true,
            // };
            // userSchema.findByIdAndUpdate(
            //   receivedValues.userID,
            //   fieldToSet,
            //   Option,
            //   (err, updatedData) => {
            //     if (err) {
            //       console.log(err);
            //       res.json({
            //         code: config.errCode,
            //         status: "Error",
            //         message: config.errMessage,
            //       });
            //       return;
            //     } else {
            //       res.json({
            //         code: config.successCode,
            //         status: "Success",
            //         message: "L'utilisateur a été supprimé avec succès.",
            //         data: updatedData,
            //       });
            //     }
            //   }
            // );

          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "L'utilisateur n'existe pas.",
            });
          }
        });
    }
  }
};

exports.changePassword = (req, res) => {
  var receivedValues = req.body;
  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    userSchema
      .findOne({
        _id: receivedValues.userID,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          const newPasswordBytes = CryptoTS.AES.decrypt(
            receivedValues.password.toString(),
            config.secret
          );
          const newPasswordString = newPasswordBytes.toString(
            CryptoTS.enc.Utf8
          );
          let fieldToSet;
          var userdata = new userSchema();
          fieldToSet = {
            password: userdata.generateHash(newPasswordString),
            updated_At: config.utcDefault(),
          };
          let Option = {
            new: true,
          };
          userSchema.findByIdAndUpdate(
            receivedValues.userID,
            fieldToSet,
            Option,
            (err, updatedData) => {
              if (err) {
                console.log(err);
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: config.errMessage,
                });
                return;
              } else {
                res.json({
                  code: config.successCode,
                  status: "Success",
                  message:
                    "Le mot de passe de l'utilisateur a été modifié avec succès.",
                  data: updatedData,
                });
              }
            }
          );
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "L'utilisateur n'existe pas.",
          });
        }
      });
  }
};

exports.changePasswordProfil = (req, res) => {
  var receivedValues = req.body;
  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    userSchema
      .findOne({
        _id: req.user._id,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          const currentPwdBytes = CryptoTS.AES.decrypt(
            req.body.currentPwd.toString(),
            config.secret
          );
          const currentPwdString = currentPwdBytes.toString(CryptoTS.enc.Utf8);
          const newPasswordBytes = CryptoTS.AES.decrypt(
            req.body.password.toString(),
            config.secret
          );
          const newPasswordString = newPasswordBytes.toString(
            CryptoTS.enc.Utf8
          );

          if (user.validPassword(currentPwdString)) {
            let fieldToSet;
            var userdata = new userSchema();
            fieldToSet = {
              password: userdata.generateHash(newPasswordString),
              updated_At: config.utcDefault(),
            };
            let Option = {
              new: true,
            };
            userSchema
              .findByIdAndUpdate(
                req.user._id,
                fieldToSet,
                Option,
                (err, updatedData) => {
                  if (err) {
                    console.log(err);
                    res.json({
                      code: config.errCode,
                      status: "Error",
                      message: config.errMessage,
                    });
                    return;
                  } else {
                    res.json({
                      code: config.successCode,
                      status: "Success",
                      message:
                        "Le mot de passe de l'utilisateur a été modifié avec succès.",
                      data: updatedData,
                    });
                  }
                }
              )
              .select({ __v: 0, password: 0 });
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "le mot de passe saisi est incorrect.",
            });
          }
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "L'utilisateur n'existe pas.",
          });
        }
      });
  }
};

exports.editRoleUser = (req, res) => {
  if (req.user.userRole != "admin" || req.user.userRole != "superAdmin") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Accès non autorisé.",
    });
  } else {
    var receivedValues = req.body;
    if (
      JSON.stringify(receivedValues) === "{}" ||
      receivedValues === undefined ||
      receivedValues === null
    ) {
      res.json({
        code: config.errCode,
        status: "Error",
        message: "Les données entrées ne sont pas valides.",
      });
      return;
    } else {
      userSchema
        .findOne({
          _id: receivedValues.userID,
        })
        .select({})
        .exec((err, user) => {
          if (err) {
            res.json({
              code: config.errCode,
              status: "Error",
              message: err.message,
            });
            return;
          }
          if (user) {
            let fieldToSet;
            fieldToSet = {
              userRole: receivedValues.userRole,
            };
            let Option = {
              new: true,
            };
            userSchema.findByIdAndUpdate(
              receivedValues.userID,
              fieldToSet,
              Option,
              (err, updatedData) => {
                if (err) {
                  console.log(err);
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                  return;
                } else {
                  res.json({
                    code: config.successCode,
                    status: "Success",
                    message:
                      "Le rôle de l'utilisateur a été modifié avec succès.",
                    data: updatedData,
                  });
                }
              }
            );
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "L'utilisateur n'existe pas.",
            });
          }
        });
    }
  }
};

exports.editUserImage = (req, res) => {
  var receivedValues = req.body;
  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    var userID = "";
    if (receivedValues.userID) {
      userID = receivedValues.userID;
    } else {
      userID = req.user._id;
    }

    userSchema
      .findOne({
        _id: userID,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          imagePath =
            process.cwd() +
            "/images/settings/" +
            userID +
            "-" +
            config.utcDefault() +
            "." +
            req.body.extention;
          base64Data = req.body.userImage.replace(
            "data:image/" + req.body.extention + ";base64,",
            ""
          );
          image = imagePath.split(process.cwd() + "/images/settings/")[1];

          fs.writeFile(imagePath, base64Data, "base64", function (err) {
            if (err) {
              res.json({
                code: config.errCode,
                success: false,
                message: "Failed to upload image please try again",
                data: err,
              });
              return;
            } else {
            }
          });

          let fieldToSet;
          fieldToSet = {
            userImage: "/settings/" + image,
            updated_At: config.utcDefault(),
          };
          let Option = {
            new: true,
          };
          userSchema.findByIdAndUpdate(
            userID,
            fieldToSet,
            Option,
            (err, updatedData) => {
              if (err) {
                console.log(err);
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: config.errMessage,
                });
                return;
              } else {
                res.json({
                  code: config.successCode,
                  status: "Success",
                  message:
                    "L'image du profil de l'utilisateur a été modifié avec succès.",
                  data: updatedData,
                });
              }
            }
          );
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "L'utilisateur n'existe pas.",
          });
        }
      });
  }
};

exports.getUsersClient = (req, res) => {
  if (req.user.userRole != "admin" && req.user.userRole != "superAdmin") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Accès non autorisé.",
    });
  } else {
    var receivedValues = req.body;
    const offset = (req.body.pageOffset - 1) * req.body.limit;
    userSchema
      .find({
        firstName: {
          $regex: new RegExp(
            ".*" + receivedValues.firstName.toLowerCase() + ".*",
            "i"
          ),
        },
        userDeleted: false,
        clientID: receivedValues.clientID,
      })
      .lean()
      .countDocuments()
      .then((counts) => {
        return counts;
      })
      .then((totalUsers) => {
        if (!totalUsers || totalUsers === 0) {
          res.json({
            code: config.successCode,
            status: "Error",
            message: "Aucun utilisateur trouvé.",
          });
          return;
        } else {
          userSchema
            .find({
              firstName: {
                $regex: new RegExp(
                  ".*" + receivedValues.firstName.toLowerCase() + ".*",
                  "i"
                ),
              },
              userDeleted: false,
              clientID: receivedValues.clientID,
            })

            .sort({ [req.body.sortBy]: req.body.orderBy })
            .skip(offset)
            .limit(req.body.limit)
            .select({ __v: 0, password: 0 })
            .lean()
            .exec((err, listusers) => {
              if (err) {
                console.log(err);
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: config.errMessage,
                });
                return;
              } else {
                res.json({
                  code: config.successCode,
                  status: "success",
                  data: {
                    listUsers: listusers,
                    totalUsers: totalUsers,
                    totalPages: Math.ceil(totalUsers / req.body.limit),
                  },
                });
              }
            });
        }
      });
  }
};

exports.editUser = (req, res) => {
  var receivedValues = req.body;

  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    userSchema
      .findOne({
        _id: receivedValues.userID,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {

          const bytesEmail = CryptoTS.AES.decrypt(
            receivedValues.email.toString(),
            config.secret
          );
          const emailString = bytesEmail.toString(CryptoTS.enc.Utf8);
          userSchema
            .findOne({
              email: emailString,
            })
            .select({})
            .exec((err, userInfo) => {
              if (err) {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: err.message,
                });
                return;
              }

              var update = false;
              if (userInfo) {
                var userJson = JSON.parse(JSON.stringify(user));
                var userInfoJson = JSON.parse(JSON.stringify(userInfo));
                if (userJson._id == userInfoJson._id) {
                  update = true;
                } else {
                  update = false;
                }
              } else {
                update = true;
              }

              if (update) {

                let fieldToSet;
                if (receivedValues.password != undefined) {
                  var userdata = new userSchema();
                  const newPasswordBytes = CryptoTS.AES.decrypt(
                    receivedValues.password.toString(),
                    config.secret
                  );
                  const newPasswordString = newPasswordBytes.toString(
                    CryptoTS.enc.Utf8
                  );

                  fieldToSet = {
                    firstName: capitalizeFirstLetter(receivedValues.firstName.trim().toLowerCase()),
                    lastName: receivedValues.lastName.trim().toUpperCase(),
                    email: emailString.trim().toLowerCase(),
                    clientID: receivedValues.clientID,
                    userRole: receivedValues.userRole,
                    password: userdata.generateHash(newPasswordString),
                    permissionServicesShow: receivedValues.permissionServicesShow,
                    permissionServicesValidate:
                      receivedValues.permissionServicesValidate,
                    permissionServicesCreate: receivedValues.permissionServicesCreate,
                  };
                } else {
                  fieldToSet = {
                    firstName: capitalizeFirstLetter(receivedValues.firstName.trim().toLowerCase()),
                    lastName: receivedValues.lastName.trim().toUpperCase(),
                    email: emailString.trim().toLowerCase(),
                    clientID: receivedValues.clientID,
                    userRole: receivedValues.userRole,
                    permissionServicesShow: receivedValues.permissionServicesShow,
                    permissionServicesValidate:
                      receivedValues.permissionServicesValidate,
                    permissionServicesCreate: receivedValues.permissionServicesCreate,
                  };
                }

                let Option = {
                  new: false,
                };
                userSchema.findByIdAndUpdate(
                  receivedValues.userID,
                  fieldToSet,
                  Option,
                  (err, updatedData) => {
                    if (err) {
                      console.log(err);
                      res.json({
                        code: config.errCode,
                        status: "Error",
                        message: config.errMessage,
                      });
                      return;
                    } else {
                      res.json({
                        code: config.successCode,
                        status: "Success",
                        message: "L'utilisateur a été modifié avec succès.",
                        data: updatedData,
                      });
                    }
                  }
                );

              } else {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: "L'adresse email est déjà utilisée.",
                });
              }
            });

        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "Aucun utilisateur trouvé.",
          });
        }
      });
  }
};

exports.editUserProfil = (req, res) => {
  var receivedValues = req.body;

  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    userSchema
      .findOne({
        _id: req.user._id,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          const bytesEmail = CryptoTS.AES.decrypt(
            receivedValues.email.toString(),
            config.secret
          );
          const emailString = bytesEmail.toString(CryptoTS.enc.Utf8);
          userSchema
            .findOne({
              email: emailString,
            })
            .select({})
            .exec((err, user) => {
              if (err) {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: err.message,
                });
                return;
              }

              var change = false;
              if (user) {
                var userJson = JSON.parse(JSON.stringify(user));
                if (userJson._id == req.user._id)
                  change = true;
              }

              if (change) {

                let fieldToSet;
                fieldToSet = {
                  firstName: capitalizeFirstLetter(receivedValues.firstName.trim().toLowerCase()),
                  lastName: receivedValues.lastName.trim().toUpperCase(),
                  email: emailString.trim().toLowerCase(),
                };
                let Option = {
                  new: true,
                };
                userSchema.findByIdAndUpdate(
                  req.user._id,
                  fieldToSet,
                  Option,
                  (err, updatedData) => {
                    if (err) {
                      console.log(err);
                      res.json({
                        code: config.errCode,
                        status: "Error",
                        message: config.errMessage,
                      });
                      return;
                    } else {
                      res.json({
                        code: config.successCode,
                        status: "Success",
                        message: "L'utilisateur a été modifié avec succès.",
                        data: updatedData,
                      });
                    }
                  }
                );
              } else {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: "L'adresse email est déjà utilisée.",
                });
              }
            });

        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "Aucun utilisateur trouvé.",
          });
        }
      });
  }
};

exports.getPermissionsUser = (req, res) => {
  var receivedValues = req.body;
  userID = receivedValues.userID;

  userSchema
    .findOne({
      _id: userID,
    })
    .select({ __v: 0, password: 0 })
    .populate("clientID")
    .exec((err, user) => {
      if (err) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: err.message,
        });
        return;
      }
      if (user) {
        res.json({
          code: config.successCode,
          status: "success",
          data: [
            user.permissionServicesShow,
            user.permissionServicesValidate,
            user.permissionServicesCreate,
          ],
        });
      } else {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Aucun utilisateur trouvé.",
        });
      }
    });
};

function capitalizeFirstLetter(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
};

exports.createUser = (req, res) => {
  const bytesPassword = CryptoTS.AES.decrypt(
    req.body.password.toString(),
    config.secret
  );
  const passwordString = bytesPassword.toString(CryptoTS.enc.Utf8);
  const bytesEmail = CryptoTS.AES.decrypt(
    req.body.email.toString(),
    config.secret
  );
  const emailString = bytesEmail.toString(CryptoTS.enc.Utf8);
  const receivedValues = req.body;


  if (JSON.stringify(receivedValues) === "{}") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
  } else {
    userSchema
      .findOne({
        email: emailString,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (!user) {
          let userInfo;
          var userdata = new userSchema();
          userInfo = {
            mobile: receivedValues.mobile,
            firstName: capitalizeFirstLetter(receivedValues.firstName.trim().toLowerCase()),
            lastName: receivedValues.lastName.trim().toUpperCase(),
            email: emailString.trim().toLowerCase(),
            userRole: receivedValues.userRole,
            userActivated: true,
            userDeleted: false,
            clientID: receivedValues.clientID,
            permissionServicesShow: receivedValues.permissionServicesShow,
            permissionServicesValidate:
              receivedValues.permissionServicesValidate,
            permissionServicesCreate: receivedValues.permissionServicesCreate,
            password: userdata.generateHash(passwordString),
          };
          userSchema.create(userInfo, (err, result) => {
            if (!err) {
              res.json({
                code: config.successCode,
                status: "L'utilisateur a été créé avec succès.",
                data: result,
              });
            } else {
              res.json({
                code: config.errCode,
                status: "err",
                message: "Erreur lors de la création de l'utilisateur.",
              });
            }
          });
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "L'adresse email est déjà utilisée.",
          });
        }
      });
  }
  // }
};

exports.editUserPermissions = (req, res) => {
  var receivedValues = req.body;

  if (
    JSON.stringify(receivedValues) === "{}" ||
    receivedValues === undefined ||
    receivedValues === null
  ) {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
    return;
  } else {
    userSchema
      .findOne({
        _id: receivedValues.userID,
      })
      .select({})
      .exec((err, user) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
          });
          return;
        }
        if (user) {
          let fieldToSet;
          fieldToSet = {
            permissionServicesShow: receivedValues.permissionServicesShow.map(
              (s) => mongoose.Types.ObjectId(s)
            ),
            permissionServicesValidate:
              receivedValues.permissionServicesValidate.map((s) =>
                mongoose.Types.ObjectId(s)
              ),
            permissionServicesCreate:
              receivedValues.permissionServicesCreate.map((s) =>
                mongoose.Types.ObjectId(s)
              ),
          };
          let Option = {
            new: false,
          };
          userSchema.findByIdAndUpdate(
            receivedValues.userID,
            fieldToSet,
            Option,
            (err, updatedData) => {
              if (err) {
                console.log(err);
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: config.errMessage,
                });
                return;
              } else {
                res.json({
                  code: config.successCode,
                  status: "Success",
                  message:
                    "Les permissions de l'utilisateur ont bien été modifiées avec succès.",
                  data: updatedData,
                });
              }
            }
          );
        } else {
          res.json({
            code: config.errCode,
            status: "Error",
            message: "Aucun utilisateur trouvé.",
          });
        }
      });
  }
};
