// ********************************************************** Page controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const pageSchema = mongoose.model('page');


// ********************************************************* page API *********************************************** //


exports.createEditPage = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        pageSchema.findOne({
            _id: receivedValues.pageID
        })
            .select({ _id: 1 })
            .exec((err, pageInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!pageInfo) {
                    pageSchema.findOne({
                        titlePage: receivedValues.titlePage.trim()
                    }).select({ _id: 1 })
                        .exec((err, page) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!page) {
                                let pageData;
                                pageData = {
                                    titlePage: !receivedValues.titlePage ? '' : receivedValues.titlePage.trim(),
                                    contentPage: !receivedValues.contentPage ? '' : receivedValues.contentPage.trim(),
                                    pageActivated: receivedValues.pageActivated
                                };
                                pageSchema.create(pageData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La page a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de la page.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le titre de la page existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    pageSchema.findOne({
                        titlePage: receivedValues.titlePage.trim()
                    }).select({ _id: 1 })
                        .exec((err, page) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (page) {
                                var pageJson = JSON.parse(JSON.stringify(page));
                                var pageInfoJson = JSON.parse(JSON.stringify(pageInfo));
                                if (pageJson._id == pageInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let pageData;
                                pageData = {
                                    titlePage: !receivedValues.titlePage ? '' : receivedValues.titlePage.trim(),
                                    contentPage: !receivedValues.contentPage ? '' : receivedValues.contentPage.trim(),
                                    pageActivated: receivedValues.pageActivated,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                pageSchema.findByIdAndUpdate(pageInfo._id, pageData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La page a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le titre de la page existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getPages = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    pageSchema.find({
        titlePage: { $regex: new RegExp('.*' + receivedValues.titlePage.toLowerCase() + '.*', "i") },
        pageActivated:true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalPage) => {
            if (!totalPage || totalPage === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune page trouvée.",
                });
                return;
            } else {
                pageSchema.find({
                    titlePage: { $regex: new RegExp('.*' + receivedValues.titlePage.toLowerCase() + '.*', "i") },
                    pageActivated:true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .collation({ locale: "fr" })
                    .exec((err, listPages) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listPages: listPages,
                                    totalPages: totalPage,
                                    totalPages: Math.ceil(totalPage / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deletePageByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["pageID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'pageID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        pageSchema.deleteOne({
            _id: receivedValues.pageID
        }).exec((err, pageInfo) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            }
            if (pageInfo.deletedCount === 1) {
                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "message": "La page a été supprimée avec succès."
                });
            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
            }
        });
    }
};

exports.activatedPage = (req, res) =>{
    var receivedValues = req.body;
    pageSchema.find({
            pageID: receivedValues.pageID
        })
            .lean()
            .exec((err, page) => {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    if (page) {

                        let fieldToSet;
                        fieldToSet = {
                            pageActivated: receivedValues.pageActivated,
                            updatedAt: config.utcDefault()
                        };
                        let Option = {
                            new: true
                        };
                        pageSchema.findByIdAndUpdate(receivedValues.pageID, fieldToSet, Option, (err, updatedData) => {
                            if (err) {
                                console.log(err);
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": config.errMessage,
                                });
                                return;
                            } else {
                                res.json({
                                    "code": config.successCode,
                                    "status": "Success",
                                    "message": "La page a été modifiée avec succès.",
                                    "data": updatedData
                                });
                            }
                        });


                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": "Aucune page trouvée."
                        });
                    }
                }
            });
};