var express = require("express");
var mongoose = require("mongoose");
var ip = require("ip");
var fs = require("fs");
var bodyParser = require("body-parser");
var app = express();
var config = require("./config");
var useragent = require("express-useragent");
const { spawn } = require("child_process");
const cron = require("node-cron");
const path = require("path");
var autoIncrement = require('mongoose-auto-increment');

mongoose.Promise = global.Promise;
module.exports = mongoose;
mongoose.connect(
  config.database,
  {
    useNewUrlParser: true,
    useUnifiedTopology: true,
    useCreateIndex: true,
    autoIndex: true,
  },
  function (err, data) {
    if (err) {
      console.log("Sorry can not connect with mongodb...");
    } else if (data) {
      console.log("Successfully YUGEN-API connected mongodb...");
      return;
    }
  }
);
mongoose.set("useFindAndModify", false);
mongoose.set("useCreateIndex", true);

autoIncrement.initialize(mongoose.connection);

// HTTPS
const host = ip.address();
var https = require("https");
var http = require("http");

if (host == "51.75.195.207") {
  var options = {
    key: fs.readFileSync("./ssl/ssl.cert", "utf8"),
    cert: fs.readFileSync("./ssl/ssl.key", "utf8"),
    requestCert: false,
    rejectUnauthorized: false,
  };
  https.createServer(app, options);
  app.listen(config.https_port, host, function () {
    console.log(`YUGEN-API server running on ${host}:`, config.https_port);
  });
} else {
  http.createServer(app);
  app.listen(config.http_port, function () {
    console.log("YUGEN-API server running on ", config.http_port);
  });
}

app.set("views", __dirname + "/views");
app.set("view engine", "ejs");
app.use(
  bodyParser.json({
    limit: "50mb",
  })
);
app.use(
  bodyParser.urlencoded({
    limit: "50mb",
    extended: true,
    parameterLimit: 50000,
  })
);

var enableCORS = function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Methods", "GET,POST");
  res.header(
    "Access-Control-Allow-Headers",
    "Content-Type, token, Content-Length, X-Requested-With, *"
  );
  if ("OPTIONS" === req.method) {
    res.sendStatus(200);
  } else {
    next();
  }
};
app.use(enableCORS);

app.use(useragent.express());

var models_path = __dirname + "/model";
fs.readdirSync(models_path).forEach(function (file) {
  if (~file.indexOf(".js")) require(models_path + "/" + file);
});

// Routes
require("./routes")(app);

process.on("uncaughtException", function (err) {
  console.log("Caught exception: " + err);
  console.log(err.stack);
});

app.use(express.static(__dirname + "/images"));

// 1. Cron expression for every 5 seconds - */5 * * * * *
// 2. Cron expression for every night at 00:00 hours (0 0 * * * )
// Note: 2nd expression only contains 5 fields, since seconds is not necessary

// Scheduling the backup every 5 seconds (using node-cron)
cron.schedule("30 */12 * * *", () => backupMongoDB());

function backupMongoDB() {
  const ARCHIVE_PATH = path.join(
    __dirname,
    "public",
    "YUGEN-DB" + config.utcDefault() + ".gzip"
  );
  const child = spawn("mongodump", [
    "--uri="+ config.database,
    "--db=YUGEN-DB",
    `--archive=${ARCHIVE_PATH}`,
    "--gzip",
  ]);

  child.stdout.on("data", (data) => {
    console.log("stdout:\n", data);
  });
  child.stderr.on("data", (data) => {
    console.log("stderr:\n", Buffer.from(data).toString());
  });
  child.on("error", (error) => {
    console.log("error:\n", error);
  });
  child.on("exit", (code, signal) => {
    if (code) console.log("Process exit with code:", code);
    else if (signal) console.log("Process killed with signal:", signal);
    else console.log("Backup is successfull ✅");
  });
}
