import { BlockCipher } from '../lib/BlockCipher';
import { BlockCipherModeAlgorithm } from './BlockCipherModeAlgorithm';
export declare abstract class BlockCipherMode {
    static Encryptor: any;
    static Decryptor: any;
    /**
     * Creates this mode for encryption.
     *
     * @param cipher A block cipher instance.
     * @param iv The IV words.
     *
     * @example
     *
     *     var mode = CBC.createEncryptor(cipher, iv.words);
     */
    static createEncryptor(cipher: BlockCipher, iv: Array<number>): BlockCipherModeAlgorithm;
    /**
     * Creates this mode for decryption.
     *
     * @param cipher A block cipher instance.
     * @param iv The IV words.
     *
     * @example
     *
     *     var mode = CBC.createDecryptor(cipher, iv.words);
     */
    static createDecryptor(cipher: BlockCipher, iv: Array<number>): BlockCipherModeAlgorithm;
}
