import { WordArray } from '../lib/WordArray';
import { BufferedBlockAlgorithmConfig } from './BufferedBlockAlgorithmConfig';
export declare abstract class BufferedBlockAlgorithm {
    _minBufferSize: number;
    _data: WordArray;
    _nDataBytes: number;
    cfg: BufferedBlockAlgorithmConfig;
    abstract _doProcessBlock(wordArray: Array<number>, offset: number): void;
    constructor(cfg?: BufferedBlockAlgorithmConfig);
    /**
     * Resets this block algorithm's data buffer to its initial state.
     *
     * @example
     *
     *     bufferedBlockAlgorithm.reset();
     */
    reset(): void;
    /**
     * Adds new data to this block algorithm's buffer.
     *
     * @param data The data to append. Strings are converted to a WordArray using UTF-8.
     *
     * @example
     *
     *     bufferedBlockAlgorithm._append('data');
     *     bufferedBlockAlgorithm._append(wordArray);
     */
    _append(data: string | WordArray): void;
    /**
     * Processes available data blocks.
     *
     * This method invokes _doProcessBlock(offset), which must be implemented by a concrete subtype.
     *
     * @param doFlush Whether all blocks and partial blocks should be processed.
     *
     * @return The processed data.
     *
     * @example
     *
     *     let processedData = bufferedBlockAlgorithm._process();
     *     let processedData = bufferedBlockAlgorithm._process(!!'flush');
     */
    _process(doFlush?: boolean): WordArray;
    /**
     * Creates a copy of this object.
     *
     * @return The clone.
     *
     * @example
     *
     *     let clone = bufferedBlockAlgorithm.clone();
     */
    clone(): BufferedBlockAlgorithm;
}
