import { BufferedBlockAlgorithm } from '../lib/BufferedBlockAlgorithm';
import { BufferedBlockAlgorithmConfig } from '../lib/BufferedBlockAlgorithmConfig';
import { WordArray } from '../lib/WordArray';
export declare abstract class Hasher extends BufferedBlockAlgorithm {
    /**
     * Creates a shortcut function to a hasher's object interface.
     *
     * @param hasher The hasher to create a helper for.
     *
     * @return The shortcut function.
     *
     * @example
     *
     *     let SHA256 = Hasher._createHelper(SHA256);
     */
    static _createHelper(hasher: typeof Hasher): (message: string | WordArray, cfg?: BufferedBlockAlgorithmConfig | undefined) => any;
    /**
     * Initializes a newly created hasher.
     *
     * @param cfg (Optional) The configuration options to use for this hash computation.
     *
     * @example
     *
     *     let hasher = CryptoJS.algo.SHA256.create();
     */
    constructor(cfg?: BufferedBlockAlgorithmConfig);
    /**
     * Updates this hasher with a message.
     *
     * @param messageUpdate The message to append.
     *
     * @return This hasher.
     *
     * @example
     *
     *     hasher.update('message');
     *     hasher.update(wordArray);
     */
    update(messageUpdate: WordArray | string): Hasher;
    /**
     * Finalizes the hash computation.
     * Note that the finalize operation is effectively a destructive, read-once operation.
     *
     * @param messageUpdate (Optional) A final message update.
     *
     * @return The hash.
     *
     * @example
     *
     *     let hash = hasher.finalize();
     *     let hash = hasher.finalize('message');
     *     let hash = hasher.finalize(wordArray);
     */
    finalize(messageUpdate: WordArray | string): WordArray;
    abstract _doFinalize(): WordArray;
}
