import { CipherParams } from '../lib/CipherParams';
export declare class OpenSSL {
    /**
     * Converts a cipher params object to an OpenSSL-compatible string.
     *
     * @param cipherParams The cipher params object.
     *
     * @return The OpenSSL-compatible string.
     *
     * @example
     *
     *     let openSSLString = OpenSSLFormatter.stringify(cipherParams);
     */
    static stringify(cipherParams: CipherParams): string;
    /**
     * Converts an OpenSSL-compatible string to a cipher params object.
     *
     * @param openSSLStr The OpenSSL-compatible string.
     *
     * @return The cipher params object.
     *
     * @example
     *
     *     let cipherParams = OpenSSLFormatter.parse(openSSLString);
     */
    static parse(openSSLStr: string): CipherParams;
}
