// ********************************************************** activite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const matriceSchema = mongoose.model('matrice');


// ********************************************************* activite API *********************************************** //

var matriceJson = [
        {
            nbrCritere: 10,
            libeleCritere: "Degré 10",
            complexiteActiviteCommentaire: "NA",
            complexiteActivite: "Conception de programmes/projets/stratégies visant à anticiper des évolutions de l'environnement pour l'ensemble de l'organisation",
            ConnaissanceCommentaire: "NA",
            Connaissance: "L'emploi nécessite la création de connaissances qui font référence",
            AutonomieCommentaire: "Orientations stratégiques : Orientations qui conditionnent l'évolution de l'organisation et qui engagent sa pérennité<br>Validation par les résultats : Par l'atteinte des finalités visées par l'organisation",
            Autonomie: "L'emploi nécessite de définir des orientations stratégiques et les moyens associés avec validation par les résultats",
            ContributionCommentaire: "Entité économique : Renvoie à une logique économique (de type « business unit »/domaine d'activités stratégiques) qui se distingue d'autres logiques organisationnelles (juridique, organigramme hiérarchique...)",
            Contribution: "L'emploi engage la perennité de l'organisation/entité économique",
            encadrementcooperationCommentaire: "NA",
            encadrementcooperation: "Direction/coordination de la totalité de l'organisation",
            communicationCommentaire: "NA",
            communication: "L'emploi nécessite la mobilisation d'acteurs décisionnaires clés"
        },
        {
            nbrCritere: 9,
            libeleCritere: "Degré 9",
            complexiteActiviteCommentaire: "Systèmes/modèles : Dans un environnement global, ensemble de processus combinés<br>Domaine professionnel (ou domaine) : Filière ou famille résultant de l'organisation de l'entreprise (cf. tableau illustratif)",
            complexiteActivite: "Elaboration de systèmes/modèles couvrant plusieurs domaines professionnels ou une expertise avancée dans l'un d'eux",
            ConnaissanceCommentaire: "Connaissances hautement spécialisées : Permettant l'élaboration de concepts innovants/fondamentaux pour des développements à long terme<br>Discipline : Champ(s) académique(s) (technique, scientifique...) pouvant conduire à des spécialités",
            Connaissance: "L'emploi nécessite des connaissances hautement spécialisées dans une discipline",
            AutonomieCommentaire: "Orientations : Lignes directrices (techniques/organisationnelles/financières/commerciales/administratives...)<br>Validation par les résultats : Par l'atteinte des finalités visées par l'organisation",
            Autonomie: "L'emploi requiert de définir des orientations liées à l'organisation générale avec optimisation des moyens et validation par les résultats",
            ContributionCommentaire: "Performance : Mobilisation/optimisation des moyens et des ressources de son périmètre en vue d'obtenir le résultat attendu<br>Entité économique : Renvoie à une logique économique (de type « business unit »/domaine d'activités stratégiques) qui se distingue d'autres logiques organisationnelles (juridique, organigramme hiérarchique...)",
            Contribution: "L'emploi engage la performance à long terme de l'organisation/entité économique",
            encadrementcooperationCommentaire: "Sous-ensemble de l'organisation : Un des secteurs majeurs/significatifs de l'organisation",
            encadrementcooperation: "Direction/coordination sur un sous-ensemble de l'organisation",
            communicationCommentaire: "Négociation complexe : Recherche d'accords multi-acteurs/multi-facteurs/multi-culturel dans un périmètre large et sur une période longue<br>Représentation : S'exerce en fonction de la situation, du contexte, de l'environnement pouvant aller jusqu'à l'engagement de l'organisation<br>Enjeux stratégiques : De nature à assurer la pérennité de l'organisation",
            communication: "L'emploi nécessite négociations complexes et représentation en lien avec les enjeux stratégiques"
        },
        {
            nbrCritere: 8,
            libeleCritere: "Degré 8",
            complexiteActiviteCommentaire: "Processus : Enchaînement/combinaison/articulation structuré d'étapes. pour envisager/traiter une situation/un programme d'ensemble et pour répondre à une mission/un objectif (assurer une fabrication, maintenir les infrastructures et équipements, piloter les flux logistiques, assurer un service après-vente, organiser les achats, structurer une démarche qualité, développer une solution, exploiter les données financières...)<br>Domaine professionnel (ou domaine) : Filière ou famille résultant de l'organisation de l'entreprise (cf. tableau illustratif)",
            complexiteActivite: "Elaboration de processus majeurs dans un ou plusieurs domaines professionnels",
            ConnaissanceCommentaire: "Connaissances spécialisées : Permettant l'élaboration de concepts destinés à développer des travaux/projets/plans d'action<br>Discipline : Champ(s) académique(s) (technique, scientifique...) pouvant conduire à des spécialités<br>Connaissances approfondies : Permettant la mobilisation de concepts destinés à conduire des travaux/projets ou définir des plans d'action",
            Connaissance: "L'emploi nécessite des connaissances spécialisées dans une discipline ou des connaissances approfondies dans plusieurs disciplines",
            AutonomieCommentaire: "Orientations : Lignes directrices (techniques/organisationnelles/financières/commerciales/administratives...)<br>Validation par les résultats : Par l'atteinte des finalités visées par l'organisation",
            Autonomie: "L'emploi requiert de déterminer des orientations et l'adaptation des moyens alloués avec validation par les résultats",
            ContributionCommentaire: "Développement : Structuration organisationnelle<br>Sous-ensemble de l'organisation : Un des secteurs majeurs/significatifs de l'organisation<br>Entité économique : Renvoie à une logique économique (de type « business unit »/domaine d'activités stratégiques) qui se distingue d'autres logiques organisationnelles (juridique, organigramme hiérarchique...)",
            Contribution: "L'emploi engage le développement d'un sous-ensemble de l'organisation/entité économique",
            encadrementcooperationCommentaire: "Encadrement hiérarchique : Organisation et direction du travail d'autrui ou d'équipes avec lien de subordination, réalisation de l'entretien d'appréciation individuel (atteinte des résultats de l'équipe, optimisation des ressources/de l'organisation, développement des compétences, promotions, propositions salariales, application des règles collectives...)",
            encadrementcooperation: "Encadrement hiérarchique d'encadrants hiérarchiques et/ou coordination d'un ensemble de ressources/moyens",
            communicationCommentaire: "Négociation : Recherche d'un accord qui engage les parties<br>Représentation : S'exerce en fonction de la situation, du contexte, de l'environnement pouvant aller jusqu'à l'engagement de l'organisation<br>Acteurs majeurs et diversifiés : Décideurs présents dans des institutions/instances/organisations différentes",
            communication: "L'emploi nécessite négociations et représentation avec des acteurs majeurs et diversifiés"
        },
        {
            nbrCritere: 7,
            libeleCritere: "Degré 7",
            complexiteActiviteCommentaire: "Analyse : Raisonnement formalisé consistant à décomposer un tout en ses éléments constituants et à en établir les relations afin de construire recommandations, préconisations ou plans d'action opérationnels<br>Etude : Investigation d'un sujet conduisant à une recherche globale et approfondie visant à construire/élaborer/structurer des supports présentant des données complexes et des concepts permettant d'orienter l'action<br>Techniques : Ensemble des procédés et des technologies d'une profession/d'un métier (cf. tableau illustratif)",
            complexiteActivite: "Analyses et études nécessitant la combinaison d'un ensemble de techniques ou une spécialisation dans l'une d'elles",
            ConnaissanceCommentaire: "Connaissances approfondies : Permettant la mobilisation de concepts destinés à conduire des travaux/projets ou définir des plans d'action<br>Connaissances générales : Permettant le développement de raisonnements conduisant à formaliser/construire des actions à visée opérationnelle<br>Discipline : Champ(s) académique(s) (technique, scientifique...) pouvant conduire à des spécialités",
            Connaissance: "L'emploi nécessite des connaissances approfondies dans une discipline ou des connaissances générales dans plusieurs disciplines",
            AutonomieCommentaire: "Méthodes : Ensemble de règles et de principes mobilisés de manière ordonnée et logique pour parvenir à un résultat<br>Procédés : Techniques de transformation de matières/produits/informations en vue d'atteindre un résultat<br>Validation sur demande : Action visant à approuver l'ensemble d'un processus, mesurer l'avancement d'un projet, confirmer la réalisation d'une mission",
            Autonomie: "L'emploi requiert de déterminer des méthodes/procédés/ moyens avec validation sur demande",
            ContributionCommentaire: "Performance : Mobilisation/optimisation des moyens et des ressources de son périmètre en vue d'obtenir le résultat attendu<br>Sous-ensemble de l'organisation : Un des secteurs majeurs/significatifs de l'organisation<br>Entité économique : Renvoie à une logique économique (de type « business unit »/domaine d'activités stratégiques) qui se distingue d'autres logiques organisationnelles (juridique, organigramme hiérarchique...)",
            Contribution: "L'emploi engage la performance d'un sous-ensemble de l'organisation/entité économique",
            encadrementcooperationCommentaire: "Encadrement hiérarchique : Organisation et direction du travail d'autrui ou d'équipes avec lien de subordination, réalisation de l'entretien d'appréciation individuel (atteinte des résultats de l'équipe, optimisation des ressources/de l'organisation, développement des compétences, promotions, propositions salariales, application des règles collectives...)",
            encadrementcooperation: "Encadrement hiérarchique d'équipes de travail et/ou coordination d'un sous-ensemble de ressources/moyens",
            communicationCommentaire: "NA",
            communication: "L'emploi nécessite la recherche de l'adhésion/du compromis dans un contexte d'intérêts différents/divergents avec enjeux significatifs"
        },
        {
            nbrCritere: 6,
            libeleCritere: "Degré 6",
            complexiteActiviteCommentaire: "Analyse : Raisonnement formalisé consistant à décomposer un tout en ses éléments constituants et à en établir les relations afin de construire recommandations, préconisations ou plans d'action opérationnels<br>Processus : Enchaînement/combinaison/articulation structuré d'étapes. pour envisager/traiter une situation/un programme d'ensemble et pour répondre à une mission/un objectif (assurer une fabrication, maintenir les infrastructures et équipements, piloter les flux logistiques, assurer un service après-vente, organiser les achats, structurer une démarche qualité, développer une solution, exploiter les données financières...)<br>Méthodes : Ensemble de règles et de principes mobilisés de manière ordonnée et logique<br>Techniques : Ensemble des procédés et des technologies d'une profession/d'un métier (cf. tableau illustratif)",
            complexiteActivite: "Analyses destinées à définir et mettre en œuvre des processus nécessitant la mobilisation de méthodes ou de techniques diversifiées",
            ConnaissanceCommentaire: "Connaissances approfondies : Permettant la mobilisation de concepts destinés à conduire des travaux/projets ou définir des plans d'action<br>Discipline : Champ(s) académique(s) (technique, scientifique...) pouvant conduire à des spécialités",
            Connaissance: "L'emploi nécessite des connaissances approfondies dans une partie d'une discipline",
            AutonomieCommentaire: "Méthodes : Ensemble de règles et de principes mobilisés de manière ordonnée et logique pour parvenir à un résultat<br>Validation : Action visant à approuver l'ensemble d'un processus, mesurer l'avancement d'un projet, confirmer la réalisation d'une mission",
            Autonomie: "L'emploi requiert de déterminer des solutions, d'optimiser des méthodes et moyens avec validation à l'initiative d'un tiers",
            ContributionCommentaire: "Transformation : Adaptation/évolution/croissance d'activités, de produits ou de services<br>Performance : Mobilisation/optimisation des moyens et des ressources de son périmètre en vue d'obtenir le résultat attendu",
            Contribution: "L'emploi engage la transformation et la performance d'un service ou d'un département",
            encadrementcooperationCommentaire: "Coordination d'activités diversifiées : Pilotage d'un travail collectif visant à organiser une mission combinant plusieurs actions/plusieurs types d'acteurs, pluridisciplinaires ou non",
            encadrementcooperation: "Encadrement hiérarchique d'une équipe de travail incluant l'appréciation individuelle et/ou coordination d'activités diversifiées",
            communicationCommentaire: "Coopération et partenariat : Mise en place de relations entre structures visant à construire des principes/actions/contrats/accords fondés sur une vision partagée",
            communication: "L'emploi nécessite coopération et partenariat avec des représentants d'autres entités"
        },
        {
            nbrCritere: 5,
            libeleCritere: "Degré 5",
            complexiteActiviteCommentaire: "Activité : Ensemble de tâches cohérentes réalisées en situation professionnelle<br>Méthodes : Ensemble de règles et de principes mobilisés de manière ordonnée et logique pour parvenir à un résultat<br>Diagnostic : Identification d'un dysfonctionnement et de ses causes à partir d'un raisonnement méthodique",
            complexiteActivite: "Réalisation d'activités avec choix et mise en œuvre de méthodes/outils répertoriés, réalisation de diagnostics destinés à anticiper/résoudre les difficultés",
            ConnaissanceCommentaire: "Connaissances générales : Permettant le développement de raisonnements conduisant à formaliser/construire des actions à visée opérationnelle<br>Discipline : Champ(s) académique(s) (technique, scientifique...) pouvant conduire à des spécialités",
            Connaissance: "L'emploi nécessite des connaissances générales dans une partie d'une discipline",
            AutonomieCommentaire: "Validation : Action visant à approuver l'ensemble d'un processus, mesurer l'avancement d'un projet, confirmer la réalisation d'une mission",
            Autonomie: "L'emploi requiert de modifier des solutions partiellement identifiées avec validation à l'initiative d'un tiers",
            ContributionCommentaire: "NA",
            Contribution: "L'emploi implique des décisions dont les effets se produisent sur un service ou un département",
            encadrementcooperationCommentaire: "Coordination des activités : Pilotage d'un travail collectif visant à organiser une action dans un cadre délimité<br>Transmission de savoirs et de pratiques : Organisation des apprentissages, assistance pédagogique, suivi du processus d'acquisition des connaissances et savoir-faire, évaluation des acquis",
            encadrementcooperation: "Animation/répartition/appui/ supervision/coordination des activités ou transmission collective de savoirs et de pratiques",
            communicationCommentaire: "NA",
            communication: "L'emploi nécessite de parvenir à des constats/décisions partagés/concertés avec des interlocuteurs à impliquer"
        },
        {
            nbrCritere: 4,
            libeleCritere: "Degré 4",
            complexiteActiviteCommentaire: "Activités diversifiées : Activités de nature différente, technique ou professionnelle<br>Modes opératoires : Ensemble d'opérations à suivre en vue de l'obtention du résultat",
            complexiteActivite: "Réalisation d'activités diversifiées, appréciation et traitement de difficultés variées, mise en œuvre de modes opératoires répertoriées à adapter",
            ConnaissanceCommentaire: "Connaissances professionnelles : Connaissances techniques spécifiques à un métier",
            Connaissance: "L'emploi nécessite des connaissances professionnelles théoriques et pratiques",
            AutonomieCommentaire: "Contrôle : Vérification par un tiers responsable, ou par un système, de la mise en œuvre des opérations, hors situation d'autocontrôle<br>Contrôle ponctuel : À différentes étapes prédéfinies ou de manière aléatoire",
            Autonomie: "L'emploi requiert d'adapter des solutions identifiées sous contrôle ponctuel",
            ContributionCommentaire: "Equipe de travail : Collectif de travail constituant une entité cohérente",
            Contribution: "L'emploi implique des actions déterminantes produisant des effets sur différentes équipes de travail",
            encadrementcooperationCommentaire: "Appui : Soutien/assistance apporté à d'autres salariés dans un périmètre déterminé<br>Transmission de savoirs et de pratiques : Organisation des apprentissages, assistance pédagogique, suivi du processus d'acquisition des connaissances et savoir-faire, évaluation des acquis",
            encadrementcooperation: "Appui technique/organisationnel collectif ou transmission individuelle de savoirs et de pratiques",
            communicationCommentaire: "Communication démonstrative : Nécessité d'expliquer/de justifier/d'apporter la preuve",
            communication: "L'emploi nécessite communication démonstrative, argumentation"
        },
        {
            nbrCritere: 3,
            libeleCritere: "Degré 3",
            complexiteActiviteCommentaire: "Activité : Ensemble de tâches cohérentes réalisées en situation professionnelle<br>Modes opératoires : Ensemble d'opérations à suivre en vue de l'obtention du résultat",
            complexiteActivite: "Réalisation d'activités similaires, identification des anomalies, mise en œuvre de modes opératoires répertoriées",
            ConnaissanceCommentaire: "Connaissances professionnelles : Connaissances techniques spécifiques à un métier",
            Connaissance: "L'emploi nécessite des connaissances professionnelles essentiellement pratiques",
            AutonomieCommentaire: "Contrôle : Vérification par un tiers responsable, ou par un système, de la mise en œuvre des opérations, hors situation d'autocontrôle<br>Contrôle fréquent : Souvent et à différentes étapes prédéfinies",
            Autonomie: "L'emploi requiert de sélectionner des solutions identifiées sous contrôle fréquent",
            ContributionCommentaire: "Equipe de travail : Collectif de travail constituant une entité cohérente",
            Contribution: "L'emploi a un effet sur des emplois de nature différente au sein de l'équipe de travail",
            encadrementcooperationCommentaire: "Appui : Soutien/assistance apporté à d'autres salariés dans un périmètre déterminé",
            encadrementcooperation: "Appui technique/organisationnel individuel",
            communicationCommentaire: "Ajustement des réponses : Nécessité d'adapter les questionnements/les réponses au contexte",
            communication: "L'emploi nécessite l'ajustement des réponses en fonction des interlocuteurs"
        },
        {
            nbrCritere: 2,
            libeleCritere: "Degré 2",
            complexiteActiviteCommentaire: "NA",
            complexiteActivite: "Réalisation de tâches simples et diverses, identification des anomalies en apportant les premiers éléments de compréhension",
            ConnaissanceCommentaire: "Connaissances élémentaires : Lire/écrire/compter",
            Connaissance: "L'emploi nécessite des connaissances élémentaires",
            AutonomieCommentaire: "Contrôle : Vérification par un tiers responsable, ou par un système, de la mise en œuvre des opérations, hors situation d'autocontrôle<br>Contrôle fréquent : Souvent et à différentes étapes prédéfinies",
            Autonomie: "L'emploi requiert d'appliquer des solutions identifiées sous contrôle fréquent",
            ContributionCommentaire: "NA",
            Contribution: "L'emploi a un effet sur des emplois de nature identique ou similaire",
            encadrementcooperationCommentaire: "Coopération ponctuelle : Agir conjointement de manière constante/récurrente",
            encadrementcooperation: "Partage d'expériences/connaissances et/ou coopération régulière",
            communicationCommentaire: "Environnement immédiat : Limité aux collègues de l'équipe de travail, aux fonctions support de proximité et à la hiérarchie directe",
            communication: "L'emploi nécessite questionnement, dialogue et reformulation avec des interlocuteurs de l'environnement immédiat"
        },
        {
            nbrCritere: 1,
            libeleCritere: "Degré 1",
            complexiteActiviteCommentaire: "NA",
            complexiteActivite: "Réalisation de tâches simples et répétitives, signalement des anomalies",
            ConnaissanceCommentaire: "Connaissances minimales : De la vie courante",
            Connaissance: "L'emploi nécessite des connaissances minimales",
            AutonomieCommentaire: "Contrôle : Vérification par un tiers responsable, ou par un système, de la mise en œuvre des opérations, hors situation d'autocontrôle<br>Contrôle permanent : En continu et à chaque étape",
            Autonomie: "L'emploi requiert d'exécuter des tâches simples prédéfinies sous contrôle permanent",
            ContributionCommentaire: "Activités : Ensemble de tâches cohérentes réalisées en situation professionnelle (cf. tableau illustratif)",
            Contribution: "L'emploi a un effet circonscrit à ses activités",
            encadrementcooperationCommentaire: "Coopération ponctuelle : Apporter une aide lorsque la situation le nécessite",
            encadrementcooperation: "Coopération ponctuelle",
            communicationCommentaire: "NA",
            communication: "L'emploi nécessite la compréhension des consignes et des échanges simples"
        }
    ];

exports.createEditMatrice = (req, res) => {

    matriceSchema.remove({}, (err, data) => {
    });

    matriceSchema.create(matriceJson,(err, data) => {
        if (!err) {
            res.json({
                "code": config.successCode,
                "status": "Success",
                "message": "La matrice a été créée avec succès.",
                data: data
            });
        } else {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la matrice.",
            });
            return;
        }
    });
};

exports.getMatrice = (req, res) => {
    matriceSchema.find()
        .lean()
        .sort({nbrCritere : -1})
        .exec((err, matrice) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        matrice: matrice
                    }
                });
            }
        });
};


