// ********************************************************** emploi controller ********************************************* //

const mongoose = require("mongoose");
const config = require("../config");
const emploiSchema = mongoose.model("emploi");
const notificationSchema = mongoose.model("notification");
const userSchema = mongoose.model("user");
const clientSchema = mongoose.model("client");
const sgMail = require("@sendgrid/mail");
const activiteSchema = mongoose.model('activite');
const finaliteSchema = mongoose.model('finalite');
const responsabiliteSchema = mongoose.model('responsabilite');
const relationTravailSchema = mongoose.model('relationTravail');
const connaissanceSchema = mongoose.model('connaissance');



// ********************************************************* emploi API *********************************************** //
function getRandomInt(min, max) {
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min)) + min;
}

exports.createEditEmploi = (req, res) => {
  const receivedValues = req.body;
  if (JSON.stringify(receivedValues) === "{}") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
  } else {
    emploiSchema
      .findOne({
        _id: req.body.emploiID,
      })
      .select({ _id: 1 })
      .exec((err, emploiInfo) => {
        if (err) {
          res.json({
            code: config.errCode,
            status: "Error",
            message: config.errMessage,
          });
          return;
        }
        if (!emploiInfo) {
          emploiSchema
            .findOne({
              //intitule: receivedValues.intitule.trim(),
              //intitule: { $search: receivedValues.intitule.trim(),$caseSensitive :true},
              intitule: { $regex: "^"+receivedValues.intitule.trim()+"$", $options: 'i' },
              clientID: receivedValues.clientID,
            })
            //.select({ _id: 1 })
            .exec((err, emploi) => {
              if (err) {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: err.message,
                });
                return;
              }
              if (!emploi) {
                let Option = {
                  new: true,
                };
                var count = getRandomInt(1, 100);
                clientSchema.findByIdAndUpdate(
                  receivedValues.clientID,
                  { $inc: { counterClient: count } },
                  Option,
                  (err, updatedData) => {
                    if (err) {
                      console.log(err);
                      res.json({
                        code: config.errCode,
                        status: "Error",
                        message: config.errMessage,
                      });
                      return;
                    } else {
                      let emploiData;
                      emploiData = {
                        intitule: !receivedValues.intitule
						? ""
						:receivedValues.intitule.trim(),
                        autresAppellations: !receivedValues.autresAppellations
                        ? ""
                        : receivedValues.autresAppellations.trim(),
                        commentaire: !receivedValues.commentaire
                        ? ""
                        : receivedValues.commentaire.trim(),
                        activites: receivedValues.activites,
                        responsabilites: receivedValues.responsabilites,
                        relationsTravail: receivedValues.relationsTravail,
                        connaissances: receivedValues.connaissances,
                        finalites: receivedValues.finalites,
                        refAnalyseEmploi: receivedValues.refAnalyseEmploi,
                        cotation: receivedValues.cotation,
                        classeEmploi: receivedValues.classeEmploi,
                        groupeEmploi: receivedValues.groupeEmploi,
                        isValidated: receivedValues.isValidated,
                        entiteID: receivedValues.entiteID,
                        directionID: receivedValues.directionID,
                        serviceID: receivedValues.serviceID,
                        userID: receivedValues.userID,
                        emploiActivated: receivedValues.emploiActivated,
                        clientID: receivedValues.clientID,
                        userValidatorID: receivedValues.userValidatorID,
                        id: updatedData.counterClient,
                      };
                      emploiSchema.create(emploiData, (err, data) => {
                        if (!err) {
                          userSchema
                            .find({
                              userDeleted: false,
                              clientID: receivedValues.clientID,
                            })
                            .select({ __v: 0, password: 0 })
                            .lean()
                            .exec(async (err, listusers) => {
                              if (err) {
                                console.log(err);
                                res.json({
                                  code: config.errCode,
                                  status: "Error",
                                  message: config.errMessage,
                                });
                                return;
                              } else {
                                emploiJson = JSON.parse(JSON.stringify(data));

                                for await (var item of listusers) {
                                  if (
                                    JSON.parse(
                                      JSON.stringify(
                                        item.permissionServicesShow
                                      )
                                    ).some(
                                      (e) => e === receivedValues.serviceID
                                    ) ||
                                    item.userRole != "user"
                                  ) {
                                    let notificationData;
                                    notificationData = {
                                      messageNotification: "Nouvel emploi",
                                      lienNotification: "lien",
                                      notificationStatut: false,
                                      notificationEtat: false,
                                      userID: item._id,
                                      emploiID: emploiJson._id,
                                    };
                                    await notificationSchema
                                      .create(notificationData)
                                      .then(async (notif) => {
                                        if (notif) {
                                          // var html = `
                                          // <body style="width: 100% !important;background-color: #F8F8F8;">
                                          //   <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                                          //     style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                                          //     <div class="justify-content-center d-flex">
                                          //       <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                          //         style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                          //         heigth="auto">
                                          //         <tbody>
                                          //           <tr>
                                          //             <td align="left" valign="center"
                                          //               style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                          //               <img style="width: 59px;" src="../../../../assets/logos/classif.png" />
                                          //             </td>
                                          //             <td align="right" valign="center"
                                          //               style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                          //               <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">`+ emploiJson.createdAt + `</span>
                                          //             </td>
                                          //           </tr>
                                          //           <tr>
                                          //             <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                          //               <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">Bonjour,</h3>
                                          //               <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                          //                 Un nouvel emploi vient d'être créé :
                                          //               </p>
                                          //               <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                          //                 `+ emploiJson.intitule + `.
                                          //               </p>
                                          //             </td>
                                          //           </tr>
                                          //           <tr>
                                          //             <td colSpan="2">
                                          //               <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                          //                 style="min-width:100%;border-collapse:collapse;">
                                          //                 <tbody>
                                          //                   <tr>
                                          //                     <td style="padding:15px 0px;" valign="top" align="center">
                                          //                       <table border="0" cellpadding="0" cellspacing="0" style="border-collapse:separate !important;">
                                          //                         <tbody>
                                          //                           <tr>
                                          //                             <td align="center" valign="middle" style="padding:13px;">
                                          //                               <a href="#" title="START NOW" target="_blank"
                                          //                                 style="font-size: 14px; line-height: 1.5; font-weight: 700; letter-spacing: 1px; padding: 15px 40px; text-align:center; text-decoration:none; color:#FFFFFF; border-radius: 50px; background-color:#C45824;">
                                          //                                 Se connecter</a>
                                          //                             </td>
                                          //                           </tr>
                                          //                         </tbody>
                                          //                       </table>
                                          //                     </td>
                                          //                   </tr>
                                          //                 </tbody>
                                          //               </table>
                                          //             </td>
                                          //           </tr>
                                          //         </tbody>
                                          //       </table>
                                          //     </div>
                                          //     <div class="justify-content-center d-flex">
                                          //       <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                          //         <tbody>
                                          //           <tr>
                                          //             <td align="center" valign="center">
                                          //               <p
                                          //                 style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                          //                 Problèmes ou questions? Appelez-nous au <a href="tel:+212 06 61 58 76 54">+33 00 00 00 00</a> ou par
                                          //                 email <a href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                          //               </p>
                                          //               <p style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                          //                 <a target="_blank" href="www.metalclass.com"
                                          //                   style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a> Made with <i
                                          //                   style="color:#909090"> &#10084;</i> by <a target="_blank" href="www.metalclass.com"
                                          //                   style="color: #C45824; text-decoration:none;">Jennifer CERDAN</a>
                                          //               </p>
                                          //             </td>
                                          //           </tr>
                                          //         </tbody>
                                          //       </table>
                                          //     </div>
                                          //   </div>
                                          //   </body>
                                          // `;
                                          // var emailString = item.email;
                                          // var sendgrid = sgMail.setApiKey(config.sendGridApiKey);
                                          // await sendgrid.send({
                                          //     to: emailString,
                                          //     from: config.mailFrom,
                                          //     subject: 'Nouvel emploi créé',
                                          //     html: html
                                          // }, function (err, result2) {
                                          //     if (err) {
                                          //     } else {
                                          //     }
                                          // });
                                        }
                                      });
                                  }
                                }

                                await data
                                  .populate("activites")
                                  .populate("responsabilites")
                                  .populate("relationsTravail")
                                  .populate("connaissances")
                                  .populate("finalites")
                                  .populate("clientID")
                                  .populate("entiteID")
                                  .populate("directionID")
                                  .populate(
                                    "serviceID",
                                    function (err, emploi) {
                                      res.json({
                                        code: config.successCode,
                                        status: "Success",
                                        message:
                                          "L'emploi a été créé avec succès.",
                                        data: emploi,
                                      });
                                    }
                                  );
                              }
                            });
                        } else {
                          res.json({
                            code: config.errCode,
                            status: "Error",
                            message: "Erreur lors de la création de l'emploi.",
                          });
                          return;
                        }
                      });
                    }
                  }
                );
              } else {
                res.json({
                  code: config.errCodeNameExist,
                  status: "Error",
                  message: "L'intitulé de l'emploi existe déjà.",
                });
                return;
              }
            });
        } else {
          emploiSchema
            .findOne({
              //intitule: receivedValues.intitule.trim(),
              //intitule: { $search: receivedValues.intitule.trim(),$caseSensitive :true},
              intitule: { $regex: "^"+receivedValues.intitule.trim()+"$", $options: 'i' },
              clientID: receivedValues.clientID,
            })
            .select({ _id: 1 })
            .exec((err, emploi) => {
              if (err) {
                res.json({
                  code: config.errCode,
                  status: "Error",
                  message: err.message,
                });
                return;
              }
              var update = false;
              if (emploi) {
                var emploiJson = JSON.parse(JSON.stringify(emploi));
                var emploiInfoJson = JSON.parse(JSON.stringify(emploiInfo));
                if (emploiJson._id == emploiInfoJson._id) {
                  update = true;
                } else {
                  update = false;
                }
              } else {
                update = true;
              }
              if (update) {
                let emploiData;
                emploiData = {
                  intitule: !receivedValues.intitule
				  ? ""
				  : receivedValues.intitule.trim(),
                  autresAppellations: !receivedValues.autresAppellations
                  ? ""
                  : receivedValues.autresAppellations.trim(),
                  commentaire: !receivedValues.commentaire
                    ? ""
                    : receivedValues.commentaire.trim(),
                  activites: receivedValues.activites,
                  responsabilites: receivedValues.responsabilites,
                  relationsTravail: receivedValues.relationsTravail,
                  connaissances: receivedValues.connaissances,
                  finalites: receivedValues.finalites,
                  refAnalyseEmploi: receivedValues.refAnalyseEmploi,
                  cotation: receivedValues.cotation,
                  classeEmploi: receivedValues.classeEmploi,
                  groupeEmploi: receivedValues.groupeEmploi,
                  isValidated: receivedValues.isValidated,
                  entiteID: receivedValues.entiteID,
                  directionID: receivedValues.directionID,
                  serviceID: receivedValues.serviceID,
                  userID: receivedValues.userID,
                  emploiActivated: receivedValues.emploiActivated,
                  clientID: receivedValues.clientID,
                  userValidatorID: receivedValues.userValidatorID,
                };
                let Option = {
                  new: true,
                };

                emploiSchema.findByIdAndUpdate(
                  emploiInfo._id,
                  emploiData,
                  Option,
                  (err, updatedData) => {
                    if (err) {
                      console.log(err);
                      res.json({
                        code: config.errCode,
                        status: "Error",
                        message: config.errMessage,
                      });
                      return;
                    } else {
                      updatedData
                        .populate("activites")
                        .populate("responsabilites")
                        .populate("relationsTravail")
                        .populate("connaissances")
                        .populate("finalites")
                        .populate("clientID")
                        .populate("entiteID")
                        .populate("directionID")
                        .populate("serviceID", function (err, emploi) {
                          res.json({
                            code: config.successCode,
                            status: "Success",
                            message: "L'emploi a été modifié avec succès.",
                            data: emploi,
                          });
                        });
                    }
                  }
                );
              } else {
                res.json({
                  code: config.errCodeNameExist,
                  status: "Error",
                  message: "L'intitulé de l'emploi existe déjà.",
                });
                return;
              }
            });
        }
      });
  }
};

exports.getEmploisClientUser = (req, res) => {
  var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
  var receivedValues = req.body;
  var userID = req.user._id;

  var orderby = 1;
  if (receivedValues.orderBy == "desc") {
    orderby = -1;
  }

  var match = {};

  match["intitule"] = {
    $regex: new RegExp(
      ".*" + receivedValues.intitule.toLowerCase() + ".*",
      "i"
    ),
  };
  match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  match["emploiActivated"] = true;
  if (receivedValues.cotation != undefined && receivedValues.cotation != 0) {
    match["cotation"] = receivedValues.cotation;
  }
  if (receivedValues.id != undefined && receivedValues.id != 0) {
    match["id"] = receivedValues.id;
  }
  if (
    receivedValues.classeEmploi != undefined &&
    receivedValues.classeEmploi != 0
  ) {
    match["classeEmploi"] = receivedValues.classeEmploi;
  }
  if (
    receivedValues.groupeEmploi != undefined &&
    receivedValues.groupeEmploi.trim() != ""
  ) {
    match["groupeEmploi"] = receivedValues.groupeEmploi;
  }
  if (
    receivedValues.entiteID != undefined &&
    receivedValues.entiteID.trim() != ""
  ) {
    match["entiteID._id"] = mongoose.Types.ObjectId(receivedValues.entiteID);
  }
  if (
    receivedValues.directionID != undefined &&
    receivedValues.directionID.trim() != ""
  ) {
    match["directionID._id"] = mongoose.Types.ObjectId(
      receivedValues.directionID
    );
  }
  if (
    receivedValues.serviceID != undefined &&
    receivedValues.serviceID.trim() != ""
  ) {
    match["serviceID._id"] = mongoose.Types.ObjectId(receivedValues.serviceID);
  }
  if (
    receivedValues.isValidated != undefined &&
    receivedValues.isValidated.trim() != ""
  ) {
    match["isValidated"] = receivedValues.isValidated;
  }

  userSchema
    .findOne({
      _id: userID,
    })
    .select({ __v: 0, password: 0 })
    .populate("clientID")
    .exec((err, user) => {
      if (err) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: err.message,
        });
        return;
      }
      if (user) {
        var userJSON = JSON.parse(JSON.stringify(user));

        var permissionServicesShow = [];
        for (var item of userJSON.permissionServicesShow) {
          permissionServicesShow.push(mongoose.Types.ObjectId(item));
        }

        if (match["serviceID._id"] == undefined) {
          match["serviceID._id"] = { $in: permissionServicesShow };
        }

        emploiSchema
          .aggregate([
            {
              $lookup: {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userID",
                foreignField: "_id",
                as: "userID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userValidatorID",
                foreignField: "_id",
                as: "userValidatorID",
              },
            },
            {
              $lookup: {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID",
              },
            },
            {
              $lookup: {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID",
              },
            },
            {
              $lookup: {
                from: "service",
                localField: "serviceID",
                foreignField: "_id",
                as: "serviceID",
              },
            },
            {
              $project: {
                "userValidatorID.password": 0,
                "userValidatorID.userRole": 0,
                "userValidatorID.permissionServicesCreate": 0,
                "userValidatorID.permissionServicesShow": 0,
                "userValidatorID.permissionServicesValidate": 0,
                "userID.password": 0,
                "userID.userRole": 0,
                "userID.permissionServicesCreate": 0,
                "userID.permissionServicesShow": 0,
                "userID.permissionServicesValidate": 0,
              },
            },
            {
              $lookup: {
                from: "activite",
                localField: "activites",
                foreignField: "_id",
                as: "activites",
              },
            },
            {
              $lookup: {
                from: "responsabilite",
                localField: "responsabilites",
                foreignField: "_id",
                as: "responsabilites",
              },
            },
            {
              $lookup: {
                from: "relationTravail",
                localField: "relationsTravail",
                foreignField: "_id",
                as: "relationsTravail",
              },
            },
            {
              $lookup: {
                from: "connaissance",
                localField: "connaissances",
                foreignField: "_id",
                as: "connaissances",
              },
            },
            {
              $lookup: {
                from: "finalite",
                localField: "finalites",
                foreignField: "_id",
                as: "finalites",
              },
            },
            { $unwind: "$clientID" },
            { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
            {
              $unwind: {
                path: "$userValidatorID",
                preserveNullAndEmptyArrays: true,
              },
            },
            { $unwind: "$entiteID" },
            { $unwind: "$directionID" },
            { $unwind: "$serviceID" },
            {
              $match: match,
            },
          ])
          .collation({ locale: "fr" })
          .then((listEmploisTotal, err) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              emploiSchema
                .aggregate([
                  {
                    $lookup: {
                      from: "client",
                      localField: "clientID",
                      foreignField: "_id",
                      as: "clientID",
                    },
                  },
                  {
                    $lookup: {
                      from: "user",
                      localField: "userID",
                      foreignField: "_id",
                      as: "userID",
                    },
                  },
                  {
                    $lookup: {
                      from: "user",
                      localField: "userValidatorID",
                      foreignField: "_id",
                      as: "userValidatorID",
                    },
                  },
                  {
                    $lookup: {
                      from: "entite",
                      localField: "entiteID",
                      foreignField: "_id",
                      as: "entiteID",
                    },
                  },
                  {
                    $lookup: {
                      from: "direction",
                      localField: "directionID",
                      foreignField: "_id",
                      as: "directionID",
                    },
                  },
                  {
                    $lookup: {
                      from: "service",
                      localField: "serviceID",
                      foreignField: "_id",
                      as: "serviceID",
                    },
                  },
                  {
                    $project: {
                      "userValidatorID.password": 0,
                      "userValidatorID.userRole": 0,
                      "userValidatorID.permissionServicesCreate": 0,
                      "userValidatorID.permissionServicesShow": 0,
                      "userValidatorID.permissionServicesValidate": 0,
                      "userID.password": 0,
                      "userID.userRole": 0,
                      "userID.permissionServicesCreate": 0,
                      "userID.permissionServicesShow": 0,
                      "userID.permissionServicesValidate": 0,
                    },
                  },
                  {
                    $lookup: {
                      from: "activite",
                      localField: "activites",
                      foreignField: "_id",
                      as: "activites",
                    },
                  },
                  {
                    $lookup: {
                      from: "responsabilite",
                      localField: "responsabilites",
                      foreignField: "_id",
                      as: "responsabilites",
                    },
                  },
                  {
                    $lookup: {
                      from: "relationTravail",
                      localField: "relationsTravail",
                      foreignField: "_id",
                      as: "relationsTravail",
                    },
                  },
                  {
                    $lookup: {
                      from: "connaissance",
                      localField: "connaissances",
                      foreignField: "_id",
                      as: "connaissances",
                    },
                  },
                  {
                    $lookup: {
                      from: "finalite",
                      localField: "finalites",
                      foreignField: "_id",
                      as: "finalites",
                    },
                  },
                  { $unwind: "$clientID" },
                  {
                    $unwind: {
                      path: "$userID",
                      preserveNullAndEmptyArrays: true,
                    },
                  },
                  {
                    $unwind: {
                      path: "$userValidatorID",
                      preserveNullAndEmptyArrays: true,
                    },
                  },
                  { $unwind: "$entiteID" },
                  { $unwind: "$directionID" },
                  { $unwind: "$serviceID" },
                  {
                    $match: match,
                  },
                  { $sort: { [req.body.sortBy]: orderby } },
                  { $limit: req.body.limit + offset },
                  { $skip: offset },
                ])
                .collation({ locale: "fr" })
                .then((listEmplois, err) => {
                  if (err) {
                    console.log(err);
                    res.json({
                      code: config.errCode,
                      status: "Error",
                      message: config.errMessage,
                    });
                    return;
                  } else {
                    res.json({
                      code: config.successCode,
                      status: "success",
                      data: {
                        listEmplois: listEmplois,
                        totalEmplois: listEmploisTotal.length,
                        totalPages: Math.ceil(
                          listEmploisTotal.length / req.body.limit
                        ),
                      },
                    });
                  }
                });
            }
          });
      } else {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Aucun utilisateur trouvé.",
        });
      }
    });
};

exports.getEmploisClient = (req, res) => {
  var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
  var receivedValues = req.body;

  var orderby = 1;
  if (receivedValues.orderBy == "desc") {
    orderby = -1;
  }

  var match = {};

  match["intitule"] = {
    $regex: new RegExp(
      ".*" + receivedValues.intitule.toLowerCase() + ".*",
      "i"
    ),
  };
  match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  match["emploiActivated"] = true;
  if (receivedValues.cotation != undefined && receivedValues.cotation != 0) {
    match["cotation"] = receivedValues.cotation;
  }
  if (receivedValues.id != undefined && receivedValues.id != 0) {
    match["id"] = receivedValues.id;
  }
  if (
    receivedValues.classeEmploi != undefined &&
    receivedValues.classeEmploi != 0
  ) {
    match["classeEmploi"] = receivedValues.classeEmploi;
  }
  if (
    receivedValues.groupeEmploi != undefined &&
    receivedValues.groupeEmploi.trim() != ""
  ) {
    match["groupeEmploi"] = receivedValues.groupeEmploi;
  }
  if (
    receivedValues.entiteID != undefined &&
    receivedValues.entiteID.trim() != ""
  ) {
    match["entiteID._id"] = mongoose.Types.ObjectId(receivedValues.entiteID);
  }
  if (
    receivedValues.directionID != undefined &&
    receivedValues.directionID.trim() != ""
  ) {
    match["directionID._id"] = mongoose.Types.ObjectId(
      receivedValues.directionID
    );
  }
  if (
    receivedValues.serviceID != undefined &&
    receivedValues.serviceID.trim() != ""
  ) {
    match["serviceID._id"] = mongoose.Types.ObjectId(receivedValues.serviceID);
  }
  if (
    receivedValues.isValidated != undefined &&
    receivedValues.isValidated.trim() != ""
  ) {
    match["isValidated"] = receivedValues.isValidated;
  }

  emploiSchema
    .aggregate([
      {
        $lookup: {
          from: "client",
          localField: "clientID",
          foreignField: "_id",
          as: "clientID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userID",
          foreignField: "_id",
          as: "userID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userValidatorID",
          foreignField: "_id",
          as: "userValidatorID",
        },
      },
      {
        $lookup: {
          from: "entite",
          localField: "entiteID",
          foreignField: "_id",
          as: "entiteID",
        },
      },
      {
        $lookup: {
          from: "direction",
          localField: "directionID",
          foreignField: "_id",
          as: "directionID",
        },
      },
      {
        $lookup: {
          from: "service",
          localField: "serviceID",
          foreignField: "_id",
          as: "serviceID",
        },
      },
      {
        $project: {
          "userValidatorID.password": 0,
          "userValidatorID.userRole": 0,
          "userValidatorID.permissionServicesCreate": 0,
          "userValidatorID.permissionServicesShow": 0,
          "userValidatorID.permissionServicesValidate": 0,
          "userID.password": 0,
          "userID.userRole": 0,
          "userID.permissionServicesCreate": 0,
          "userID.permissionServicesShow": 0,
          "userID.permissionServicesValidate": 0,
        },
      },
      {
        $lookup: {
          from: "activite",
          localField: "activites",
          foreignField: "_id",
          as: "activites",
        },
      },
      {
        $lookup: {
          from: "responsabilite",
          localField: "responsabilites",
          foreignField: "_id",
          as: "responsabilites",
        },
      },
      {
        $lookup: {
          from: "relationTravail",
          localField: "relationsTravail",
          foreignField: "_id",
          as: "relationsTravail",
        },
      },
      {
        $lookup: {
          from: "connaissance",
          localField: "connaissances",
          foreignField: "_id",
          as: "connaissances",
        },
      },
      {
        $lookup: {
          from: "finalite",
          localField: "finalites",
          foreignField: "_id",
          as: "finalites",
        },
      },
      { $unwind: "$clientID" },
      { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
      {
        $unwind: { path: "$userValidatorID", preserveNullAndEmptyArrays: true },
      },
      { $unwind: "$entiteID" },
      { $unwind: "$directionID" },
      { $unwind: "$serviceID" },
      {
        $match: match,
      },
    ])
    .collation({ locale: "fr" })
    .then((listEmploisTotal, err) => {
      if (err) {
        console.log(err);
        res.json({
          code: config.errCode,
          status: "Error",
          message: config.errMessage,
        });
        return;
      } else {
        emploiSchema
          .aggregate([
            {
              $lookup: {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userID",
                foreignField: "_id",
                as: "userID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userValidatorID",
                foreignField: "_id",
                as: "userValidatorID",
              },
            },
            {
              $lookup: {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID",
              },
            },
            {
              $lookup: {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID",
              },
            },
            {
              $lookup: {
                from: "service",
                localField: "serviceID",
                foreignField: "_id",
                as: "serviceID",
              },
            },
            {
              $project: {
                "userValidatorID.password": 0,
                "userValidatorID.userRole": 0,
                "userValidatorID.permissionServicesCreate": 0,
                "userValidatorID.permissionServicesShow": 0,
                "userValidatorID.permissionServicesValidate": 0,
                "userID.password": 0,
                "userID.userRole": 0,
                "userID.permissionServicesCreate": 0,
                "userID.permissionServicesShow": 0,
                "userID.permissionServicesValidate": 0,
              },
            },
            {
              $lookup: {
                from: "activite",
                localField: "activites",
                foreignField: "_id",
                as: "activites",
              },
            },
            {
              $lookup: {
                from: "responsabilite",
                localField: "responsabilites",
                foreignField: "_id",
                as: "responsabilites",
              },
            },
            {
              $lookup: {
                from: "relationTravail",
                localField: "relationsTravail",
                foreignField: "_id",
                as: "relationsTravail",
              },
            },
            {
              $lookup: {
                from: "connaissance",
                localField: "connaissances",
                foreignField: "_id",
                as: "connaissances",
              },
            },
            {
              $lookup: {
                from: "finalite",
                localField: "finalites",
                foreignField: "_id",
                as: "finalites",
              },
            },
            { $unwind: "$clientID" },
            { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
            {
              $unwind: {
                path: "$userValidatorID",
                preserveNullAndEmptyArrays: true,
              },
            },
            { $unwind: "$entiteID" },
            { $unwind: "$directionID" },
            { $unwind: "$serviceID" },
            {
              $match: match,
            },
            { $sort: { [req.body.sortBy]: orderby } },
            { $limit: req.body.limit + offset },
            { $skip: offset },
          ])
          .collation({ locale: "fr" })
          .then((listEmplois, err) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              res.json({
                code: config.successCode,
                status: "success",
                data: {
                  listEmplois: listEmplois,
                  totalEmplois: listEmploisTotal.length,
                  totalPages: Math.ceil(
                    listEmploisTotal.length / req.body.limit
                  ),
                },
              });
            }
          });
      }
    });
};

exports.getEmplois = (req, res) => {
  var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
  var receivedValues = req.body;

  var orderby = 1;
  if (receivedValues.orderBy == "desc") {
    orderby = -1;
  }

  var match = {};

  match["intitule"] = {
    $regex: new RegExp(
      ".*" + receivedValues.intitule.toLowerCase() + ".*",
      "i"
    ),
  };
  if (
    receivedValues.clientID != undefined &&
    receivedValues.clientID.trim() != ""
  ) {
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  }
  match["emploiActivated"] = true;
  if (receivedValues.cotation != undefined && receivedValues.cotation != 0) {
    match["cotation"] = receivedValues.cotation;
  }
  if (receivedValues.id != undefined && receivedValues.id != 0) {
    match["id"] = receivedValues.id;
  }
  if (
    receivedValues.classeEmploi != undefined &&
    receivedValues.classeEmploi != 0
  ) {
    match["classeEmploi"] = receivedValues.classeEmploi;
  }
  if (
    receivedValues.groupeEmploi != undefined &&
    receivedValues.groupeEmploi.trim() != ""
  ) {
    match["groupeEmploi"] = receivedValues.groupeEmploi;
  }
  if (
    receivedValues.entiteID != undefined &&
    receivedValues.entiteID.trim() != ""
  ) {
    match["entiteID._id"] = mongoose.Types.ObjectId(receivedValues.entiteID);
  }
  if (
    receivedValues.directionID != undefined &&
    receivedValues.directionID.trim() != ""
  ) {
    match["directionID._id"] = mongoose.Types.ObjectId(
      receivedValues.directionID
    );
  }
  if (
    receivedValues.serviceID != undefined &&
    receivedValues.serviceID.trim() != ""
  ) {
    match["serviceID._id"] = mongoose.Types.ObjectId(receivedValues.serviceID);
  }
  if (
    receivedValues.isValidated != undefined &&
    receivedValues.isValidated.trim() != ""
  ) {
    match["isValidated"] = receivedValues.isValidated;
  }

  emploiSchema
    .aggregate([
      {
        $lookup: {
          from: "client",
          localField: "clientID",
          foreignField: "_id",
          as: "clientID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userID",
          foreignField: "_id",
          as: "userID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userValidatorID",
          foreignField: "_id",
          as: "userValidatorID",
        },
      },
      {
        $lookup: {
          from: "entite",
          localField: "entiteID",
          foreignField: "_id",
          as: "entiteID",
        },
      },
      {
        $lookup: {
          from: "direction",
          localField: "directionID",
          foreignField: "_id",
          as: "directionID",
        },
      },
      {
        $lookup: {
          from: "service",
          localField: "serviceID",
          foreignField: "_id",
          as: "serviceID",
        },
      },
      {
        $project: {
          "userValidatorID.password": 0,
          "userValidatorID.userRole": 0,
          "userValidatorID.permissionServicesCreate": 0,
          "userValidatorID.permissionServicesShow": 0,
          "userValidatorID.permissionServicesValidate": 0,
          "userID.password": 0,
          "userID.userRole": 0,
          "userID.permissionServicesCreate": 0,
          "userID.permissionServicesShow": 0,
          "userID.permissionServicesValidate": 0,
        },
      },
      {
        $lookup: {
          from: "activite",
          localField: "activites",
          foreignField: "_id",
          as: "activites",
        },
      },
      {
        $lookup: {
          from: "responsabilite",
          localField: "responsabilites",
          foreignField: "_id",
          as: "responsabilites",
        },
      },
      {
        $lookup: {
          from: "relationTravail",
          localField: "relationsTravail",
          foreignField: "_id",
          as: "relationsTravail",
        },
      },
      {
        $lookup: {
          from: "connaissance",
          localField: "connaissances",
          foreignField: "_id",
          as: "connaissances",
        },
      },
      {
        $lookup: {
          from: "finalite",
          localField: "finalites",
          foreignField: "_id",
          as: "finalites",
        },
      },
      { $unwind: "$clientID" },
      { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
      {
        $unwind: { path: "$userValidatorID", preserveNullAndEmptyArrays: true },
      },
      { $unwind: "$entiteID" },
      { $unwind: "$directionID" },
      { $unwind: "$serviceID" },
      {
        $match: match,
      },
    ])
    .collation({ locale: "fr" })
    .then((listEmploisTotal, err) => {
      if (err) {
        console.log(err);
        res.json({
          code: config.errCode,
          status: "Error",
          message: config.errMessage,
        });
        return;
      } else {
        emploiSchema
          .aggregate([
            {
              $lookup: {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userID",
                foreignField: "_id",
                as: "userID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userValidatorID",
                foreignField: "_id",
                as: "userValidatorID",
              },
            },
            {
              $lookup: {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID",
              },
            },
            {
              $lookup: {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID",
              },
            },
            {
              $lookup: {
                from: "service",
                localField: "serviceID",
                foreignField: "_id",
                as: "serviceID",
              },
            },
            {
              $lookup: {
                from: "activite",
                localField: "activites",
                foreignField: "_id",
                as: "activites",
              },
            },
            {
              $lookup: {
                from: "responsabilite",
                localField: "responsabilites",
                foreignField: "_id",
                as: "responsabilites",
              },
            },
            {
              $lookup: {
                from: "relationTravail",
                localField: "relationsTravail",
                foreignField: "_id",
                as: "relationsTravail",
              },
            },
            {
              $lookup: {
                from: "connaissance",
                localField: "connaissances",
                foreignField: "_id",
                as: "connaissances",
              },
            },
            {
              $lookup: {
                from: "finalite",
                localField: "finalites",
                foreignField: "_id",
                as: "finalites",
              },
            },
            { $unwind: "$clientID" },
            { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
            {
              $unwind: {
                path: "$userValidatorID",
                preserveNullAndEmptyArrays: true,
              },
            },
            { $unwind: "$entiteID" },
            { $unwind: "$directionID" },
            { $unwind: "$serviceID" },
            {
              $project: {
                "userValidatorID.password": 0,
                "userValidatorID.userRole": 0,
                "userValidatorID.permissionServicesCreate": 0,
                "userValidatorID.permissionServicesShow": 0,
                "userValidatorID.permissionServicesValidate": 0,
                "userID.password": 0,
                "userID.userRole": 0,
                "userID.permissionServicesCreate": 0,
                "userID.permissionServicesShow": 0,
                "userID.permissionServicesValidate": 0,
              },
            },
            {
              $match: match,
            },
            { $sort: { [req.body.sortBy]: orderby } },
            { $limit: req.body.limit + offset },
            { $skip: offset },
          ])
          .collation({ locale: "fr" })
          .then((listEmplois, err) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              res.json({
                code: config.successCode,
                status: "success",
                data: {
                  listEmplois: listEmplois,
                  totalEmplois: listEmploisTotal.length,
                  totalPages: Math.ceil(
                    listEmploisTotal.length / req.body.limit
                  ),
                },
              });
            }
          });
      }
    });
};

exports.deleteEmploiByID = (req, res) => {
  const receivedValues = req.body;
  if (JSON.stringify(receivedValues) === "{}") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
  } else {
    let columns = ["emploiID"];
    for (let iter = 0; iter < columns.length; iter++) {
      let columnName = columns[iter];
      if (
        receivedValues[columnName] === undefined &&
        columnName === "emploiID"
      ) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Le champ " + columnName + " n'est pas défini.",
        });
        return;
      }
    }
    emploiSchema
      .find({
        _id: req.body.emploiID,
      })
      .lean()
      .exec((err, emploi) => {
        if (err) {
          console.log(err);
          res.json({
            code: config.errCode,
            status: "Error",
            message: config.errMessage,
          });
          return;
        } else {
          if (emploi) {
            emploiSchema
              .deleteOne({
                _id: receivedValues.emploiID,
              })
              .exec((err, emploiInfo) => {
                if (err) {
                  console.log(err);
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                  return;
                }
                if (emploiInfo.deletedCount === 1) {
                  notificationSchema
                    .deleteMany({
                      emploiID: mongoose.Types.ObjectId(
                        receivedValues.emploiID
                      ),
                    })
                    .exec((err, notificationInfo) => {
                      if (err) {
                        console.log(err);
                        res.json({
                          code: config.errCode,
                          status: "Error",
                          message: config.errMessage,
                        });
                        return;
                      }
                      if (notificationInfo.ok == 1) {
                        res.json({
                          code: config.successCode,
                          status: "success",
                          message: "L'emploi a été supprimé avec succès.",
                        });
                      } else {
                        res.json({
                          code: config.errCode,
                          status: "Error",
                          message: config.errMessage,
                        });
                      }
                    });
                } else {
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                }
              });
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "Aucune emploi trouvé.",
            });
          }
        }
      });
  }
};

exports.validateEmploiByID = (req, res) => {
  const receivedValues = req.body;
  if (JSON.stringify(receivedValues) === "{}") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
  } else {
    let columns = ["emploiID"];
    for (let iter = 0; iter < columns.length; iter++) {
      let columnName = columns[iter];
      if (
        receivedValues[columnName] === undefined &&
        columnName === "emploiID"
      ) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Le champ " + columnName + " n'est pas défini.",
        });
        return;
      }
    }
    emploiSchema
      .findOne({
        _id: req.body.emploiID,
      })
      .lean()
      .populate("userID")
      .exec((err, emploi) => {
        if (err) {
          console.log(err);
          res.json({
            code: config.errCode,
            status: "Error",
            message: config.errMessage,
          });
          return;
        } else {
          if (emploi) {
            let fieldToSet;
            fieldToSet = {
              isValidated: receivedValues.isValidated,
              userValidatorID: mongoose.Types.ObjectId(req.user._id),
            };
            let Option = {
              new: true,
            };
            emploiSchema.findByIdAndUpdate(
              receivedValues.emploiID,
              fieldToSet,
              Option,
              async (err, updatedData) => {
                if (err) {
                  console.log(err);
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                  return;
                } else {
                  userSchema
                    .find({
                      userDeleted: false,
                      clientID: receivedValues.clientID,
                    })
                    .select({ __v: 0, password: 0 })
                    .lean()
                    .exec(async (err, listusers) => {
                      if (err) {
                        console.log(err);
                        res.json({
                          code: config.errCode,
                          status: "Error",
                          message: config.errMessage,
                        });
                        return;
                      } else {
                        
                        emploiJson = JSON.parse(JSON.stringify(emploi));

                        for (var item of listusers) {
                          // if (
                          //   JSON.parse(
                          //     JSON.stringify(item.permissionServicesValidate)
                          //   ).some((e) => e === receivedValues.serviceID)
                          // ) {
                          if (emploiJson.userID._id == item._id || item.userRole != "user") {
                            let notificationData;
                            notificationData = {
                              messageNotification: "Emploi Validé",
                              lienNotification: "lien",
                              notificationStatut: false,
                              notificationEtat: false,
                              userID: item._id,
                              //userID: emploiJson.userID._id,
                              emploiID: emploiJson._id,
                            };
                            await notificationSchema
                              .create(notificationData)
                              .then(async (notif) => {
                                if (notif) {
                                  var html =
                                    `<html>

                                    <body style="width: 100% !important;background-color: #F8F8F8;">
                                        <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                                            style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                                            <center>
                                                <div class="justify-content-center d-flex">
                                                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                                        style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                                        heigth="auto">
                                                        <tbody>
                                                            <tr>
                                                                <td align="center" valign="center"
                                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                    <img style="width: 100px;" src="https://app.metalclass.com/assets/logos/classif.png" />
                                                                </td>
                                                                <td align="right" valign="center"
                                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                    <!-- <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">02.01.2022</span> -->
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                                                    <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                                        Bonjour,</h3>
                                                                    <p style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                                        L'emploi <b>` +
                                                                        emploiJson.intitule +
                                                                        ` </b> a été validé.
                                                                    </p>
                                    
                                    
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colSpan="2">
                                                                    <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                                                        style="min-width:100%;border-collapse:collapse;">
                                                                        <tbody>
                                                                            <tr>
                                                                                <td style="padding:15px 0px;" valign="top" align="center">
                                                                                    <table border="0" cellpadding="0" cellspacing="0"
                                                                                        style="border-collapse:separate !important;">
                                                                                        <tbody>
                                                                                            <tr>
                                                                                                <td align="center" valign="middle" style="padding:13px;">
                                                                                                    <a href="https://app.metalclass.com/" title="START NOW"
                                                                                                        target="_blank"
                                                                                                        style="font-size: 14px; line-height: 1.5; font-weight: 700; letter-spacing: 1px; padding: 15px 40px; text-align:center; text-decoration:none; color:#FFFFFF; border-radius: 50px; background-color:#C45824;">
                                                                                                        Se connecter</a>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <div class="justify-content-center d-flex">
                                                    <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                                        <tbody>
                                                            <tr>
                                                                <td align="center" valign="center">
                                                                    <p
                                                                        style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                                                        Une question ? Un problème ? Contacter le support : <a
                                                                            href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                                                    </p>
                                                                    <p
                                                                        style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                                                        <a target="_blank" href="www.metalclass.com"
                                                                            style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a>
                                                                    </p>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </center>
                                        </div>
                                    </body>
                                    
                                    </html>`;
                                  var emailString = item.email;
                                  //var emailString = emploiJson.userID.email;
                                  var sendgrid = sgMail.setApiKey(config.sendGridApiKey);
                                  await sendgrid.send(
                                    {
                                      to: emailString,
                                      from: config.mailFrom,
                                      subject:
                                        "METALCLASS : Validation de l'emploi " +
                                        emploiJson.intitule,
                                      html: html,
                                    },
                                    function (err, result2) {
                                      if (err) {
                                      } else {
                                      }
                                    }
                                  );
                                }
                              });
                          }
                        }

                        await updatedData
                          .populate("activites")
                          .populate("responsabilites")
                          .populate("relationsTravail")
                          .populate("connaissances")
                          .populate("finalites")
                          .populate("clientID")
                          .populate("entiteID")
                          .populate("directionID")
                          .populate("serviceID", function (err, emploi) {
                            res.json({
                              code: config.successCode,
                              status: "Success",
                              message: "L'emploi a été validé avec succès.",
                              data: emploi,
                            });
                          });

                      }
                    });
                }
              }
            );
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "Aucune emploi trouvé.",
            });
          }
        }
      });
  }
};

exports.getEmploiByID = (req, res) => {
  var receivedValues = req.body;

  emploiSchema
    .findOne({
      _id: receivedValues.emploiID,
    })
    .select()
    .exec(async (err, emploi) => {
      if (err) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: err.message,
        });
        return;
      }

      if (emploi) {
        await emploi
          .populate("userID", "email firstName lastName mobile")
          .populate("userValidatorID", "email firstName lastName mobile")
          .populate("activites")
          .populate("responsabilites")
          .populate("relationsTravail")
          .populate("connaissances")
          .populate("finalites")
          .populate("clientID")
          .populate("entiteID")
          .populate("directionID")
          .populate("serviceID", function (err, emploi) {
            res.json({
              code: config.successCode,
              status: "success",
              data: emploi,
            });
          });
      } else {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Aucun emploi trouvé.",
        });
      }
    });
};

exports.soumettreEmploiByID = (req, res) => {
  const receivedValues = req.body;
  if (JSON.stringify(receivedValues) === "{}") {
    res.json({
      code: config.errCode,
      status: "Error",
      message: "Les données entrées ne sont pas valides.",
    });
  } else {
    let columns = ["emploiID"];
    for (let iter = 0; iter < columns.length; iter++) {
      let columnName = columns[iter];
      if (
        receivedValues[columnName] === undefined &&
        columnName === "emploiID"
      ) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Le champ " + columnName + " n'est pas défini.",
        });
        return;
      }
    }
    emploiSchema
      .find({
        emploiID: req.body.emploiID,
      })
      .lean()
      .exec((err, emploi) => {
        if (err) {
          console.log(err);
          res.json({
            code: config.errCode,
            status: "Error",
            message: config.errMessage,
          });
          return;
        } else {
          if (emploi) {
            let fieldToSet;
            fieldToSet = {
              isValidated: receivedValues.isValidated,
              commentaire: receivedValues.commentaire
            };
            let Option = {
              new: true,
            };
            emploiSchema.findByIdAndUpdate(
              receivedValues.emploiID,
              fieldToSet,
              Option,
              (err, updatedData) => {
                if (err) {
                  console.log(err);
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: config.errMessage,
                  });
                  return;
                } else {
                  userSchema
                    .find({
                      userDeleted: false,
                      clientID: receivedValues.clientID,
                    })
                    .select({ __v: 0, password: 0 })
                    .lean()
                    .exec(async (err, listusers) => {
                      if (err) {
                        console.log(err);
                        res.json({
                          code: config.errCode,
                          status: "Error",
                          message: config.errMessage,
                        });
                        return;
                      } else {
                        emploiJson = JSON.parse(JSON.stringify(updatedData));

                        for (var item of listusers) {
                          if (
                            JSON.parse(
                              JSON.stringify(item.permissionServicesValidate)
                            ).some((e) => e === receivedValues.serviceID) ||
                            item.userRole != "user"
                          ) {
                            let notificationData;
                            notificationData = {
                              messageNotification:
                                "Emploi soumis pour validation",
                              lienNotification: "lien",
                              notificationStatut: false,
                              notificationEtat: false,
                              userID: item._id,
                              emploiID: emploiJson._id,
                            };
                            await notificationSchema
                              .create(notificationData)
                              .then(async (notif) => {
                                if (notif) {
                                  var html =
                                    `<html>

                                    <body style="width: 100% !important;background-color: #F8F8F8;">
                                        <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                                            style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                                            <center>
                                                <div class="justify-content-center d-flex">
                                                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                                        style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                                        heigth="auto">
                                                        <tbody>
                                                            <tr>
                                                                <td align="center" valign="center"
                                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                    <img style="width: 100px;" src="https://app.metalclass.com/assets/logos/classif.png" />
                                                                </td>
                                                                <td align="right" valign="center"
                                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                    <!-- <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">02.01.2022</span> -->
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                                                    <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                                        Bonjour,</h3>
                                                                    <p style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                                        Une validation de l'emploi <b> ` +
                                                                        emploiJson.intitule +
                                                                        ` </b> a été demandée. <br>
                                                                        Nous vous remercions de vous connecter à METALCLASS pour répondre à cette demande.
                                                                    </p>
                                    
                                    
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colSpan="2">
                                                                    <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                                                        style="min-width:100%;border-collapse:collapse;">
                                                                        <tbody>
                                                                            <tr>
                                                                                <td style="padding:15px 0px;" valign="top" align="center">
                                                                                    <table border="0" cellpadding="0" cellspacing="0"
                                                                                        style="border-collapse:separate !important;">
                                                                                        <tbody>
                                                                                            <tr>
                                                                                                <td align="center" valign="middle" style="padding:13px;">
                                                                                                    <a href="https://app.metalclass.com/" title="START NOW"
                                                                                                        target="_blank"
                                                                                                        style="font-size: 14px; line-height: 1.5; font-weight: 700; letter-spacing: 1px; padding: 15px 40px; text-align:center; text-decoration:none; color:#FFFFFF; border-radius: 50px; background-color:#C45824;">
                                                                                                        Se connecter</a>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <div class="justify-content-center d-flex">
                                                    <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                                        <tbody>
                                                            <tr>
                                                                <td align="center" valign="center">
                                                                    <p
                                                                        style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                                                        Une question ? Un problème ? Contacter le support : <a
                                                                            href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                                                    </p>
                                                                    <p
                                                                        style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                                                        <a target="_blank" href="www.metalclass.com"
                                                                            style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a>
                                                                    </p>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </center>
                                        </div>
                                    </body>
                                    
                                    </html>`;
                                  var emailString = item.email;
                                  var sendgrid = sgMail.setApiKey(
                                    config.sendGridApiKey
                                  );
                                  await sendgrid.send(
                                    {
                                      to: emailString,
                                      from: config.mailFrom,
                                      subject:
                                        "METALCLASS : Demande de validation d'un emploi",
                                      html: html,
                                    },
                                    function (err, result2) {
                                      if (err) {
                                      } else {
                                      }
                                    }
                                  );
                                }
                              });
                          }
                        }

                        await updatedData
                          .populate("activites")
                          .populate("responsabilites")
                          .populate("relationsTravail")
                          .populate("connaissances")
                          .populate("finalites")
                          .populate("clientID")
                          .populate("entiteID")
                          .populate("directionID")
                          .populate("serviceID", function (err, emploi) {
                            res.json({
                              code: config.successCode,
                              status: "Success",
                              message: "L'emploi a été créé avec succès.",
                              data: emploi,
                            });
                          });
                      }
                    });
                }
              }
            );
          } else {
            res.json({
              code: config.errCode,
              status: "Error",
              message: "Aucune emploi trouvé.",
            });
          }
        }
      });
  }
};

exports.getEmploisDashboard = (req, res) => {
  var receivedValues = req.body;

  var orderby = 1;
  if (receivedValues.orderBy == "desc") {
    orderby = -1;
  }

  var match = {};

  match["emploiActivated"] = true;

  if (
    receivedValues.clientID != undefined &&
    receivedValues.clientID.trim() != ""
  ) {
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  }

  emploiSchema
    .aggregate([
      {
        $lookup: {
          from: "client",
          localField: "clientID",
          foreignField: "_id",
          as: "clientID",
        },
      },
      { $unwind: "$clientID" },
      {
        $match: match,
      },
    ])
    .collation({ locale: "fr" })
    .then((listEmplois, err) => {
      var listEmploisValideCount = 0;
      var listEmploisBrouillonCount = 0;
      var listEmploisSoumisCount = 0;
      var listEmploisTotalCount = 0;
      if (err) {
        console.log(err);
        res.json({
          code: config.errCode,
          status: "Error",
          message: config.errMessage,
          data: {
            totalEmploisValide: listEmploisValideCount,
            totalEmploisBrouillon: listEmploisBrouillonCount,
            totalEmploisSoumis: listEmploisSoumisCount,
            totalEmplois: listEmploisTotalCount,
          },
        });
        return;
      } else {
        listEmploisTotalCount = listEmplois.length;
        listEmploisValideCount = listEmplois.filter(
          (item) => item.isValidated == "validé"
        ).length;
        listEmploisBrouillonCount = listEmplois.filter(
          (item) => item.isValidated == "brouillon"
        ).length;
        listEmploisSoumisCount = listEmplois.filter(
          (item) => item.isValidated == "en attente de validation"
        ).length;

        res.json({
          code: config.successCode,
          status: "success",
          data: {
            totalEmploisValide: listEmploisValideCount,
            totalEmploisBrouillon: listEmploisBrouillonCount,
            totalEmploisSoumis: listEmploisSoumisCount,
            totalEmplois: listEmploisTotalCount,
          },
        });
      }
    });
};

exports.getEmploisDashboardUser = (req, res) => {
  var receivedValues = req.body;
  var userID = req.user._id;

  var orderby = 1;
  if (receivedValues.orderBy == "desc") {
    orderby = -1;
  }

  var match = {};

  match["emploiActivated"] = true;

  if (
    receivedValues.clientID != undefined &&
    receivedValues.clientID.trim() != ""
  ) {
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  }

  userSchema
    .findOne({
      _id: userID,
    })
    .select({ __v: 0, password: 0 })
    .populate("clientID")
    .exec((err, user) => {
      if (err) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: err.message,
        });
        return;
      }
      if (user) {

        var userJSON = JSON.parse(JSON.stringify(user));

        var permissionServicesShow = [];
        for (var item of userJSON.permissionServicesShow) {
          permissionServicesShow.push(mongoose.Types.ObjectId(item));
        }

        if (match["serviceID._id"] == undefined) {
          match["serviceID._id"] = { $in: permissionServicesShow };
        }

        emploiSchema.aggregate([
          {
            $lookup: {
              from: "client",
              localField: "clientID",
              foreignField: "_id",
              as: "clientID",
            },
          },
          {
            $lookup: {
              from: "service",
              localField: "serviceID",
              foreignField: "_id",
              as: "serviceID",
            },
          },
          { $unwind: "$clientID" },
          { $unwind: "$serviceID" },
          {
            $match: match,
          },
        ])
          .collation({ locale: "fr" })
          .then((listEmplois, err) => {
            var listEmploisValideCount = 0;
            var listEmploisBrouillonCount = 0;
            var listEmploisSoumisCount = 0;
            var listEmploisTotalCount = 0;
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
                data: {
                  totalEmploisValide: listEmploisValideCount,
                  totalEmploisBrouillon: listEmploisBrouillonCount,
                  totalEmploisSoumis: listEmploisSoumisCount,
                  totalEmplois: listEmploisTotalCount,
                },
              });
              return;
            } else {
              listEmploisTotalCount = listEmplois.length;
              listEmploisValideCount = listEmplois.filter(
                (item) => item.isValidated == "validé"
              ).length;
              listEmploisBrouillonCount = listEmplois.filter(
                (item) => item.isValidated == "brouillon"
              ).length;
              listEmploisSoumisCount = listEmplois.filter(
                (item) => item.isValidated == "en attente de validation"
              ).length;

              res.json({
                code: config.successCode,
                status: "success",
                data: {
                  totalEmploisValide: listEmploisValideCount,
                  totalEmploisBrouillon: listEmploisBrouillonCount,
                  totalEmploisSoumis: listEmploisSoumisCount,
                  totalEmplois: listEmploisTotalCount,
                },
              });
            }
          });

      } else {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Aucun utilisateur trouvé.",
        });
      }
    });

};

exports.importEmploi = async (req, res) => {
  const receivedValues = req.body;
  if (JSON.stringify(receivedValues) === '{}') {
      res.json({
          "code": config.errCode,
          "status": "Error",
          "message": "Invalid data enter",
          "dataDoublons": []
      });
  } else {
    emploiSchema
    .findOne({
      //intitule: receivedValues.data.intituleEmploiImport.trim(),
      //intitule: { $regex: receivedValues.data.intituleEmploiImport.trim(), $options: 'i' },
      intitule: { $regex: "^"+receivedValues.data.intituleEmploiImport.trim()+"$", $options: 'i' },
      clientID: receivedValues.clientID,
    })
    .select({ _id: 1 })
    .exec( async (err, emploi)  => {
      if (err) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: err.message,
        });
        return;
      }
      if (emploi) {
        res.json({
          code: config.errCodeNameExist,
          status: "Error",
          message: "L'intitulé de l'emploi existe déjà.",
        });
        return;
      } else {
        var finalites = [];
        for await (var item of receivedValues.data.arrayFinalitesImport) {
          let finaliteData;
          finaliteData = {
            labelFinalite: !item ? '' : item.trim(),
            finaliteActivated: true,
            clientID: receivedValues.clientID
          };

          let finalite = await finaliteSchema.findOne({
            labelFinalite: item,
            clientID: mongoose.Types.ObjectId(receivedValues.clientID)
          }).exec();

          if(finalite)
          {
            finalites.push(finalite._id);
          }
          else{
            let finaliteCreated = await finaliteSchema.create(finaliteData);
            if(finaliteCreated._id)
            {
              finalites.push(finaliteCreated._id);  
            }
            else{
              res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la finalité de l'emploi.",
              });
              return;
            }
          }
        }

        var activites = [];
        for await (var item of receivedValues.data.arrayActivitesImport) {
          let activiteData;
          activiteData = {
            labelActivite: !item ? '' : item.trim(),
            activiteActivated: true,
            clientID: receivedValues.clientID
          };

          let activite = await activiteSchema.findOne({
            labelActivite: item,
            clientID: mongoose.Types.ObjectId(receivedValues.clientID)
          }).exec();

          if(activite)
          {
            activites.push(activite._id);
          }
          else{
            let activiteCreated = await activiteSchema.create(activiteData);
            if(activiteCreated._id)
            {
              activites.push(activiteCreated._id);  
            }
            else{
              res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la description des activités significatives.",
              });
              return;
            }
          }
        }

        var responsabilites = [];
        for await (var item of receivedValues.data.arrayResponsabilitesImport) {
          let responsabiliteData;
          responsabiliteData = {
            labelResponsabilite: !item ? '' : item.trim(),
            responsabiliteActivated: true,
            clientID: receivedValues.clientID
          };

          let responsabilite = await responsabiliteSchema.findOne({
            labelResponsabilite: item,
            clientID: mongoose.Types.ObjectId(receivedValues.clientID)
          }).exec();

          if(responsabilite)
          {
            responsabilites.push(responsabilite._id);
          }
          else{
            let responsabiliteCreated = await responsabiliteSchema.create(responsabiliteData);
            if(responsabiliteCreated._id)
            {
              responsabilites.push(responsabiliteCreated._id);  
            }
            else{
              res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la responsabilités exercées et latitude d'action.",
              });
              return;
            }
          }
        }
    
        var relationsTravail = [];
        for await (var item of receivedValues.data.arrayRelationsImport) {
          let relationTravailData;
          relationTravailData = {
            labelRelationTravail: !item ? '' : item.trim(),
            relationTravailActivated: true,
            clientID: receivedValues.clientID
          };

          let relationTravail = await relationTravailSchema.findOne({
            labelRelationTravail: item,
            clientID: mongoose.Types.ObjectId(receivedValues.clientID)
          }).exec();

          if(relationTravail)
          {
            relationsTravail.push(relationTravail._id);
          }
          else{
            let relationTravailCreated = await relationTravailSchema.create(relationTravailData);
            if(relationTravailCreated._id)
            {
              relationsTravail.push(relationTravailCreated._id);  
            }
            else{
              res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la relations de travail.",
              });
              return;
            }
          }
        }

        var connaissances = [];
        for await (var item of receivedValues.data.arrayConnaissancesImport) {
          let connaissanceData;
          connaissanceData = {
            labelConnaissance: !item ? '' : item.trim(),
            connaissanceActivated: true,
            clientID: receivedValues.clientID
          };

          let connaissance = await connaissanceSchema.findOne({
            labelConnaissance: item,
            clientID: mongoose.Types.ObjectId(receivedValues.clientID)
          }).exec();

          if(connaissance)
          {
            connaissances.push(connaissance._id);
          }
          else{
            let connaissanceCreated = await connaissanceSchema.create(connaissanceData);
            if(connaissanceCreated._id)
            {
              connaissances.push(connaissanceCreated._id);  
            }
            else{
              res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la connaissances professionnelles spécifiques.",
              });
              return;
            }
          }
        }

        let Option = {
          new: true,
        };
        var count = getRandomInt(1, 100);
        clientSchema.findByIdAndUpdate(
          receivedValues.clientID,
          { $inc: { counterClient: count } },
          Option,
          (err, updatedData) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              let emploiData;
              emploiData = {
                intitule: !receivedValues.data.intituleEmploiImport
                ? ""
                : receivedValues.data.intituleEmploiImport.trim(),
                autresAppellations: !receivedValues.data.autresAppellationsEmploiImport
                ? ""
                : receivedValues.data.autresAppellationsEmploiImport.trim(),
                commentaire:  !receivedValues.data.commentaireEmploiImport
                ? ""
                : receivedValues.data.commentaireEmploiImport.trim(),
                activites: activites,
                responsabilites: responsabilites,
                relationsTravail: relationsTravail,
                connaissances: connaissances,
                finalites: finalites,
                refAnalyseEmploi: {
                  complexiteActivite: 0,
                  Connaissance: 0,
                  Autonomie: 0,
                  Contribution: 0,
                  encadrementcooperation: 0,
                  communication: 0,
                },
                cotation: 0,
                classeEmploi: 0,
                groupeEmploi: "-",
                isValidated: 'brouillon',
                entiteID: receivedValues.entiteID,
                directionID: receivedValues.directionID,
                serviceID: receivedValues.serviceID,
                userID: receivedValues.userID,
                emploiActivated: true,
                clientID: receivedValues.clientID,
                userValidatorID: null,
                id: updatedData.counterClient,
              };
              emploiSchema.create(emploiData, (err, data) => {
                if (!err) {
                  userSchema
                    .find({
                      userDeleted: false,
                      clientID: receivedValues.clientID,
                    })
                    .select({ __v: 0, password: 0 })
                    .lean()
                    .exec(async (err, listusers) => {
                      if (err) {
                        console.log(err);
                        res.json({
                          code: config.errCode,
                          status: "Error",
                          message: config.errMessage,
                        });
                        return;
                      } else {
                        emploiJson = JSON.parse(JSON.stringify(data));

                        for await (var item of listusers) {
                          if (
                            JSON.parse(
                              JSON.stringify(
                                item.permissionServicesShow
                              )
                            ).some(
                              (e) => e === receivedValues.serviceID
                            ) ||
                            item.userRole != "user"
                          ) {
                            let notificationData;
                            notificationData = {
                              messageNotification: "Nouvel emploi",
                              lienNotification: "lien",
                              notificationStatut: false,
                              notificationEtat: false,
                              userID: item._id,
                              emploiID: emploiJson._id,
                            };
                            await notificationSchema
                              .create(notificationData)
                              .then(async (notif) => {
                                if (notif) {
                                  // var html = `
                                  // <body style="width: 100% !important;background-color: #F8F8F8;">
                                  //   <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                                  //     style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                                  //     <div class="justify-content-center d-flex">
                                  //       <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                  //         style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                  //         heigth="auto">
                                  //         <tbody>
                                  //           <tr>
                                  //             <td align="left" valign="center"
                                  //               style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                  //               <img style="width: 59px;" src="../../../../assets/logos/classif.png" />
                                  //             </td>
                                  //             <td align="right" valign="center"
                                  //               style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                  //               <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">`+ emploiJson.createdAt + `</span>
                                  //             </td>
                                  //           </tr>
                                  //           <tr>
                                  //             <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                  //               <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">Bonjour,</h3>
                                  //               <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                  //                 Un nouvel emploi vient d'être créé :
                                  //               </p>
                                  //               <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                  //                 `+ emploiJson.intitule + `.
                                  //               </p>
                                  //             </td>
                                  //           </tr>
                                  //           <tr>
                                  //             <td colSpan="2">
                                  //               <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                  //                 style="min-width:100%;border-collapse:collapse;">
                                  //                 <tbody>
                                  //                   <tr>
                                  //                     <td style="padding:15px 0px;" valign="top" align="center">
                                  //                       <table border="0" cellpadding="0" cellspacing="0" style="border-collapse:separate !important;">
                                  //                         <tbody>
                                  //                           <tr>
                                  //                             <td align="center" valign="middle" style="padding:13px;">
                                  //                               <a href="#" title="START NOW" target="_blank"
                                  //                                 style="font-size: 14px; line-height: 1.5; font-weight: 700; letter-spacing: 1px; padding: 15px 40px; text-align:center; text-decoration:none; color:#FFFFFF; border-radius: 50px; background-color:#C45824;">
                                  //                                 Se connecter</a>
                                  //                             </td>
                                  //                           </tr>
                                  //                         </tbody>
                                  //                       </table>
                                  //                     </td>
                                  //                   </tr>
                                  //                 </tbody>
                                  //               </table>
                                  //             </td>
                                  //           </tr>
                                  //         </tbody>
                                  //       </table>
                                  //     </div>
                                  //     <div class="justify-content-center d-flex">
                                  //       <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                  //         <tbody>
                                  //           <tr>
                                  //             <td align="center" valign="center">
                                  //               <p
                                  //                 style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                  //                 Problèmes ou questions? Appelez-nous au <a href="tel:+212 06 61 58 76 54">+33 00 00 00 00</a> ou par
                                  //                 email <a href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                  //               </p>
                                  //               <p style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                  //                 <a target="_blank" href="www.metalclass.com"
                                  //                   style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a> Made with <i
                                  //                   style="color:#909090"> &#10084;</i> by <a target="_blank" href="www.metalclass.com"
                                  //                   style="color: #C45824; text-decoration:none;">Jennifer CERDAN</a>
                                  //               </p>
                                  //             </td>
                                  //           </tr>
                                  //         </tbody>
                                  //       </table>
                                  //     </div>
                                  //   </div>
                                  //   </body>
                                  // `;
                                  // var emailString = item.email;
                                  // var sendgrid = sgMail.setApiKey(config.sendGridApiKey);
                                  // await sendgrid.send({
                                  //     to: emailString,
                                  //     from: config.mailFrom,
                                  //     subject: 'Nouvel emploi créé',
                                  //     html: html
                                  // }, function (err, result2) {
                                  //     if (err) {
                                  //     } else {
                                  //     }
                                  // });
                                }
                              });
                          }
                        }

                        await data
                          .populate("activites")
                          .populate("responsabilites")
                          .populate("relationsTravail")
                          .populate("connaissances")
                          .populate("finalites")
                          .populate("clientID")
                          .populate("entiteID")
                          .populate("directionID")
                          .populate(
                            "serviceID",
                            function (err, emploi) {
                              res.json({
                                code: config.successCode,
                                status: "Success",
                                message:
                                  "L'emploi a été créé avec succès.",
                                data: emploi,
                              });
                            }
                          );
                      }
                    });
                } else {
                  res.json({
                    code: config.errCode,
                    status: "Error",
                    message: "Erreur lors de la création de l'emploi.",
                  });
                  return;
                }
              });
            }
          }
        );
        
      }
    });

  }
};

function capitalizeFirstLetter(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
};

exports.getEmploisClientReversibilite = (req, res) => {
  //var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
  var receivedValues = req.body;

  // var orderby = 1;
  // if (receivedValues.orderBy == "desc") {
  //   orderby = -1;
  // }

  var match = {};

  // match["intitule"] = {
  //   $regex: new RegExp(
  //     ".*" + receivedValues.intitule.toLowerCase() + ".*",
  //     "i"
  //   ),
  // };
  match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
  match["emploiActivated"] = true;
  // if (receivedValues.cotation != undefined && receivedValues.cotation != 0) {
  //   match["cotation"] = receivedValues.cotation;
  // }
  // if (receivedValues.id != undefined && receivedValues.id != 0) {
  //   match["id"] = receivedValues.id;
  // }
  // if (
  //   receivedValues.classeEmploi != undefined &&
  //   receivedValues.classeEmploi != 0
  // ) {
  //   match["classeEmploi"] = receivedValues.classeEmploi;
  // }
  // if (
  //   receivedValues.groupeEmploi != undefined &&
  //   receivedValues.groupeEmploi.trim() != ""
  // ) {
  //   match["groupeEmploi"] = receivedValues.groupeEmploi;
  // }
  // if (
  //   receivedValues.entiteID != undefined &&
  //   receivedValues.entiteID.trim() != ""
  // ) {
  //   match["entiteID._id"] = mongoose.Types.ObjectId(receivedValues.entiteID);
  // }
  // if (
  //   receivedValues.directionID != undefined &&
  //   receivedValues.directionID.trim() != ""
  // ) {
  //   match["directionID._id"] = mongoose.Types.ObjectId(
  //     receivedValues.directionID
  //   );
  // }
  // if (
  //   receivedValues.serviceID != undefined &&
  //   receivedValues.serviceID.trim() != ""
  // ) {
  //   match["serviceID._id"] = mongoose.Types.ObjectId(receivedValues.serviceID);
  // }
  // if (
  //   receivedValues.isValidated != undefined &&
  //   receivedValues.isValidated.trim() != ""
  // ) {
  //   match["isValidated"] = receivedValues.isValidated;
  // }

  emploiSchema
    .aggregate([
      {
        $lookup: {
          from: "client",
          localField: "clientID",
          foreignField: "_id",
          as: "clientID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userID",
          foreignField: "_id",
          as: "userID",
        },
      },
      {
        $lookup: {
          from: "user",
          localField: "userValidatorID",
          foreignField: "_id",
          as: "userValidatorID",
        },
      },
      {
        $lookup: {
          from: "entite",
          localField: "entiteID",
          foreignField: "_id",
          as: "entiteID",
        },
      },
      {
        $lookup: {
          from: "direction",
          localField: "directionID",
          foreignField: "_id",
          as: "directionID",
        },
      },
      {
        $lookup: {
          from: "service",
          localField: "serviceID",
          foreignField: "_id",
          as: "serviceID",
        },
      },
      {
        $project: {
          "userValidatorID.password": 0,
          "userValidatorID.userRole": 0,
          "userValidatorID.permissionServicesCreate": 0,
          "userValidatorID.permissionServicesShow": 0,
          "userValidatorID.permissionServicesValidate": 0,
          "userID.password": 0,
          "userID.userRole": 0,
          "userID.permissionServicesCreate": 0,
          "userID.permissionServicesShow": 0,
          "userID.permissionServicesValidate": 0,
        },
      },
      {
        $lookup: {
          from: "activite",
          localField: "activites",
          foreignField: "_id",
          as: "activites",
        },
      },
      {
        $lookup: {
          from: "responsabilite",
          localField: "responsabilites",
          foreignField: "_id",
          as: "responsabilites",
        },
      },
      {
        $lookup: {
          from: "relationTravail",
          localField: "relationsTravail",
          foreignField: "_id",
          as: "relationsTravail",
        },
      },
      {
        $lookup: {
          from: "connaissance",
          localField: "connaissances",
          foreignField: "_id",
          as: "connaissances",
        },
      },
      {
        $lookup: {
          from: "finalite",
          localField: "finalites",
          foreignField: "_id",
          as: "finalites",
        },
      },
      { $unwind: "$clientID" },
      { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
      {
        $unwind: { path: "$userValidatorID", preserveNullAndEmptyArrays: true },
      },
      { $unwind: "$entiteID" },
      { $unwind: "$directionID" },
      { $unwind: "$serviceID" },
      {
        $match: match,
      },
    ])
    .collation({ locale: "fr" })
    .then((listEmploisTotal, err) => {
      if (err) {
        console.log(err);
        res.json({
          code: config.errCode,
          status: "Error",
          message: config.errMessage,
        });
        return;
      } else {
        emploiSchema
          .aggregate([
            {
              $lookup: {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userID",
                foreignField: "_id",
                as: "userID",
              },
            },
            {
              $lookup: {
                from: "user",
                localField: "userValidatorID",
                foreignField: "_id",
                as: "userValidatorID",
              },
            },
            {
              $lookup: {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID",
              },
            },
            {
              $lookup: {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID",
              },
            },
            {
              $lookup: {
                from: "service",
                localField: "serviceID",
                foreignField: "_id",
                as: "serviceID",
              },
            },
            {
              $project: {
                "userValidatorID.password": 0,
                "userValidatorID.userRole": 0,
                "userValidatorID.permissionServicesCreate": 0,
                "userValidatorID.permissionServicesShow": 0,
                "userValidatorID.permissionServicesValidate": 0,
                "userID.password": 0,
                "userID.userRole": 0,
                "userID.permissionServicesCreate": 0,
                "userID.permissionServicesShow": 0,
                "userID.permissionServicesValidate": 0,
              },
            },
            {
              $lookup: {
                from: "activite",
                localField: "activites",
                foreignField: "_id",
                as: "activites",
              },
            },
            {
              $lookup: {
                from: "responsabilite",
                localField: "responsabilites",
                foreignField: "_id",
                as: "responsabilites",
              },
            },
            {
              $lookup: {
                from: "relationTravail",
                localField: "relationsTravail",
                foreignField: "_id",
                as: "relationsTravail",
              },
            },
            {
              $lookup: {
                from: "connaissance",
                localField: "connaissances",
                foreignField: "_id",
                as: "connaissances",
              },
            },
            {
              $lookup: {
                from: "finalite",
                localField: "finalites",
                foreignField: "_id",
                as: "finalites",
              },
            },
            { $unwind: "$clientID" },
            { $unwind: { path: "$userID", preserveNullAndEmptyArrays: true } },
            {
              $unwind: {
                path: "$userValidatorID",
                preserveNullAndEmptyArrays: true,
              },
            },
            { $unwind: "$entiteID" },
            { $unwind: "$directionID" },
            { $unwind: "$serviceID" },
            {
              $match: match,
            },
            //{ $sort: { [req.body.sortBy]: orderby } },
            //{ $limit: req.body.limit + offset },
            //{ $skip: offset },
          ])
          .collation({ locale: "fr" })
          .then((listEmplois, err) => {
            if (err) {
              console.log(err);
              res.json({
                code: config.errCode,
                status: "Error",
                message: config.errMessage,
              });
              return;
            } else {
              res.json({
                code: config.successCode,
                status: "success",
                data: {
                  listEmplois: listEmplois,
                  //totalEmplois: listEmploisTotal.length,
                  // totalPages: Math.ceil(
                  //   listEmploisTotal.length / req.body.limit
                  // ),
                },
              });
            }
          });
      }
    });
};
