// ********************************************************** Actualite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const actualiteSchema = mongoose.model('actualite');


// ********************************************************* actualite API *********************************************** //


exports.createEditActualite = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        actualiteSchema.findOne({
            _id: receivedValues.actualiteID
        })
            .select({ _id: 1 })
            .exec((err, actualiteInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!actualiteInfo) {
                    actualiteSchema.findOne({
                        titleActualite: receivedValues.titleActualite.trim()
                    }).select({ _id: 1 })
                        .exec((err, actualite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!actualite) {
                                let actualiteData;
                                actualiteData = {
                                    titleActualite: !receivedValues.titleActualite ? '' : receivedValues.titleActualite.trim(),
                                    contentActualite: !receivedValues.contentActualite ? '' : receivedValues.contentActualite.trim(),
                                    actualiteActivated: receivedValues.actualiteActivated,
                                    categorieActualite: receivedValues.categorieActualite
                                };
                                actualiteSchema.create(actualiteData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'actualité a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de l'actualité.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le titre de l'actualité existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    actualiteSchema.findOne({
                        titleActualite: receivedValues.titleActualite.trim()
                    }).select({ _id: 1 })
                        .exec((err, actualite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (actualite) {
                                var actualiteJson = JSON.parse(JSON.stringify(actualite));
                                var actualiteInfoJson = JSON.parse(JSON.stringify(actualiteInfo));
                                if (actualiteJson._id == actualiteInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let actualiteData;
                                actualiteData = {
                                    titleActualite: !receivedValues.titleActualite ? '' : receivedValues.titleActualite.trim(),
                                    contentActualite: !receivedValues.contentActualite ? '' : receivedValues.contentActualite.trim(),
                                    actualiteActivated: receivedValues.actualiteActivated,
                                    categorieActualite: receivedValues.categorieActualite,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                actualiteSchema.findByIdAndUpdate(actualiteInfo._id, actualiteData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'actualité a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le titre de l'actualité existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getActualites = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    actualiteSchema.find({
        titleActualite: { $regex: new RegExp('.*' + receivedValues.titleActualite.toLowerCase() + '.*', "i") }
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalActualite) => {
            if (!totalActualite || totalActualite === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune actualité trouvée.",
                });
                return;
            } else {
                actualiteSchema.find({
                    titleActualite: { $regex: new RegExp('.*' + receivedValues.titleActualite.toLowerCase() + '.*', "i") }
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .collation({ locale: "fr" })
                    .exec((err, listActualites) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listActualites: listActualites,
                                    totalActualites: totalActualite,
                                    totalPages: Math.ceil(totalActualite / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getActualitesDashboard = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    actualiteSchema.find({
        titleActualite: { $regex: new RegExp('.*' + receivedValues.titleActualite.toLowerCase() + '.*', "i") },
        actualiteActivated:true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalActualite) => {
            if (!totalActualite || totalActualite === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune actualité trouvée.",
                });
                return;
            } else {
                actualiteSchema.find({
                    titleActualite: { $regex: new RegExp('.*' + receivedValues.titleActualite.toLowerCase() + '.*', "i") },
                    actualiteActivated:true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .collation({ locale: "fr" })
                    .exec((err, listActualites) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listActualites: listActualites,
                                    totalActualites: totalActualite,
                                    totalPages: Math.ceil(totalActualite / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteActualiteByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["actualiteID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'actualiteID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        actualiteSchema.deleteOne({
            _id: receivedValues.actualiteID
        }).exec((err, actualiteInfo) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            }
            if (actualiteInfo.deletedCount === 1) {
                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "message": "L'actualité a été supprimée avec succès."
                });
            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
            }
        });
    }
};

exports.activatedActualite = (req, res) =>{
    var receivedValues = req.body;
    actualiteSchema.find({
            actualiteID: receivedValues.actualiteID
        })
            .lean()
            .exec((err, actualite) => {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    if (actualite) {

                        let fieldToSet;
                        fieldToSet = {
                            actualiteActivated: receivedValues.actualiteActivated,
                            updatedAt: config.utcDefault()
                        };
                        let Option = {
                            new: true
                        };
                        actualiteSchema.findByIdAndUpdate(receivedValues.actualiteID, fieldToSet, Option, (err, updatedData) => {
                            if (err) {
                                console.log(err);
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": config.errMessage,
                                });
                                return;
                            } else {
                                res.json({
                                    "code": config.successCode,
                                    "status": "Success",
                                    "message": "L'actualité a été modifiée avec succès.",
                                    "data": updatedData
                                });
                            }
                        });


                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": "Aucune actualité trouvée."
                        });
                    }
                }
            });
};