import { Base } from '../lib/Base';
import { CipherParamsInterface } from './CipherParamsInterface';
import { WordArray } from '../lib/WordArray';
import { Cipher } from '../lib/Cipher';
import { BlockCipherMode } from '../mode/BlockCipherMode';
import { Padding } from '../pad/Padding';
import { Formatter } from '../format/Formatter';
export declare class CipherParams extends Base implements CipherParamsInterface {
    ciphertext?: WordArray;
    key?: WordArray | string;
    iv?: WordArray;
    salt?: WordArray | string;
    algorithm?: typeof Cipher;
    mode?: typeof BlockCipherMode;
    padding?: Padding;
    blockSize?: number;
    formatter?: Formatter;
    /**
     * Initializes a newly created cipher params object.
     *
     * @param cipherParams An object with any of the possible cipher parameters.
     *
     * @example
     *
     *     let cipherParams = CipherParams.create({
     *         ciphertext: ciphertextWordArray,
     *         key: keyWordArray,
     *         iv: ivWordArray,
     *         salt: saltWordArray,
     *         algorithm: AESAlgorithm,
     *         mode: CBC,
     *         padding: PKCS7,
     *         blockSize: 4,
     *         formatter: OpenSSLFormatter
     *     });
     */
    constructor(cipherParams: CipherParamsInterface);
    extend(additionalParams: CipherParams): CipherParams;
    /**
     * Converts this cipher params object to a string.
     *
     * @param formatter (Optional) The formatting strategy to use.
     *
     * @return The stringified cipher params.
     *
     * @throws Error If neither the formatter nor the default formatter is set.
     *
     * @example
     *
     *     let string = cipherParams + '';
     *     let string = cipherParams.toString();
     *     let string = cipherParams.toString(CryptoJS.format.OpenSSL);
     */
    toString(formatter?: Formatter): string;
}
