// ********************************************************** responsabilite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const _ = require('lodash');
const chalk = require('chalk');
const responsabiliteSchema = mongoose.model('responsabilite');
const emploiSchema = mongoose.model('emploi');


// ********************************************************* responsabilite API *********************************************** //


exports.createEditResponsabilite = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        responsabiliteSchema.findOne({
            _id: req.body.responsabiliteID
        })
            .select({ _id: 1 })
            .exec((err, responsabiliteInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!responsabiliteInfo) {
                    responsabiliteSchema.findOne({
                        labelResponsabilite: receivedValues.labelResponsabilite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, responsabilite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!responsabilite) {
                                let responsabiliteData;
                                responsabiliteData = {
                                    labelResponsabilite: !receivedValues.labelResponsabilite ? '' : receivedValues.labelResponsabilite.trim(),
                                    responsabiliteActivated: receivedValues.responsabiliteActivated,
                                    clientID: receivedValues.clientID
                                };
                                responsabiliteSchema.create(responsabiliteData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La responsabilité a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de la responsabilité.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la responsabilité existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    responsabiliteSchema.findOne({
                        labelResponsabilite: receivedValues.labelResponsabilite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, responsabilite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (responsabilite) {
                                var responsabiliteJson = JSON.parse(JSON.stringify(responsabilite));
                                var responsabiliteInfoJson = JSON.parse(JSON.stringify(responsabiliteInfo));
                                if (responsabiliteJson._id == responsabiliteInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let responsabiliteData;
                                responsabiliteData = {
                                    labelResponsabilite: !receivedValues.labelResponsabilite ? '' : receivedValues.labelResponsabilite.trim(),
                                    responsabiliteActivated: receivedValues.responsabiliteActivated,
                                    clientID: receivedValues.clientID
                                };
                                let Option = {
                                    new: true
                                };

                                responsabiliteSchema.findByIdAndUpdate(responsabiliteInfo._id, responsabiliteData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "la responsabilité a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la responsabilité existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getResponsabilitesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    responsabiliteSchema.find({
        labelResponsabilite: { $regex: new RegExp('.*' + receivedValues.labelResponsabilite.toLowerCase() + '.*', "i") },
        clientID: receivedValues.clientID,
        responsabiliteActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalResponsabilites) => {
            if (!totalResponsabilites || totalResponsabilites === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune responsabilité trouvée.",
                });
                return;
            } else {
                responsabiliteSchema.find({
                    labelResponsabilite: { $regex: new RegExp('.*' + receivedValues.labelResponsabilite.toLowerCase() + '.*', "i") },
                    clientID: receivedValues.clientID,
                    responsabiliteActivated: true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listResponsabilites) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listResponsabilites: listResponsabilites,
                                    totalResponsabilites: totalResponsabilites,
                                    totalPages: Math.ceil(totalResponsabilites / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getResponsabilites = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelResponsabilite"] = { $regex: new RegExp('.*' + receivedValues.labelResponsabilite.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["responsabiliteActivated"] = true;

    responsabiliteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listResponsabilitesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                responsabiliteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])

                    .collation({ locale: "fr" })
                    .then((listResponsabilites, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listResponsabilites: listResponsabilites,
                                    totalResponsabilites: listResponsabilitesTotal.length,
                                    totalPages: Math.ceil(listResponsabilitesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteResponsabiliteByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["responsabiliteID", "clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'responsabiliteID') && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        emploiSchema.find({
            clientID: receivedValues.clientID
        })
            .populate("responsabilites")
            .then((emplois) => {
                if (emplois || emplois.length != 0) {

                    var emploiJson = JSON.parse(JSON.stringify(emplois));

                    for (var item of emploiJson) {
                        if (item.responsabilites.filter(e => e._id === receivedValues.responsabiliteID).length != 0) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Impossible de supprimer la responsabilité, des emplois sont liés à cette dernière.",
                            });
                            return;
                        }
                    }
                }
                responsabiliteSchema.deleteOne({
                    _id: receivedValues.responsabiliteID
                }).exec((err, responsabiliteInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (responsabiliteInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "La responsabilité a été supprimée avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });


            });
    }
};

exports.importResponsabilites = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Invalid data enter",
            "dataDoublons": []
        });
    } else {
        var responsabilites = [];
        var responsabilitesDouble = [];
        for await (var item of receivedValues.data) {
            let responsabiliteData;
            responsabiliteData = {
                labelResponsabilite: !item.labelResponsabilite ? '' : item.labelResponsabilite.trim(),
                responsabiliteActivated: true,
                clientID: receivedValues.clientID
            };

            await responsabiliteSchema.findOne({
                labelResponsabilite: item.labelResponsabilite,
                clientID: mongoose.Types.ObjectId(receivedValues.clientID)
            })
                .lean()
                .then((responsabilite) => {
                    if (responsabilite) {
                        responsabilitesDouble.push(responsabiliteData);
                    } else {
                        responsabilites.push(responsabiliteData);
                    }
                });
        }

        if (responsabilitesDouble.length != 0) {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Merci de bien vouloir supprimer le(s) doublon(s) avant d'impoter la liste.",
                "dataDoublons": responsabilitesDouble
            });
            return;
        } else {
            responsabiliteSchema.insertMany(responsabilites)
                .then(function (data) {
                    console.log(data);
                    res.json({
                        "code": 200,
                        "status": "Success",
                        "message": "Les responsabilités ont été importées avec succès."
                    });
                })
                .catch(function (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message,
                        "dataDoublons": []
                    });
                    return;
                });
        }

    }
};


