// ********************************************************** entite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const entiteSchema = mongoose.model('entite');
const userSchema = mongoose.model('user');
const directionSchema = mongoose.model('direction');
const serviceSchema = mongoose.model('service');

// ********************************************************* entite API *********************************************** //


exports.createEditEntite = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        entiteSchema.findOne({
            _id: req.body.entiteID
        })
            .select({ _id: 1 })
            .exec((err, entiteInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!entiteInfo) {
                    entiteSchema.findOne({
                        labelEntite: receivedValues.labelEntite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, entite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!entite) {
                                let entiteData;
                                entiteData = {
                                    labelEntite: !receivedValues.labelEntite ? '' : receivedValues.labelEntite.trim(),
                                    entiteActivated: receivedValues.entiteActivated,
                                    acronymeEntite : !receivedValues.labelEntite ? '' : receivedValues.labelEntite.trim().substr(0,3).toUpperCase(),
                                    clientID: receivedValues.clientID
                                };
                                entiteSchema.create(entiteData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'entité a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de l'entité.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom de l'entité existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    entiteSchema.findOne({
                        labelEntite: receivedValues.labelEntite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, entite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (entite) {
                                var entiteJson = JSON.parse(JSON.stringify(entite));
                                var entiteInfoJson = JSON.parse(JSON.stringify(entiteInfo));
                                if (entiteJson._id == entiteInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let entiteData;
                                entiteData = {
                                    labelEntite: !receivedValues.labelEntite ? '' : receivedValues.labelEntite.trim(),
                                    entiteActivated: receivedValues.entiteActivated,
                                    acronymeEntite : !receivedValues.labelEntite ? '' : receivedValues.labelEntite.trim().substr(0,3).toUpperCase(),
                                    clientID: receivedValues.clientID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                entiteSchema.findByIdAndUpdate(entiteInfo._id, entiteData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'entité a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom de l'entité existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getEntitesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    entiteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': {
                'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                labelEntite: { $regex: new RegExp('.*' + receivedValues.labelEntite.toLowerCase() + '.*', "i") },
                entiteActivated: true,
            }
        }
    ]).then((entites) => {
            if (!entites || entites.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée.",
                });
                return;
            } else {
                entiteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': {
                            'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                            labelEntite: { $regex: new RegExp('.*' + receivedValues.labelEntite.toLowerCase() + '.*', "i") },
                            entiteActivated: true,
                        }
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listEntites) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listEntites: listEntites,
                                    totalEntites: entites.length,
                                    totalPages: Math.ceil(entites.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        });

};

exports.getEntites = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};
    match["labelEntite"] = { $regex: new RegExp('.*' + receivedValues.labelEntite.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["entiteActivated"] =true;
    

    entiteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
             '$match': match
        }
    ]).then((entites) => {
            if (!entites || entites.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée.",
                });
                return;
            } else {
                entiteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                         '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listEntites) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listEntites: listEntites,
                                    totalEntites: entites.length,
                                    totalPages: Math.ceil(entites.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        });

};

exports.getEntitesClientUser = (req, res) => {
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .populate("permissionServicesCreate")
        .populate({
            path: 'permissionServicesCreate',
            populate: [
                {
                    path: 'directionID',
                    populate: {
                        path: 'entiteID'
                    }
                }
            ]
        })
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));

                var listDirections = [];
                for (var item of userJSON.permissionServicesCreate) {
                    if (listDirections.findIndex(x => x._id === item.directionID._id) == -1)
                        listDirections.push(item.directionID)
                }

                var listEntites = [];
                for (var item of listDirections) {
                    if (listEntites.findIndex(x => x._id === item.entiteID._id) == -1)
                        listEntites.push(item.entiteID)
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: listEntites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });

};

exports.getEntitesClientUserFilterEmploi = (req, res) => {
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .populate("permissionServicesShow")
        .populate({
            path: 'permissionServicesShow',
            populate: [
                {
                    path: 'directionID',
                    populate: {
                        path: 'entiteID'
                    }
                }
            ]
        })
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));

                var listDirections = [];
                for (var item of userJSON.permissionServicesShow) {
                    if (listDirections.findIndex(x => x._id === item.directionID._id) == -1)
                        listDirections.push(item.directionID)
                }

                var listEntites = [];
                for (var item of listDirections) {
                    if (listEntites.findIndex(x => x._id === item.entiteID._id) == -1)
                        listEntites.push(item.entiteID)
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: listEntites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });

};

exports.deleteEntiteByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["entiteID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'entiteID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }

        directionSchema.find({
            entiteID: req.body.entiteID
        })
            .lean()
            .countDocuments()
            .then(counts => {
                return counts;
            }).then((totalDirections) => {
                if (!totalDirections || totalDirections === 0) {
                    entiteSchema.deleteOne({
                        _id: req.body.entiteID
                    }).exec((err, compagneInfo) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        }
                        if (compagneInfo.deletedCount === 1) {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "message": "L'entité a été supprimée avec succès."
                            });
                        } else {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                        }
                    });

                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Impossible de supprimer l'entité, des directions sont liées à cette dernière.",
                    });
                    return;
                }
            });
    }
};

exports.getEntitesClientV2 = (req, res) => {

    var receivedValues = req.body;
    entiteSchema.find({
        clientID: receivedValues.clientID,
        entiteActivated: true
    })
        .sort({ createdAt: 1 })
        .select({ __v: 0, password: 0 })
        .exec(async (err, entites) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (entites.length != 0) {

                entites = JSON.parse(JSON.stringify(entites));

                for (var entite of entites) {
                    entiteIndex = entites.findIndex((obj => obj._id == entite._id));

                    await directionSchema.find({
                        entiteID: entite._id,
                        directionActivated: true
                    })
                        .then(async (directions) => {

                            if (directions.length != 0) {
                                directions = JSON.parse(JSON.stringify(directions));
                                for (var direction of directions) {
                                    directionIndex = directions.findIndex((obj => obj._id == direction._id));

                                    await serviceSchema.find({
                                        directionID: direction._id,
                                        serviceActivated: true
                                    }, function (err, services) {
                                        if (services.length != 0) {
                                            services = JSON.parse(JSON.stringify(services));
                                            directions[directionIndex].services = services;
                                        }
                                        else {
                                        }
                                    });
                                }
                                entites[entiteIndex].directions = directions;
                            } else {
                            }
                        });
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: entites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée."
                });
            }
        });

};

exports.getEntitesClientPermissionGestion = (req, res) => {

    var receivedValues = req.body;
    entiteSchema.find({
        clientID: receivedValues.clientID,
        entiteActivated: true
    })
        .sort({ createdAt: 1 })
        .then(async (entites) => {
            if (entites.length != 0) {

                entites = JSON.parse(JSON.stringify(entites));

                for await (var entite of entites) {
                    entiteIndex = entites.findIndex((obj => obj._id == entite._id));

                    await directionSchema.find({
                        entiteID: entite._id,
                        directionActivated: true
                    })
                        .then(async (directions) => {

                            if (directions.length != 0) {

                                directions = JSON.parse(JSON.stringify(directions));

                                for await (var direction of directions) {
                                    directionIndex = directions.findIndex((obj => obj._id == direction._id));
                                    await serviceSchema.find({
                                        directionID: direction._id,
                                        serviceActivated: true
                                    }).then(async (services) => {
                                        if (services.length != 0) {
                                            services =await JSON.parse(JSON.stringify(services));
                                            directions[directionIndex].services = services;
                                        }
                                        else {
                                        }

                                    });
                                }
                                entites[entiteIndex].directions = directions;
                            } else {
                            }
                        });
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: entites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée."
                });
            }
        });

};

exports.getEntitesClientPermissionConsultation = (req, res) => {

    var receivedValues = req.body;
    entiteSchema.find({
        clientID: receivedValues.clientID,
        entiteActivated: true
    })
        .sort({ createdAt: 1 })
        .then(async (entites) => {
            if (entites.length != 0) {

                entites = JSON.parse(JSON.stringify(entites));

                for await (var entite of entites) {
                    entiteIndex = await entites.findIndex((obj => obj._id == entite._id));

                    await directionSchema.find({
                        entiteID: entite._id,
                        directionActivated: true
                    })
                        .then(async (directions) => {

                            if (directions.length != 0) {
                                directions = await JSON.parse(JSON.stringify(directions));
                                for await (var direction of directions) {
                                    directionIndex = await directions.findIndex((obj => obj._id == direction._id));
                                    await serviceSchema.find({
                                        directionID: direction._id,
                                        serviceActivated: true
                                    }).then(async (services) => {
                                        if (services.length != 0) {
                                            services = await JSON.parse(JSON.stringify(services));
                                            directions[directionIndex].services = services;
                                        }
                                        else {
                                        }

                                    });
                                }
                                entites[entiteIndex].directions = directions;
                            } else {
                            }
                        });
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: entites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée."
                });
            }
        });

};

exports.getEntitesClientPermissionValidation = (req, res) => {

    var receivedValues = req.body;
    entiteSchema.find({
        clientID: receivedValues.clientID,
        entiteActivated: true
    })
        .sort({ createdAt: 1 })
        .then(async (entites) => {
            if (entites.length != 0) {

                entites = JSON.parse(JSON.stringify(entites));

                for await (var entite of entites) {
                    entiteIndex = entites.findIndex((obj => obj._id == entite._id));

                    await directionSchema.find({
                        entiteID: entite._id,
                        directionActivated: true
                    })
                        .then(async (directions) => {

                            if (directions.length != 0) {

                                directions = JSON.parse(JSON.stringify(directions));

                                for await (var direction of directions) {
                                    directionIndex = directions.findIndex((obj => obj._id == direction._id));
                                    await serviceSchema.find({
                                        directionID: direction._id,
                                        serviceActivated: true
                                    }).then(async (services) => {
                                        if (services.length != 0) {
                                            services =await JSON.parse(JSON.stringify(services));
                                            directions[directionIndex].services = services;
                                        }
                                        else {
                                        }

                                    });
                                }
                                entites[entiteIndex].directions = directions;
                            } else {
                            }
                        });
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listEntites: entites
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucune entité trouvée."
                });
            }
        });

};




