// ********************************************************** relationTravail controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const _ = require('lodash');
const chalk = require('chalk');
const relationTravailSchema = mongoose.model('relationTravail');
const emploiSchema = mongoose.model('emploi');


// ********************************************************* relationTravail API *********************************************** //


exports.createEditRelationTravail = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        relationTravailSchema.findOne({
            _id: req.body.relationTravailID
        })
            .select({ _id: 1 })
            .exec((err, relationTravailInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!relationTravailInfo) {
                    relationTravailSchema.findOne({
                        labelRelationTravail: receivedValues.labelRelationTravail.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, relationTravail) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!relationTravail) {
                                let relationTravailData;
                                relationTravailData = {
                                    labelRelationTravail: !receivedValues.labelRelationTravail ? '' : receivedValues.labelRelationTravail.trim(),
                                    relationTravailActivated: receivedValues.relationTravailActivated,
                                    clientID: receivedValues.clientID
                                };
                                relationTravailSchema.create(relationTravailData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La relation de travail a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de la relation de travail.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la relation de travail existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    relationTravailSchema.findOne({
                        labelRelationTravail: receivedValues.labelRelationTravail.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, relationTravail) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (relationTravail) {
                                var relationTravailJson = JSON.parse(JSON.stringify(relationTravail));
                                var relationTravailInfoJson = JSON.parse(JSON.stringify(relationTravailInfo));
                                if (relationTravailJson._id == relationTravailInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let relationTravailData;
                                relationTravailData = {
                                    labelRelationTravail: !receivedValues.labelRelationTravail ? '' : receivedValues.labelRelationTravail.trim(),
                                    relationTravailActivated: receivedValues.relationTravailActivated,
                                    clientID: receivedValues.clientID
                                };
                                let Option = {
                                    new: true
                                };

                                relationTravailSchema.findByIdAndUpdate(relationTravailInfo._id, relationTravailData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "la relation de travail a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la relation de travail existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getRelationTravailsClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    relationTravailSchema.find({
        labelRelationTravail: { $regex: new RegExp('.*' + receivedValues.labelRelationTravail.toLowerCase() + '.*', "i") },
        clientID: receivedValues.clientID,
        relationTravailActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalRelationTravails) => {
            if (!totalRelationTravails || totalRelationTravails === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune relation de travail trouvée.",
                });
                return;
            } else {
                relationTravailSchema.find({
                    labelRelationTravail: { $regex: new RegExp('.*' + receivedValues.labelRelationTravail.toLowerCase() + '.*', "i") },
                    clientID: receivedValues.clientID,
                    relationTravailActivated: true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listRelationTravails) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listRelationTravails: listRelationTravails,
                                    totalRelationTravails: totalRelationTravails,
                                    totalPages: Math.ceil(totalRelationTravails / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getRelationTravails = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelRelationTravail"] = { $regex: new RegExp('.*' + receivedValues.labelRelationTravail.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["relationTravailActivated"] = true;

    relationTravailSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listRelationTravailTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                relationTravailSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])

                    .collation({ locale: "fr" })
                    .then((listRelationTravails, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listRelationTravails: listRelationTravails,
                                    totalRelationTravails: listRelationTravailTotal.length,
                                    totalPages: Math.ceil(listRelationTravailTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteRelationTravailByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["relationTravailID", "clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'relationTravailID') && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        emploiSchema.find({
            clientID: receivedValues.clientID
        })
            .populate("relationsTravail")
            .then((emplois) => {
                if (emplois || emplois.length != 0) {

                    var emploiJson = JSON.parse(JSON.stringify(emplois));

                    for (var item of emploiJson) {
                        if (item.relationsTravail.filter(e => e._id === receivedValues.relationTravailID).length != 0) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Impossible de supprimer la relation de travail, des emplois sont liés à cette dernière.",
                            });
                            return;
                        }
                    }
                }
                relationTravailSchema.deleteOne({
                    _id: receivedValues.relationTravailID
                }).exec((err, relationTravailInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (relationTravailInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "La relation de travail a été supprimée avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });


            });
    }
};

exports.importRelationTravails = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Invalid data enter",
            "dataDoublons": []
        });
    } else {
        var relationTravails = [];
        var relationTravailsDouble = [];
        for await (var item of receivedValues.data) {
            let relationTravailData;
            relationTravailData = {
                labelRelationTravail: !item.labelRelationTravail ? '' : item.labelRelationTravail.trim(),
                relationTravailActivated: true,
                clientID: receivedValues.clientID
            };

            await relationTravailSchema.findOne({
                labelRelationTravail: item.labelRelationTravail,
                clientID: mongoose.Types.ObjectId(receivedValues.clientID)
            })
                .lean()
                .then((relationTravail) => {
                    if (relationTravail) {
                        relationTravailsDouble.push(relationTravailData);
                    } else {
                        relationTravails.push(relationTravailData);
                    }
                });
        }

        if (relationTravailsDouble.length != 0) {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Merci de bien vouloir supprimer le(s) doublon(s) avant d'impoter la liste.",
                "dataDoublons": relationTravailsDouble
            });
            return;
        } else {
            relationTravailSchema.insertMany(relationTravails)
                .then(function (data) {
                    console.log(data);
                    res.json({
                        "code": 200,
                        "status": "Success",
                        "message": "Les Relations de travail ont été importées avec succès."
                    });
                })
                .catch(function (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message,
                        "dataDoublons": []
                    });
                    return;
                });
        }

    }
};

