import { BufferedBlockAlgorithmConfig } from './lib/BufferedBlockAlgorithmConfig';
import { WordArray } from './lib/WordArray';
import { BlockCipher } from './lib/BlockCipher';
import { CipherParams } from './lib/CipherParams';
import { Hasher } from './lib/Hasher';
import { SerializableCipher } from './lib/SerializableCipher';
import { PasswordBasedCipher } from './lib/PasswordBasedCipher';
export declare const lib: {
    BlockCipher: typeof BlockCipher;
    WordArray: typeof WordArray;
    CipherParams: typeof CipherParams;
    Hasher: typeof Hasher;
    SerializableCipher: typeof SerializableCipher;
    PasswordBasedCipher: typeof PasswordBasedCipher;
};
import { AES as AESAlgorithm } from './algo/AES';
import { SHA256 as SHA256Algorithm } from './algo/SHA256';
export declare const algo: {
    AES: typeof AESAlgorithm;
    SHA256: typeof SHA256Algorithm;
};
import { Utf8 } from './enc/Utf8';
import { Hex } from './enc/Hex';
export declare const enc: {
    Utf8: typeof Utf8;
    Hex: typeof Hex;
};
import { NoPadding } from './pad/NoPadding';
import { PKCS7 } from './pad/PKCS7';
export declare const pad: {
    NoPadding: typeof NoPadding;
    PKCS7: typeof PKCS7;
};
import { CBC } from './mode/CBC';
import { ECB } from './mode/ECB';
export declare const mode: {
    CBC: typeof CBC;
    ECB: typeof ECB;
};
export declare const AES: {
    encrypt: (message: string | WordArray, key: string | WordArray, cfg?: BufferedBlockAlgorithmConfig | undefined) => CipherParams;
    decrypt: (ciphertext: string | CipherParams, key: string | WordArray, cfg?: BufferedBlockAlgorithmConfig | undefined) => WordArray;
};
export declare const SHA256: (message: string | WordArray, cfg?: BufferedBlockAlgorithmConfig | undefined) => any;
