var mongoose = require('mongoose');
var bcrypt = require('bcrypt-nodejs');

var UserSchema = mongoose.Schema({
    userCodeSecurite:{
        type: String,
        required: false,
    },
    userDateExpiredCodeSecurite:{
        type: Date,
        required: false,
    },
    password: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    firstName: {
        type: String
    },
    lastName: {
        type: String
    },
    mobile: {
        type: String
    },
    userImage: {
        type: String
    },
    userActivated: {
        type: Boolean,
        default: true
    },
    userAutorisationValidation: {
        type: Boolean,
        default: true
    },
    userRole: {
        type: String,
        enum: ['superAdmin', 'admin', 'user'],
        default: 'admin'
    },
    userDeleted: {
        type: Boolean,
        default: false
    },
    clientID: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'client'
    },
    permissionServicesShow: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'service'
        }
    ],
    permissionServicesValidate: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'service'
        }
    ],
    permissionServicesCreate: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'service'
        }
    ],
    classementActivated: {
        type: Boolean,
        default: false
    }
}, { timestamps: true });

UserSchema.methods.generateHash = function (password) {
    return bcrypt.hashSync(password, bcrypt.genSaltSync(8), null);
};

// checking if password is valid
UserSchema.methods.validPassword = function (password) {
    return bcrypt.compareSync(password, this.password);
};

UserSchema.index({ email: 'text' });

module.exports = mongoose.model('user', UserSchema, 'user');
