// ********************************************************** connaissance controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const connaissanceSchema = mongoose.model('connaissance');
const emploiSchema = mongoose.model('emploi');


// ********************************************************* connaissance API *********************************************** //


exports.createEditConnaissance = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        connaissanceSchema.findOne({
            _id: req.body.connaissanceID
        })
            .select({ _id: 1 })
            .exec((err, connaissanceInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!connaissanceInfo) {
                    connaissanceSchema.findOne({
                        labelConnaissance: receivedValues.labelConnaissance.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, connaissance) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!connaissance) {
                                let connaissanceData;
                                connaissanceData = {
                                    labelConnaissance: !receivedValues.labelConnaissance ? '' : receivedValues.labelConnaissance.trim(),
                                    connaissanceActivated: receivedValues.connaissanceActivated,
                                    clientID: receivedValues.clientID
                                };
                                connaissanceSchema.create(connaissanceData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La connaissance a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de la connaissance.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la connaissance existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    connaissanceSchema.findOne({
                        labelConnaissance: receivedValues.labelConnaissance.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, connaissance) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (connaissance) {
                                var connaissanceJson = JSON.parse(JSON.stringify(connaissance));
                                var connaissanceInfoJson = JSON.parse(JSON.stringify(connaissanceInfo));
                                if (connaissanceJson._id == connaissanceInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let connaissanceData;
                                connaissanceData = {
                                    labelConnaissance: !receivedValues.labelConnaissance ? '' : receivedValues.labelConnaissance.trim(),
                                    connaissanceActivated: receivedValues.connaissanceActivated,
                                    clientID: receivedValues.clientID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                connaissanceSchema.findByIdAndUpdate(connaissanceInfo._id, connaissanceData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La connaissance a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la connaissance existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getConnaissancesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelConnaissance"] = { $regex: new RegExp('.*' + receivedValues.labelConnaissance.toLowerCase() + '.*', "i") };
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    match["connaissanceActivated"] = true;

    connaissanceSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },

        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listConnaissancesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                connaissanceSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .then((listConnaissances, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listConnaissances: listConnaissances,
                                    totalConnaissances: listConnaissancesTotal.length,
                                    totalPages: Math.ceil(listConnaissancesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getConnaissances = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelConnaissance"] = { $regex: new RegExp('.*' + receivedValues.labelConnaissance.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["connaissanceActivated"] = true;

    connaissanceSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listConnaissancesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                connaissanceSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])

                    .collation({ locale: "fr" })
                    .then((listConnaissances, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listConnaissances: listConnaissances,
                                    totalConnaissances: listConnaissancesTotal.length,
                                    totalPages: Math.ceil(listConnaissancesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteConnaissanceByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["connaissanceID", "clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'connaissanceID') && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        emploiSchema.find({
            clientID: receivedValues.clientID
        })
            .populate("connaissances")
            .then((emplois) => {
                if (emplois || emplois.length != 0) {

                    var emploiJson = JSON.parse(JSON.stringify(emplois));

                    for (var item of emploiJson) {
                        if (item.connaissances.filter(e => e._id === receivedValues.connaissanceID).length != 0) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Impossible de supprimer la connaissance, des emplois sont liés à cette dernière.",
                            });
                            return;
                        }
                    }
                }
                connaissanceSchema.deleteOne({
                    _id: receivedValues.connaissanceID
                }).exec((err, connaissanceInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (connaissanceInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "La connaissance a été supprimée avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });


            });
    }
};

exports.importConnaissances = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Invalid data enter",
            "dataDoublons": []
        });
    } else {
        var connaissances = [];
        var connaissancesDouble = [];
        for await (var item of receivedValues.data) {
            let connaissanceData;
            connaissanceData = {
                labelConnaissance: !item.labelConnaissance ? '' : item.labelConnaissance.trim(),
                connaissanceActivated: true,
                clientID: receivedValues.clientID
            };

            await connaissanceSchema.findOne({
                labelConnaissance: item.labelConnaissance,
                clientID: mongoose.Types.ObjectId(receivedValues.clientID)
            })
                .lean()
                .then((connaissance) => {
                    if (connaissance) {
                        connaissancesDouble.push(connaissanceData);
                    } else {
                        connaissances.push(connaissanceData);
                    }
                });
        }

        if (connaissancesDouble.length != 0) {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Merci de bien vouloir supprimer le(s) doublon(s) avant d'impoter la liste.",
                "dataDoublons": connaissancesDouble
            });
            return;
        } else {
            connaissanceSchema.insertMany(connaissances)
                .then(function (data) {
                    console.log(data);
                    res.json({
                        "code": 200,
                        "status": "Success",
                        "message": "Les connaissances ont été importées avec succès."
                    });
                })
                .catch(function (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message,
                        "dataDoublons": []
                    });
                    return;
                });
        }

    }
};


