// ********************************************************** activite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const classesEmploisSchema = mongoose.model('classesEmplois');
const emploiSchema = mongoose.model('emploi');



// ********************************************************* activite API *********************************************** //
var classesEmploisJson = [
    { cotationsDe: 6, cotationsA: 9, ClassesEmplois: 1, GroupesEmplois: "A", salaireMinimum: 20000 },
    { cotationsDe: 10, cotationsA: 12, ClassesEmplois: 2, GroupesEmplois: "A", salaireMinimum: 25000 },
    { cotationsDe: 13, cotationsA: 15, ClassesEmplois: 3, GroupesEmplois: "B", salaireMinimum: 30000 },
    { cotationsDe: 16, cotationsA: 18, ClassesEmplois: 4, GroupesEmplois: "B", salaireMinimum: 35000 },
    { cotationsDe: 19, cotationsA: 21, ClassesEmplois: 5, GroupesEmplois: "C", salaireMinimum: 40000 },
    { cotationsDe: 22, cotationsA: 24, ClassesEmplois: 6, GroupesEmplois: "C", salaireMinimum: 45000 },
    { cotationsDe: 25, cotationsA: 27, ClassesEmplois: 7, GroupesEmplois: "D", salaireMinimum: 50000 },
    { cotationsDe: 28, cotationsA: 30, ClassesEmplois: 8, GroupesEmplois: "D", salaireMinimum: 55000 },
    { cotationsDe: 31, cotationsA: 33, ClassesEmplois: 9, GroupesEmplois: "E", salaireMinimum: 60000 },
    { cotationsDe: 34, cotationsA: 36, ClassesEmplois: 10, GroupesEmplois: "E", salaireMinimum: 65000 },
    { cotationsDe: 37, cotationsA: 39, ClassesEmplois: 11, GroupesEmplois: "F", salaireMinimum: 70000 },
    { cotationsDe: 40, cotationsA: 42, ClassesEmplois: 12, GroupesEmplois: "F", salaireMinimum: 75000 },
    { cotationsDe: 43, cotationsA: 45, ClassesEmplois: 13, GroupesEmplois: "G", salaireMinimum: 80000 },
    { cotationsDe: 46, cotationsA: 48, ClassesEmplois: 14, GroupesEmplois: "G", salaireMinimum: 85000 },
    { cotationsDe: 49, cotationsA: 51, ClassesEmplois: 15, GroupesEmplois: "H", salaireMinimum: 90000 },
    { cotationsDe: 52, cotationsA: 54, ClassesEmplois: 16, GroupesEmplois: "H", salaireMinimum: 95000 },
    { cotationsDe: 55, cotationsA: 57, ClassesEmplois: 17, GroupesEmplois: "I", salaireMinimum: 100000 },
    { cotationsDe: 58, cotationsA: 60, ClassesEmplois: 18, GroupesEmplois: "I", salaireMinimum: 105000 }
];

exports.createClassesEmplois = (req, res) => {

    classesEmploisSchema.remove({}, (err, data) => {
    });

    classesEmploisSchema.create(classesEmploisJson, (err, data) => {
        if (!err) {
            res.json({
                "code": config.successCode,
                "status": "Success",
                "message": "La table classes d'emplois a été créée avec succès.",
                data: data
            });
        } else {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Erreur lors de la création de la table classes d'emplois.",
            });
            return;
        }
    });
};

exports.getclassesEmplois = (req, res) => {
    classesEmploisSchema.find()
        .lean()
        .sort({ ClassesEmplois: "desc" })
        .exec((err, classesEmplois) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        classesEmplois: classesEmplois
                    }
                });
            }
        });
};

exports.getclassesEmploisByCotation = (req, res) => {
    var receivedValues = req.body;
    classesEmploisSchema.find()
        .lean()
        .sort({ ClassesEmplois: "desc" })
        .exec((err, classesEmplois) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {

                var classeEmploi;
                for (var item of classesEmplois) {
                    if (receivedValues.cotation >= item.cotationsDe && receivedValues.cotation <= item.cotationsA) {
                        classeEmploi = item;
                    }
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        classesEmplois: classeEmploi
                    }
                });
            }
        });
};

exports.getEmploisByClassesEmploisAndGroupesEmplois = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    emploiSchema.find({
        intitule: { $regex: new RegExp('.*' + receivedValues.intitule.toLowerCase() + '.*', "i") },
        clientID: receivedValues.clientID,
        classeEmploi: receivedValues.classeEmploi,
        groupeEmploi: receivedValues.groupeEmploi,
        emploiActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalEmplois) => {
            if (!totalEmplois || totalEmplois === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune emploi trouvé.",
                });
                return;
            } else {

                emploiSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "entite",
                            localField: "entiteID",
                            foreignField: "_id",
                            as: "entiteID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "direction",
                            localField: "directionID",
                            foreignField: "_id",
                            as: "directionID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "service",
                            localField: "serviceID",
                            foreignField: "_id",
                            as: "serviceID"
                        }
                    },
                    { $unwind: '$clientID' },
                    { $unwind: '$entiteID' },
                    { $unwind: '$directionID' },
                    { $unwind: '$serviceID' },
                    {
                        '$match': {
                            intitule: { $regex: new RegExp('.*' + receivedValues.intitule.toLowerCase() + '.*', "i") },
                            'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                            classeEmploi: receivedValues.classeEmploi,
                            groupeEmploi: receivedValues.groupeEmploi,
                            emploiActivated: true
                        }
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listEmplois) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listEmplois: listEmplois,
                                    totalEmplois: totalEmplois,
                                    totalPages: Math.ceil(totalEmplois / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.editSalairesMinimums = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {

        for (var item of receivedValues.classesEmploi) {
            await classesEmploisSchema.updateOne({"ClassesEmplois": item.ClassesEmplois, "GroupesEmplois":item.GroupesEmplois}, {"$set":{"salaireMinimum": item.salaireMinimum}});
        }

        res.json({
            "code": config.successCode,
            "status": "success",
            "message": "l'echelle de classification a été mise à jour avec succès.",
            }
        );
    }
};


