import { BlockCipher } from '../lib/BlockCipher';
import { WordArray } from '../lib/WordArray';
import { BufferedBlockAlgorithmConfig } from '../lib/BufferedBlockAlgorithmConfig';
export declare class AES extends BlockCipher {
    static keySize: number;
    _nRounds: number;
    _key: WordArray;
    _keyPriorReset: WordArray;
    _keySchedule: Array<number>;
    _invKeySchedule: Array<number>;
    constructor(xformMode: number, key: WordArray, cfg?: BufferedBlockAlgorithmConfig);
    reset(): void;
    encryptBlock(M: Array<number>, offset: number): void;
    decryptBlock(M: Array<number>, offset: number): void;
    _doCryptBlock(M: Array<number>, offset: number, keySchedule: Array<number>, sub_mix_0: Array<number>, sub_mix_1: Array<number>, sub_mix_2: Array<number>, sub_mix_3: Array<number>, sbox: Array<number>): void;
}
