var mongoose = require('mongoose');
var Schema = mongoose.Schema;
var autoIncrement = require('mongoose-auto-increment');
var EmploiSchema = mongoose.Schema({
    intitule: {
        type: String,
        required: true
    },
    autresAppellations: {
        type: String,
        required: false
    },
    commentaire: {
        type: String,
        required: false
    },
    activites: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'activite'
        }
    ],
    responsabilites: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'responsabilite'
        }
    ],
    relationsTravail: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'relationTravail'
        }
    ],
    connaissances: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'connaissance'
        }
    ],
    finalites: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'finalite'
        }
    ],
    refAnalyseEmploi: {
        type: Schema.Types.Mixed,
        default: ''
    },
    cotation: {
        type: Number,
        required: true
    },
    classeEmploi: {
        type: Number,
        required: true
    },
    groupeEmploi: {
        type: String,
        required: true
    },
    isValidated: {
        type: String,
        enum: ['brouillon', 'en attente de validation', 'validé'],
        default: 'brouillon'
    },
    entiteID: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'entite'
    },
    directionID: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'direction'
    },
    serviceID: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'service'
    },
    userID: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'user'
    },
    userValidatorID: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'user'
    },
    clientID: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'client'
    },
    emploiActivated: {
        type: Boolean,
        default: true
    },
    id : {
        type: Number,
        required: true,
        index: true
    },
    seq: { type: mongoose.Schema.Types.ObjectId }
}, { timestamps: true });
EmploiSchema.plugin(autoIncrement.plugin, {
    model: 'emploi',
    field: 'seq',
    startAt: 9000,
    // incrementBy: 1
});
module.exports = mongoose.model('emploi', EmploiSchema, 'emploi');
