const express = require('express');
const jwt = require('jsonwebtoken');
const apiRoutes = express.Router();
const config = require('../config');
const user = require('../controllers/user');
const userAuth = require('../controllers/userAuth');
const activite = require('../controllers/activite');
const responsabilite = require('../controllers/responsabilite');
const relationTravail = require('../controllers/relationTravail');
const connaissancce = require('../controllers/connaissance');
const finalite = require('../controllers/finalite');
const client = require('../controllers/client');
const entite = require('../controllers/entite');
const direction = require('../controllers/direction');
const service = require('../controllers/service');
const notification = require('../controllers/notification');
const emploi = require('../controllers/emploi');
const matrice = require('../controllers/matrice');
const classesEmplois = require('../controllers/classesEmplois');
const actualite = require('../controllers/actualite');
const page = require('../controllers/page');


module.exports = function (app) {
    apiRoutes.use(function (req, res, next) {
        // //test DEV
        // userDetail = {
        //     "userRole": "admin",
        //     "userActivated": true,
        //     "userDeleted": false,
        //     "created_At": "2021-03-19T23:10:13.000Z",
        //     "_id": "60552f552c40304194154615",
        //     "firstName": "Mehdi",
        //     "lastName": "Enna-seh",
        //     "email": "mehdi86_88@hotmail.com",
        //     "userName": "mehdi86_88@hotmail.com",
        //     "password": "",
        //     "createdAt": "2021-03-19T23:10:13.261Z",
        //     "updatedAt": "2021-09-16T17:45:36.914Z",
        //     "__v": 0,
        //     "updated_At": "2021-09-16T17:45:36.000Z",
        //     "mobile": "mehdi86_88@hotmail.com",
        //     "userSubcriptionType": null,
        //     "userImage": "/settings/60552f552c40304194154615.png",
        //     "packID": "614a7417f11e370b5854cea1",
        //     "parentUserID": "60552f552c40304194154615"
        // };
        // var authToken = jwt.sign(userDetail, config.secret, {
        //     expiresIn: '24h'
        // });
        // // Test DEV NEW
        // var token = authToken;
        // var userDetail ={"userActivated":true,"userAutorisationValidation":null,"userRole":"superAdmin","userDeleted":false,"permissionServicesShow":["61a694b2bf0f104c5812f7ea","61a694ccbf0f104c5812f7f4","61a694efbf0f104c5812f7fe"],"permissionServicesValidate":[],"permissionServicesCreate":["61a694b2bf0f104c5812f7ea","61a694ccbf0f104c5812f7f4","61a694efbf0f104c5812f7fe"],"_id":"6171d34228da6a3cf84f7704","mobile":null,"firstName":"Elmehdi","lastName":"ENNA-SEH","email":"mehdi86_88@hotmail.com","userImage":"/settings/6171d34228da6a3cf84f7704-2021-12-21T10:06:18Z.jpeg","password":"","createdAt":"2021-10-21T20:53:22.031Z","updatedAt":"2022-01-08T21:13:56.490Z","__v":0};
        // var authToken = jwt.sign(userDetail, config.secret, {
        //     expiresIn: '24h'
        // });
        // var token = authToken;

        var token = req.body.token || req.query.token || req.headers.token;
        if (token) {
            jwt.verify(token, config.secret, function (err, decoded) {
                if (err) {
                    return res.json({
                        status: "err",
                        code: 403,
                        success: false,
                        message: 'Failed to authenticate token.',
                        data: null
                    });
                } else {
                    if (decoded._doc) {
                        req.user = decoded._doc;
                        next();
                    } else {
                        req.user = decoded;
                        next();
                    }
                }
            });
        } else {
            return res.status(403).send({
                status: "err",
                success: false,
                message: 'No token provided.',
                data: null
            });
        }
    });

    //disable control token if you want to test api from postman [just for DEV]
    app.use('/api', apiRoutes);


    // Activite API
    app.post('/api/createEditActivite', activite.createEditActivite);
    app.post('/api/getActivitesClient', activite.getActivitesClient);
    app.post('/api/deleteActiviteByID', activite.deleteActiviteByID);
    app.post('/api/importActivites', activite.importActivites);
    app.post('/api/getActivites', activite.getActivites);
    

    // Responsabilite API
    app.post('/api/createEditResponsabilite', responsabilite.createEditResponsabilite);
    app.post('/api/getResponsabilitesClient', responsabilite.getResponsabilitesClient);
    app.post('/api/deleteResponsabiliteByID', responsabilite.deleteResponsabiliteByID);
    app.post('/api/importResponsabilites', responsabilite.importResponsabilites);
    app.post('/api/getResponsabilites', responsabilite.getResponsabilites);
    
    

    // RelationTravail API
    app.post('/api/createEditRelationTravail', relationTravail.createEditRelationTravail);
    app.post('/api/getRelationTravailsClient', relationTravail.getRelationTravailsClient);
    app.post('/api/deleteRelationTravailByID', relationTravail.deleteRelationTravailByID);
    app.post('/api/importRelationTravails', relationTravail.importRelationTravails);
    app.post('/api/getRelationTravails', relationTravail.getRelationTravails);


    // Connaisance API
    app.post('/api/createEditConnaissance', connaissancce.createEditConnaissance);
    app.post('/api/getConnaissancesClient', connaissancce.getConnaissancesClient);
    app.post('/api/deleteConnaissanceByID', connaissancce.deleteConnaissanceByID);
    app.post('/api/importConnaissances', connaissancce.importConnaissances);
    app.post('/api/getConnaissances', connaissancce.getConnaissances);


    // Finalite API
    app.post('/api/createEditFinalite', finalite.createEditFinalite);
    app.post('/api/getFinalitesClient', finalite.getFinalitesClient);
    app.post('/api/deleteFinaliteByID', finalite.deleteFinaliteByID);
    app.post('/api/importFinalites', finalite.importFinalites);
    app.post('/api/getFinalites', finalite.getFinalites);

    // Client API
    app.post('/api/createEditClient', client.createEditClient);
    app.post('/api/getClients', client.getClients);
    app.post('/api/deleteClientByID', client.deleteClientByID);
    app.post('/api/activateMfaClient', client.activateMfaClient);
    app.post('/api/getClientByID', client.getClientByID);

    // Entite API
    app.post('/api/createEditEntite', entite.createEditEntite);
    app.post('/api/getEntitesClient', entite.getEntitesClient);
    app.post('/api/deleteEntiteByID', entite.deleteEntiteByID);
    app.post('/api/getEntitesClientUser', entite.getEntitesClientUser);
    app.post('/api/getEntitesClientV2', entite.getEntitesClientV2);
    app.post('/api/getEntitesClientPermissionValidation', entite.getEntitesClientPermissionValidation);
    app.post('/api/getEntitesClientPermissionConsultation', entite.getEntitesClientPermissionConsultation);
    app.post('/api/getEntitesClientPermissionGestion', entite.getEntitesClientPermissionGestion);
    app.post('/api/getEntitesClientUserFilterEmploi', entite.getEntitesClientUserFilterEmploi);
    app.post('/api/getEntites', entite.getEntites);
    
    

    // Direction API
    app.post('/api/createEditDirection', direction.createEditDirection);
    app.post('/api/getDirectionsEntite', direction.getDirectionsEntite);
    app.post('/api/deleteDirectionByID', direction.deleteDirectionByID);
    app.post('/api/getDirectionsEntiteUser', direction.getDirectionsEntiteUser);
    app.post('/api/getDirectionsClient', direction.getDirectionsClient);
    app.post('/api/getDirectionsEntiteUserFilterEmploi', direction.getDirectionsEntiteUserFilterEmploi);
    app.post('/api/getDirections', direction.getDirections);
    


    // Service API
    app.post('/api/createEditService', service.createEditService);
    app.post('/api/getServicesDirection', service.getServicesDirection);
    app.post('/api/deleteServiceByID', service.deleteServiceByID);
    app.post('/api/getServicesDirectionUser', service.getServicesDirectionUser);
    app.post('/api/getServicesClient', service.getServicesClient);
    app.post('/api/getServicesDirectionUserFilterEmploi', service.getServicesDirectionUserFilterEmploi);
    app.post('/api/getServices', service.getServices);
    
    

    // Notification API
    app.post('/api/createEditNotification', notification.createEditNotification);
    app.post('/api/getNotificationsUser', notification.getNotificationsUser);
    app.post('/api/setNotificationStatut', notification.setNotificationStatut);
    app.post('/api/setNotificationEtat', notification.setNotificationEtat);
    app.post('/api/setNotificationsEtatUser', notification.setNotificationsEtatUser);
    app.post('/api/setNotificationsStatutUser', notification.setNotificationsStatutUser);

    // Emploi API
    app.post('/api/createEditEmploi', emploi.createEditEmploi);
    app.post('/api/getEmploisClient', emploi.getEmploisClient);
    app.post('/api/deleteEmploiByID', emploi.deleteEmploiByID);
    app.post('/api/validateEmploiByID', emploi.validateEmploiByID);
    app.post('/api/getEmploisClientUser', emploi.getEmploisClientUser);
    app.post('/api/getEmploiByID', emploi.getEmploiByID);
    app.post('/api/soumettreEmploiByID', emploi.soumettreEmploiByID);
    app.post('/api/getEmplois', emploi.getEmplois);
    app.post('/api/getEmploisDashboard', emploi.getEmploisDashboard);
    app.post('/api/getEmploisDashboardUser', emploi.getEmploisDashboardUser);
    app.post('/api/importEmploi', emploi.importEmploi);

    // Matrice API
    app.post('/api/getMatrice', matrice.getMatrice);
    app.post('/api/createEditMatrice', matrice.createEditMatrice);

    // Classes emplois API
    app.post('/api/createClassesEmplois', classesEmplois.createClassesEmplois);
    app.post('/api/getclassesEmplois', classesEmplois.getclassesEmplois);
    app.post('/api/editSalairesMinimums', classesEmplois.editSalairesMinimums);
    app.post('/api/getclassesEmploisByCotation', classesEmplois.getclassesEmploisByCotation);
    app.post('/api/getEmploisByClassesEmploisAndGroupesEmplois', classesEmplois.getEmploisByClassesEmploisAndGroupesEmplois);
    app.post('/api/editSalairesMinimums', classesEmplois.editSalairesMinimums);

    // Actualite API
    app.post('/api/createEditActualite', actualite.createEditActualite);
    app.post('/api/getActualites', actualite.getActualites);
    app.post('/api/deleteActualiteByID', actualite.deleteActualiteByID);
    app.post('/api/activatedActualite', actualite.activatedActualite);
    app.post('/api/getActualitesDashboard', actualite.getActualitesDashboard);
    

    // Page API
    app.post('/api/createEditPage', page.createEditPage);
    app.post('/api/getPages', page.getPages);
    app.post('/api/deletePageByID', page.deletePageByID);
    app.post('/api/activatedPage', page.activatedPage);


    // Authentication API
    app.post('/userLogin', userAuth.login);
    app.post('/userRegister', userAuth.register);
    app.post('/sendPasswordEmail', userAuth.sendPasswordEmail);
    app.post('/resetPassword', userAuth.resetPassword);
    app.post('/resendCode', userAuth.resendCode);

    // User API
    app.post('/api/getUsers', user.getUsers);
    app.post('/api/getUserByID', user.getUserByID);
    app.post('/api/activatedUser', user.activatedUser);
    app.post('/api/deletedUser', user.deletedUser);
    app.post('/api/changePassword', user.changePassword);
    app.post('/api/changePasswordProfil', user.changePasswordProfil);
    app.post('/api/editRoleUser', user.editRoleUser);
    app.post('/api/editUserImage', user.editUserImage);
    app.post('/api/getUsersClient', user.getUsersClient);
    app.post('/api/editUser', user.editUser);
    app.post('/api/editUserProfil', user.editUserProfil);
    app.post('/api/getPermissionsUser', user.getPermissionsUser);
    app.post('/api/createUser', user.createUser);
    app.post('/api/editUserPermissions', user.editUserPermissions);
    


};