import { WordArray } from '../lib/WordArray';
export declare class NoPadding {
    /**
     * Doesn't pad the data provided.
     *
     * @param data The data to pad.
     * @param blockSize The multiple that the data should be padded to.
     *
     * @example
     *
     *     NoPadding.pad(wordArray, 4);
     */
    static pad(data: WordArray, blockSize: number): void;
    /**
     * Doesn't unpad the data provided.
     *
     * @param data The data to unpad.
     *
     * @example
     *
     *     NoPadding.unpad(wordArray);
     */
    static unpad(data: WordArray): void;
}
