// ********************************************************** activite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const activiteSchema = mongoose.model('activite');
const emploiSchema = mongoose.model('emploi');


// ********************************************************* activite API *********************************************** //


exports.createEditActivite = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        activiteSchema.findOne({
            _id: req.body.activiteID
        })
            .select({ _id: 1 })
            .exec((err, activiteInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!activiteInfo) {
                    activiteSchema.findOne({
                        labelActivite: receivedValues.labelActivite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, activite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!activite) {
                                let activiteData;
                                activiteData = {
                                    labelActivite: !receivedValues.labelActivite ? '' : receivedValues.labelActivite.trim(),
                                    activiteActivated: receivedValues.activiteActivated,
                                    clientID: receivedValues.clientID
                                };
                                activiteSchema.create(activiteData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'activité a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de l'activité.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de l'activité existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    activiteSchema.findOne({
                        labelActivite: receivedValues.labelActivite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, activite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (activite) {
                                var activiteJson = JSON.parse(JSON.stringify(activite));
                                var activiteInfoJson = JSON.parse(JSON.stringify(activiteInfo));
                                if (activiteJson._id == activiteInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let activiteData;
                                activiteData = {
                                    labelActivite: !receivedValues.labelActivite ? '' : receivedValues.labelActivite.trim(),
                                    activiteActivated: receivedValues.activiteActivated,
                                    clientID: receivedValues.clientID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                activiteSchema.findByIdAndUpdate(activiteInfo._id, activiteData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "L'activité a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de l'activité existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getActivitesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelActivite"] = { $regex: new RegExp('.*' + receivedValues.labelActivite.toLowerCase() + '.*', "i") };
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    match["activiteActivated"] = true;

    activiteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },

        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listActivitesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                activiteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .then((listActivites, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listActivites: listActivites,
                                    totalActivites: listActivitesTotal.length,
                                    totalPages: Math.ceil(listActivitesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getActivites = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelActivite"] = { $regex: new RegExp('.*' + receivedValues.labelActivite.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["activiteActivated"] = true;

    activiteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listActivitesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                activiteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])

                    .collation({ locale: "fr" })
                    .then((listActivites, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listActivites: listActivites,
                                    totalActivites: listActivitesTotal.length,
                                    totalPages: Math.ceil(listActivitesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteActiviteByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["activiteID", "clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'activiteID') && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        emploiSchema.find({
            clientID: receivedValues.clientID
        })
            .populate("activites")
            .then((emplois) => {
                if (emplois || emplois.length != 0) {

                    var emploiJson = JSON.parse(JSON.stringify(emplois));

                    for (var item of emploiJson) {
                        if (item.activites.filter(e => e._id === receivedValues.activiteID).length != 0) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Impossible de supprimer l'activité, des emplois sont liés à cette dernière.",
                            });
                            return;
                        }
                    }
                }
                activiteSchema.deleteOne({
                    _id: receivedValues.activiteID
                }).exec((err, activiteInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (activiteInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "L'activité a été supprimée avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });


            });
    }
};

exports.importActivites = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Invalid data enter",
            "dataDoublons": []
        });
    } else {
        var activites = [];
        var activitesDouble = [];
        for await (var item of receivedValues.data) {
            let activiteData;
            activiteData = {
                labelActivite: !item.labelActivite ? '' : item.labelActivite.trim(),
                activiteActivated: true,
                clientID: receivedValues.clientID
            };

            await activiteSchema.findOne({
                labelActivite: item.labelActivite,
                clientID: mongoose.Types.ObjectId(receivedValues.clientID)
            })
                .lean()
                .then((activite) => {
                    if (activite) {
                        activitesDouble.push(activiteData);
                    } else {
                        activites.push(activiteData);
                    }
                });
        }

        if (activitesDouble.length != 0) {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Merci de bien vouloir supprimer le(s) doublon(s) avant d'impoter la liste.",
                "dataDoublons": activitesDouble
            });
            return;
        } else {
            activiteSchema.insertMany(activites)
                .then(function (data) {
                    console.log(data);
                    res.json({
                        "code": 200,
                        "status": "Success",
                        "message": "Les activités ont été importées avec succès."
                    });
                })
                .catch(function (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message,
                        "dataDoublons": []
                    });
                    return;
                });
        }

    }
};


