import { BlockCipher } from '../lib/BlockCipher';
import { BlockCipherMode } from './BlockCipherMode';
export declare abstract class BlockCipherModeAlgorithm {
    _cipher: BlockCipher;
    _iv: Array<number> | undefined;
    __creator: ((cipher: BlockCipher, iv: number[]) => BlockCipherMode) | undefined;
    constructor(cipher: BlockCipher, iv: Array<number>);
    /**
     * Initializes a newly created mode.
     *
     * @param cipher A block cipher instance.
     * @param iv The IV words.
     *
     * @example
     *
     *     var mode = CBC.Encryptor.create(cipher, iv.words);
     */
    init(cipher: BlockCipher, iv?: Array<number>): void;
    abstract processBlock(words: Array<number>, offset: number): void;
}
