import { WordArray } from '../lib/WordArray';
import { Hasher } from '../lib/Hasher';
export interface OptionalEvpKDFConfig {
    keySize?: number;
    hasher?: typeof Hasher;
    iterations?: number;
}
export interface EvpKDFConfig extends OptionalEvpKDFConfig {
    keySize: number;
    hasher: typeof Hasher;
    iterations: number;
}
export declare class EvpKDF {
    cfg: EvpKDFConfig;
    /**
     * Initializes a newly created key derivation function.
     *
     * @param cfg (Optional) The configuration options to use for the derivation.
     *
     * @example
     *
     *     let kdf = EvpKDF.create();
     *     let kdf = EvpKDF.create({ keySize: 8 });
     *     let kdf = EvpKDF.create({ keySize: 8, iterations: 1000 });
     */
    constructor(cfg?: OptionalEvpKDFConfig);
    /**
     * Derives a key from a password.
     *
     * @param password The password.
     * @param salt A salt.
     *
     * @return The derived key.
     *
     * @example
     *
     *     let key = kdf.compute(password, salt);
     */
    compute(password: WordArray | string, salt: WordArray | string): WordArray;
}
