// ********************************************************** notification controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const notificationSchema = mongoose.model('notification');


// ********************************************************* notification API *********************************************** //


exports.createEditNotification = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        notificationSchema.findOne({
            _id: req.body.notificationID
        })
            .select({ _id: 1 })
            .exec((err, notificationInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!notificationInfo) {
                    let notificationData;
                    notificationData = {
                        messageNotification: !receivedValues.messageNotification ? '' : receivedValues.messageNotification.trim(),
                        lienNotification: receivedValues.lienNotification,
                        notificationStatut: receivedValues.notificationStatut,
                        notificationEtat: receivedValues.notificationEtat,
                        userID: receivedValues.userID,
                        emploiID: receivedValues.emploiID
                    };
                    notificationSchema.create(notificationData, (err, data) => {
                        if (!err) {
                            res.json({
                                "code": config.successCode,
                                "status": "Success",
                                "message": "La notification a été créée avec succès.",
                                data: data
                            });
                        } else {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Erreur lors de la création de la notification.",
                            });
                            return;
                        }
                    });
                } else {
                    let notificationData;
                    notificationData = {
                        messageNotification: !receivedValues.messageNotification ? '' : receivedValues.messageNotification.trim(),
                        lienNotification: receivedValues.lienNotification,
                        notificationStatut: receivedValues.notificationStatut,
                        notificationEtat: receivedValues.notificationEtat,
                        userID: receivedValues.userID,
                        emploiID: receivedValues.emploiID
                    };
                    let Option = {
                        new: true
                    };

                    notificationSchema.findByIdAndUpdate(notificationInfo._id, notificationData, Option, (err, updatedData) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "Success",
                                "message": "La notification a été modifiée avec succès.",
                                "data": updatedData
                            });
                        }
                    });
                }
            });
    }
};

exports.getNotificationsUser = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    notificationSchema.find({
        userID: receivedValues.userID,
        notificationEtat: false,
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalNotifications) => {
            if (!totalNotifications || totalNotifications === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune notification trouvée.",
                });
                return;
            } else {
                notificationSchema.find({
                    userID: receivedValues.userID,
                    notificationEtat: false,
                })
                    .populate("emploiID")
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listNotifications) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            notificationSchema.find({
                                userID: receivedValues.userID,
                                notificationStatut: false,
                            })
                            
                            .lean()
                            .countDocuments()
                            .then(counts => {
                                return counts;
                            }).then((totalNotifications2) => {
                                res.json({
                                    "code": config.successCode,
                                    "status": "success",
                                    "data": {
                                        listNotifications: listNotifications,
                                        totalNotifications: totalNotifications,
                                        totalNotifications2 : totalNotifications2,
                                        totalPages: Math.ceil(totalNotifications / req.body.limit)
                                    }
                                });
                            });
                            
                        }
                    });
            }
        })
};

exports.setNotificationStatut = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["notificationID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'notificationID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        notificationSchema.find({
            notificationID: req.body.notificationID
        })
            .lean()
            .exec((err, notification) => {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    if (notification) {

                        let fieldToSet;
                        fieldToSet = {
                            notificationStatut: receivedValues.notificationStatut
                        };
                        let Option = {
                            new: true
                        };
                        notificationSchema.findByIdAndUpdate(receivedValues.notificationID, fieldToSet, Option, (err, updatedData) => {
                            if (err) {
                                console.log(err);
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": config.errMessage,
                                });
                                return;
                            } else {
                                res.json({
                                    "code": config.successCode,
                                    "status": "Success",
                                    "message": "Le satatut de la notification a été modifié avec succès.",
                                    "data": updatedData
                                });
                            }
                        });


                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": "Aucune notification trouvée."
                        });
                    }
                }
            });
    }
};

exports.setNotificationEtat = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["notificationID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'notificationID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        notificationSchema.find({
            notificationID: req.body.notificationID
        })
            .lean()
            .exec((err, notification) => {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    if (notification) {

                        let fieldToSet;
                        fieldToSet = {
                            notificationEtat: receivedValues.notificationEtat
                        };
                        let Option = {
                            new: true
                        };
                        notificationSchema.findByIdAndUpdate(receivedValues.notificationID, fieldToSet, Option, (err, updatedData) => {
                            if (err) {
                                console.log(err);
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": config.errMessage,
                                });
                                return;
                            } else {
                                res.json({
                                    "code": config.successCode,
                                    "status": "Success",
                                    "message": "L'état de la notification a été modifié avec succès.",
                                    "data": updatedData
                                });
                            }
                        });


                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": "Aucune notification trouvée."
                        });
                    }
                }
            });
    }
};

exports.setNotificationsEtatUser = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["userID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'userID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        notificationSchema.updateMany(
            { userID: receivedValues.userID },
            { $set: { notificationEtat: true } },
            function (err, result) {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    res.json({
                        "code": config.successCode,
                        "status": "Success",
                        "message": "L'état de la notification a été modifié avec succès.",
                        "data": result
                    });
                }
            }
        );
    }
};

exports.setNotificationsStatutUser = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["userID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'userID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        notificationSchema.updateMany(
            { userID: receivedValues.userID },
            { $set: { notificationStatut: true } },
            function (err, result) {
                if (err) {
                    console.log(err);
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                } else {
                    res.json({
                        "code": config.successCode,
                        "status": "Success",
                        "message": "L'état de la notification a été modifié avec succès.",
                        "data": result
                    });
                }
            }
        );
    }
};


