import { WordArray } from '../lib/WordArray';
import { CipherParams } from '../lib/CipherParams';
export declare class OpenSSLKdf {
    /**
     * Derives a key and IV from a password.
     *
     * @param password The password to derive from.
     * @param keySize The size in words of the key to generate.
     * @param ivSize The size in words of the IV to generate.
     * @param salt (Optional) A 64-bit salt to use. If omitted, a salt will be generated randomly.
     *
     * @return A cipher params object with the key, IV, and salt.
     *
     * @example
     *
     *     let derivedParams = OpenSSL.execute('Password', 256/32, 128/32);
     *     let derivedParams = OpenSSL.execute('Password', 256/32, 128/32, 'saltsalt');
     */
    static execute(password: string, keySize: number, ivSize: number, salt?: WordArray | string): CipherParams;
}
