// ********************************************************** userAuth controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const async = require('async');
const _ = require('lodash');
const chalk = require('chalk');
const jwt = require('jsonwebtoken');
const CryptoTS = require("crypto-ts");
const userSchema = mongoose.model('user');
const sgMail = require('@sendgrid/mail');

// ********************************************************* User auth API *********************************************** //

exports.register = (req, res) => {
    // var receivedValues = req.body;
    // if (JSON.stringify(receivedValues) === '{}' || receivedValues === undefined || receivedValues === null) {
    //     res.json({
    //         "code": config.errCode,
    //         "status": "Error",
    //         "message": "Les données entrées ne sont pas valides."
    //     });
    //     return;
    // } else {
    //     userSchema.findOne({
    //         email: req.body.email
    //     })
    //         .select({ _id: 1 })
    //         .exec((err, user) => {
    //             if (err) {
    //                 res.json({
    //                     "code": config.errCode,
    //                     "status": "Error",
    //                     "message": err.message
    //                 });
    //                 return;
    //             }
    //             if (!user) {
    //                 let userInfo;
    //                 var userdata = new userSchema();
    //                 userInfo = {
    //                     mobile: receivedValues.mobile,
    //                     firstName: receivedValues.firstName,
    //                     lastName: receivedValues.lastName,
    //                     email: receivedValues.email,
    //                     userRole: receivedValues.userRole,
    //                     userActivated: true,
    //                     userImage: receivedValues.userImage,
    //                     userAutorisationValidation: receivedValues.userAutorisationValidation,
    //                     userDeleted: false,
    //                     clientID: receivedValues.clientID,
    //                     permissionServicesShow: receivedValues.permissionServicesShow,
    //                     permissionServicesValidate: receivedValues.permissionServicesValidate,
    //                     permissionServicescreate: receivedValues.permissionServicesCreate,
    //                     password: userdata.generateHash(passwordString),
    //                 };
    //                 userSchema.create(userInfo, (err, result) => {
    //                     if (!err) {
    //                         res.json({
    //                             "code": config.successCode,
    //                             "status": "L'utilisateur a été créé avec succès.",
    //                             data: result
    //                         });

    //                     } else {
    //                         res.json({
    //                             "code": config.errCode,
    //                             "status": "err",
    //                             "message": "Erreur lors de la création de l'utilisateur.",
    //                         });
    //                     }
    //                 });
    //             } else {
    //                 res.json({
    //                     "code": config.errCode,
    //                     "status": "Error",
    //                     "message": "L'adresse email est déjà utilisée."
    //                 });
    //             }
    //         });
    // }
};

function makeRandom(lengthOfCode, possible) {
    let text = "";
    for (let i = 0; i < lengthOfCode; i++) {
      text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
};
exports.login = (req, res) => {
    var receivedValues = req.body;
    if (
        JSON.stringify(receivedValues) === '{}' ||
        receivedValues === undefined ||
        receivedValues === null ||
        receivedValues.email === '' ||
        receivedValues.password === ''
    ) {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Tous les champs sont requis"
        });
        return;
    } else {
        const bytes = CryptoTS.AES.decrypt(req.body.password.toString(), config.secret);
        const plaintext = bytes.toString(CryptoTS.enc.Utf8);
        userSchema.findOne({
            email: receivedValues.email,
            userActivated: true,
            userDeleted: false
        }).populate("clientID").exec(async (err, userDetail) => {
            if (userDetail !== null) {
                if (userDetail.validPassword(plaintext)) {
                    if(userDetail.clientID != undefined && userDetail.userRole != "superAdmin")
                    {
                        if(userDetail.clientID.mfaActivated)
                        {
                            if(receivedValues.codeSecurite == undefined)
                            {
                                const emailString = userDetail.email;
                                const possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                                const lengthOfCode = 5;
                                var code = makeRandom(lengthOfCode, possible);
                                let dateNow = new Date();
                                dateNow.setMinutes(dateNow.getMinutes() + 15);
                                let fieldToSet;
                                fieldToSet = {
                                    userCodeSecurite : code,
                                    userDateExpiredCodeSecurite : dateNow
                                };
                                let Option = {
                                    new: true,
                                };
                                await userSchema.findByIdAndUpdate(
                                    userDetail._id,
                                    fieldToSet,
                                    Option,
                                    (err, updatedData) => {
                                      if (err) {
                                        console.log(err);
                                        res.json({
                                          code: config.errCode,
                                          status: "Error",
                                          message: config.errMessage,
                                        });
                                        return;
                                      }
                                    }
                                  );
                                
                                var html =   `<html>
    
                                <body style="width: 100% !important;background-color: #F8F8F8;">
                                    <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                                        style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                                        <center>
                                            <div class="justify-content-center d-flex">
                                                <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                                    style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                                    heigth="auto">
                                                    <tbody>
                                                        <tr>
                                                            <td align="center" valign="center"
                                                                style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                <img style="width: 100px;"
                                                                    src="https://app.metalclass.com/assets/logos/classif.png" />
                                                            </td>
                                                            <td align="right" valign="center"
                                                                style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                                <!-- <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">02.01.2022</span> -->
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                                                <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                                    Bonjour et bienvenue,</h3>
                                                                <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                                                    Nous avons reçu une demande de connexion à l'application METALCLASS. <br>
                                                                    Merci de renseigner le code de sécurité
                                                                    suivant :
                                                                </p>
                                                                <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">Code
                                                                    de sécurité</h3>
                                                                <p
                                                                    style="background-color:#f1f1f1; padding: 8px 15px; border-radius: 50px; display: inline-block; margin-bottom:20px; font-size: 14px;  line-height: 1.4; font-family: Courier New, Courier, monospace; margin-top:0">
                                                                    ` + code + `</p>
                            
                                                            </td>
                                                        </tr>
                            
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="justify-content-center d-flex">
                                                <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                                    <tbody>
                                                        <tr>
                                                            <td align="center" valign="center">
                                                                <p
                                                                    style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                                                    Une question ? Un problème ? Contacter le support : <a
                                                                        href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                                                </p>
                                                                <p
                                                                    style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                                                    <a target="_blank" href="www.metalclass.com"
                                                                        style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a>
                                                                </p>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </center>
                                    </div>
                                </body>
                            
                                </html>`;
                                var sendgrid = sgMail.setApiKey(
                                    config.sendGridApiKey
                                );
                                sendgrid.send({
                                    to: emailString,
                                    from: config.mailFrom,
                                    subject: 'METALCLASS : Votre code de sécurité pour se connecter à l\'application',
                                    html: html
                                }, function (err, result2) {
                                    if (err) {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Votre e-mail est erroné."
                                        });
    
                                    } else {
                                        res.json({
                                            "code": 401,
                                            "status": "Information",
                                            "message": "Merci de renseigner le code de sécurité que vous avez reçu par mail."
                                        });
                                    }
                                });
                            }else{
                                let dateNow = new Date();
                                if(userDetail.userCodeSecurite == receivedValues.codeSecurite 
                                    && userDetail.userDateExpiredCodeSecurite >= dateNow)
                                {
                                    var authToken = jwt.sign(userDetail.toJSON(), config.secret, {
                                        expiresIn: '8h'
                                    });
                                    userDetail.password = "";
                                    userDetail.clientID = userDetail.clientID._id;
                                    res.json({
                                        "code": config.successCode,
                                        "authToken": authToken,
                                        "data": userDetail,
                                        "status": "success"
                                    }); 
                                }else{
                                    if(userDetail.userCodeSecurite != receivedValues.codeSecurite){
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Votre code de sécurité est erroné."
                                        });
                                        return;
                                    }
                                    if(userDetail.userDateExpiredCodeSecurite < dateNow)
                                    {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Votre code de sécurité a expiré."
                                        });
                                        return;    
                                    }
                                    res.json({
                                        "code": config.errCode,
                                        "status": "Error",
                                        "message": "Problème interne lors de la connexion à votre compte."
                                    });
                                    return; 
                                }
                            }
                        }
                        else{
                            var authToken = jwt.sign(userDetail.toJSON(), config.secret, {
                                expiresIn: '8h'
                            });
                            userDetail.password = "";
                            userDetail.clientID = userDetail.clientID._id;
                            res.json({
                                "code": config.successCode,
                                "authToken": authToken,
                                "data": userDetail,
                                "status": "success"
                            });
                            return;
                        }
                       
                    }else{
                        var authToken = jwt.sign(userDetail.toJSON(), config.secret, {
                            expiresIn: '8h'
                        });
                        userDetail.password = "";
                        if(userDetail.clientID != undefined)
                        {
                            userDetail.clientID = userDetail.clientID._id;
                        }
                        res.json({
                            "code": config.successCode,
                            "authToken": authToken,
                            "data": userDetail,
                            "status": "success"
                        });
                        return;
                    }
                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Votre mot de passe est erroné."
                    });
                    return;
                }
            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Votre nom d'utilisateur est erroné."
                });
                return;
            }
        });
    }
};

exports.resendCode = (req, res) => {
    var receivedValues = req.body;
    if (
        JSON.stringify(receivedValues) === '{}' ||
        receivedValues === undefined ||
        receivedValues === null ||
        receivedValues.email === '' ||
        receivedValues.password === ''
    ) {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Tous les champs sont requis"
        });
        return;
    } else {
        const bytes = CryptoTS.AES.decrypt(req.body.password.toString(), config.secret);
        const plaintext = bytes.toString(CryptoTS.enc.Utf8);
        userSchema.findOne({
            email: receivedValues.email,
            userActivated: true,
            userDeleted: false
        }).populate("clientID").exec(async (err, userDetail) => {
            if (userDetail !== null) {
                if (userDetail.validPassword(plaintext)) {
                    const emailString = userDetail.email;
                    const possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                    const lengthOfCode = 5;
                    var code = makeRandom(lengthOfCode, possible);
                    let dateNow = new Date();
                    dateNow.setMinutes(dateNow.getMinutes() + 15);
                    let fieldToSet;
                    fieldToSet = {
                        userCodeSecurite : code,
                        userDateExpiredCodeSecurite : dateNow
                    };
                    let Option = {
                        new: true,
                    };
                    await userSchema.findByIdAndUpdate(
                        userDetail._id,
                        fieldToSet,
                        Option,
                        (err, updatedData) => {
                            if (err) {
                            console.log(err);
                            res.json({
                                code: config.errCode,
                                status: "Error",
                                message: config.errMessage,
                            });
                            return;
                            }
                        }
                        );
                    
                    var html =   `<html>

                    <body style="width: 100% !important;background-color: #F8F8F8;">
                        <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                            style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                            <center>
                                <div class="justify-content-center d-flex">
                                    <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                        style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                        heigth="auto">
                                        <tbody>
                                            <tr>
                                                <td align="center" valign="center"
                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                    <img style="width: 100px;"
                                                        src="https://app.metalclass.com/assets/logos/classif.png" />
                                                </td>
                                                <td align="right" valign="center"
                                                    style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                    <!-- <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">02.01.2022</span> -->
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                                    <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                        Bonjour et bienvenue,</h3>
                                                    <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                                        Nous avons reçu une demande de connexion à l'application METALCLASS. <br>
                                                        Merci de renseigner le code de sécurité
                                                        suivant :
                                                    </p>
                                                    <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">Code
                                                        de sécurité</h3>
                                                    <p
                                                        style="background-color:#f1f1f1; padding: 8px 15px; border-radius: 50px; display: inline-block; margin-bottom:20px; font-size: 14px;  line-height: 1.4; font-family: Courier New, Courier, monospace; margin-top:0">
                                                        ` + code + `</p>
                
                                                </td>
                                            </tr>
                
                                        </tbody>
                                    </table>
                                </div>
                                <div class="justify-content-center d-flex">
                                    <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                        <tbody>
                                            <tr>
                                                <td align="center" valign="center">
                                                    <p
                                                        style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                                        Une question ? Un problème ? Contacter le support : <a
                                                            href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                                    </p>
                                                    <p
                                                        style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                                        <a target="_blank" href="www.metalclass.com"
                                                            style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a>
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </center>
                        </div>
                    </body>
                
                    </html>`;
                    var sendgrid = sgMail.setApiKey(
                        config.sendGridApiKey
                    );
                    sendgrid.send({
                        to: emailString,
                        from: config.mailFrom,
                        subject: 'METALCLASS : Votre code de sécurité pour se connecter à l\'application',
                        html: html
                    }, function (err, result2) {
                        if (err) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Votre e-mail est erroné."
                            });

                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "Information",
                                "message": "Un nouveau code de sécurité a bien été envoyé, merci de renseigner le nouveau code de sécurité que vous avez reçu par mail."
                            });
                        }
                    });    
                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Votre mot de passe est erroné."
                    });
                    return;
                }
            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Votre nom d'utilisateur est erroné."
                });
                return;
            }
        });
    }
};

exports.sendPasswordEmail = (req, res) => {
    var receivedValues = req.body;
    if (
        JSON.stringify(receivedValues) === '{}' ||
        receivedValues === undefined ||
        receivedValues === null ||
        receivedValues.email === '' || receivedValues.code === ''
    ) {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "L'e-mail est requis"
        });
        return;
    } else {
        const emailBytes = CryptoTS.AES.decrypt(receivedValues.email.toString(), config.secret);
        const emailString = emailBytes.toString(CryptoTS.enc.Utf8);
        const codeBytes = CryptoTS.AES.decrypt(receivedValues.code.toString(), config.secret);
        const codeString = codeBytes.toString(CryptoTS.enc.Utf8);
        userSchema.findOne({
            email: emailString,
        }, (err, userDetail) => {
            if (userDetail !== null) {
                var code = codeString;
                var html =   `<html>

                <body style="width: 100% !important;background-color: #F8F8F8;">
                    <div leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0"
                        style="height:auto !important;width:100% !important; font-family: Helvetica,Arial,sans-serif !important; margin-bottom: 40px;">
                        <center>
                            <div class="justify-content-center d-flex">
                                <table bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0"
                                    style="max-width:600px; background-color:#ffffff;border:1px solid #e4e2e2;border-collapse:separate !important; border-radius:10px;border-spacing:0;color:#242128; margin:0;padding:40px;"
                                    heigth="auto">
                                    <tbody>
                                        <tr>
                                            <td align="center" valign="center"
                                                style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                <img style="width: 100px;"
                                                    src="https://app.metalclass.com/assets/logos/classif.png" />
                                            </td>
                                            <td align="right" valign="center"
                                                style="padding-bottom:40px;border-top:0;height:100% !important;width:100% !important;">
                                                <!-- <span style="color: #8f8f8f; font-weight: normal; line-height: 2; font-size: 14px;">02.01.2022</span> -->
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colSpan="2" style="padding-top:10px;border-top:1px solid #e4e2e2">
                                                <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">
                                                    Bonjour et bienvenue,</h3>
                                                <p style="color:#8f8f8f; font-size: 14px; padding-bottom: 20px; line-height: 1.4;">
                                                    Nous avons reçu une demande de réinitialisation de votre mot de passe. <br>
                                                    Nous vous remercions de renseigner dans METALCLASS, le code de réinitialisation
                                                    suivant :
                                                </p>
                                                <h3 style="color:#303030; font-size:18px; line-height: 1.6; font-weight:500;">Code
                                                    de réinitialisation</h3>
                                                <p
                                                    style="background-color:#f1f1f1; padding: 8px 15px; border-radius: 50px; display: inline-block; margin-bottom:20px; font-size: 14px;  line-height: 1.4; font-family: Courier New, Courier, monospace; margin-top:0">
                                                    ` + code + `</p>
            
                                            </td>
                                        </tr>
            
                                    </tbody>
                                </table>
                            </div>
                            <div class="justify-content-center d-flex">
                                <table style="margin-top:30px; padding-bottom:20px;; margin-bottom: 40px;">
                                    <tbody>
                                        <tr>
                                            <td align="center" valign="center">
                                                <p
                                                    style="font-size: 12px; text-decoration: none;line-height: 1; color:#909090; margin-top:0px; margin-bottom:5px; ">
                                                    Une question ? Un problème ? Contacter le support : <a
                                                        href="mailto:hello@www.metalclass.com">contact@metalclass.com</a>
                                                </p>
                                                <p
                                                    style="font-size: 12px; line-height:1; color:#909090;  margin-top:5px; margin-bottom:5px;">
                                                    <a target="_blank" href="www.metalclass.com"
                                                        style="color: #C45824; text-decoration:none;"> &#169; METALCLASS</a>
                                                </p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </center>
                    </div>
                </body>
            
                </html>`;
                var sendgrid = sgMail.setApiKey(
                    config.sendGridApiKey
                  );
                sendgrid.send({
                    to: emailString,
                    from: config.mailFrom,
                    subject: 'METALCLASS : Réinitialisation du mot de passe',
                    html: html
                }, function (err, result2) {
                    if (err) {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": "Votre e-mail est erroné."
                        });

                    } else {
                        res.json({
                            "code": config.successCode,
                            "data": userDetail,
                            "status": "success"
                        });
                    }
                });
            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Votre e-mail est erroné."
                });
            }
        });
    }
};

exports.resetPassword = (req, res) => {
    var receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}' || receivedValues === undefined || receivedValues === null) {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Entrée de données invalide"
        });
        return;
    } else {
        const emailBytes = CryptoTS.AES.decrypt(receivedValues.email.toString(), config.secret);
        const emailString = emailBytes.toString(CryptoTS.enc.Utf8);
        userSchema.findOne({
            email: emailString
        })
            .select({})
            .exec((err, user) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message
                    });
                    return;
                }
                if (user) {
                    const newPasswordBytes = CryptoTS.AES.decrypt(receivedValues.newPassword.toString(), config.secret);
                    const newPasswordString = newPasswordBytes.toString(CryptoTS.enc.Utf8);
                    let fieldToSet;
                    var userdata = new userSchema();
                    fieldToSet = {
                        password: userdata.generateHash(newPasswordString),
                    };
                    let Option = {
                        new: true
                    };
                    userSchema.findByIdAndUpdate(user._id, fieldToSet, Option, (err, updatedData) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "Success",
                                "message": "Mot de passe utilisateur mis à jour avec succès",
                                "data": updatedData
                            });
                        }
                    });


                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Nom d'utilisateur introuvable"
                    });
                }
            });
    }
};
