// ********************************************************** service controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const serviceSchema = mongoose.model('service');
const userSchema = mongoose.model('user');
const emploiSchema = mongoose.model('emploi');



// ********************************************************* service API *********************************************** //


exports.createEditService = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        serviceSchema.findOne({
            _id: req.body.serviceID
        })
            .select({ _id: 1 })
            .exec((err, serviceInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!serviceInfo) {
                    serviceSchema.findOne({
                        labelService: receivedValues.labelService.trim(),
                        directionID: receivedValues.directionID
                    }).select({ _id: 1 })
                        .exec((err, service) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!service) {
                                let serviceData;
                                serviceData = {
                                    labelService: !receivedValues.labelService ? '' : receivedValues.labelService.trim(),
                                    serviceActivated: receivedValues.serviceActivated,
                                    directionID: receivedValues.directionID
                                };
                                serviceSchema.create(serviceData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le service a été créé avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création du service.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom du service existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    serviceSchema.findOne({
                        labelService: receivedValues.labelService.trim(),
                        directionID: receivedValues.directionID
                    }).select({ _id: 1 })
                        .exec((err, service) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (service) {
                                var serviceJson = JSON.parse(JSON.stringify(service));
                                var serviceInfoJson = JSON.parse(JSON.stringify(serviceInfo));
                                if (serviceJson._id == serviceInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let serviceData;
                                serviceData = {
                                    labelService: !receivedValues.labelService ? '' : receivedValues.labelService.trim(),
                                    serviceActivated: receivedValues.serviceActivated,
                                    directionID: receivedValues.directionID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                serviceSchema.findByIdAndUpdate(serviceInfo._id, serviceData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le service a été modifié avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom du service existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getServicesDirection = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    serviceSchema.find({
        labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
        directionID: receivedValues.directionID,
        serviceActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalServices) => {
            if (!totalServices || totalServices === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune service trouvé.",
                });
                return;
            } else {
                serviceSchema.find({
                    labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                    directionID: receivedValues.directionID,
                    serviceActivated: true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listServices) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listServices: listServices,
                                    totalServices: totalServices,
                                    totalPages: Math.ceil(totalServices / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteServiceByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["serviceID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'serviceID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }

        emploiSchema.find({
            serviceID: req.body.serviceID    
        })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalemploi) => {
            if (!totalemploi || totalemploi === 0) {
                 // delete service 
                 serviceSchema.deleteOne({
                    _id: req.body.serviceID
                }).exec((err, serviceInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (serviceInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "Le service a été supprimé avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Impossible de supprimer le service, des emplois sont liés à ce dernier.",
                });
                return;    
            }
        });
    }
};

exports.getServicesDirectionUser = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));
                serviceSchema.find({
                    labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                    directionID: receivedValues.directionID,
                    serviceActivated: true,
                    _id: { $in: userJSON.permissionServicesCreate }
                })
                    .lean()
                    .countDocuments()
                    .then(counts => {
                        return counts;
                    }).then((totalServices) => {
                        if (!totalServices || totalServices === 0) {
                            res.json({
                                "code": config.successCode,
                                "status": "Error",
                                "message": "Aucune service trouvé.",
                            });
                            return;
                        } else {
                            serviceSchema.find({
                                labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                                directionID: receivedValues.directionID,
                                serviceActivated: true,
                                _id: { $in: userJSON.permissionServicesCreate }
                            })
                                .sort({ [req.body.sortBy]: req.body.orderBy })
                                .skip(offset)
                                .limit(req.body.limit)
                                .select({ __v: 0 })
                                .lean()
                                .exec((err, listServices) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "success",
                                            "data": {
                                                listServices: listServices,
                                                totalServices: totalServices,
                                                totalPages: Math.ceil(totalServices / req.body.limit)
                                            }
                                        });
                                    }
                                });
                        }
                    });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });


};

exports.getServicesDirectionUserFilterEmploi = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));
                serviceSchema.find({
                    labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                    directionID: receivedValues.directionID,
                    serviceActivated: true,
                    _id: { $in: userJSON.permissionServicesShow }
                })
                    .lean()
                    .countDocuments()
                    .then(counts => {
                        return counts;
                    }).then((totalServices) => {
                        if (!totalServices || totalServices === 0) {
                            res.json({
                                "code": config.successCode,
                                "status": "Error",
                                "message": "Aucune service trouvé.",
                            });
                            return;
                        } else {
                            serviceSchema.find({
                                labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                                directionID: receivedValues.directionID,
                                serviceActivated: true,
                                _id: { $in: userJSON.permissionServicesShow }
                            })
                                .sort({ [req.body.sortBy]: req.body.orderBy })
                                .skip(offset)
                                .limit(req.body.limit)
                                .select({ __v: 0 })
                                .lean()
                                .exec((err, listServices) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "success",
                                            "data": {
                                                listServices: listServices,
                                                totalServices: totalServices,
                                                totalPages: Math.ceil(totalServices / req.body.limit)
                                            }
                                        });
                                    }
                                });
                        }
                    });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });


};

exports.getServicesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    serviceSchema.aggregate([
        {
            $lookup:
            {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID"
            }
        },
        {
            $lookup:
            {
                from: "entite",
                localField: "directionID.entiteID",
                foreignField: "_id",
                as: "entiteID"
            }
        },
        {
            $lookup:
            {
                from: "client",
                localField: "entiteID.clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$directionID' },
        { $unwind: '$entiteID' },
        { $unwind: '$clientID' },
        {
            '$match': {
                'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                serviceActivated: true,
            }
        }
    ]).then((services) => {
            if (!services || services.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune service trouvé.",
                });
                return;
            } else {
                serviceSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "direction",
                            localField: "directionID",
                            foreignField: "_id",
                            as: "directionID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "entite",
                            localField: "directionID.entiteID",
                            foreignField: "_id",
                            as: "entiteID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "entiteID.clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$directionID' },
                    { $unwind: '$entiteID' },
                    { $unwind: '$clientID' },
                    {
                        '$match': {
                            'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                            labelService: { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") },
                            serviceActivated: true,
                        }
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listServices) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listServices: listServices,
                                    totalServices: services.length,
                                    totalPages: Math.ceil(services.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })

};

exports.getServices = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};
    match["labelService"] = { $regex: new RegExp('.*' + receivedValues.labelService.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["serviceActivated"] =true;

    serviceSchema.aggregate([
        {
            $lookup:
            {
                from: "direction",
                localField: "directionID",
                foreignField: "_id",
                as: "directionID"
            }
        },
        {
            $lookup:
            {
                from: "entite",
                localField: "directionID.entiteID",
                foreignField: "_id",
                as: "entiteID"
            }
        },
        {
            $lookup:
            {
                from: "client",
                localField: "entiteID.clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$directionID' },
        { $unwind: '$entiteID' },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ]).then((services) => {
            if (!services || services.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune service trouvé.",
                });
                return;
            } else {
                serviceSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "direction",
                            localField: "directionID",
                            foreignField: "_id",
                            as: "directionID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "entite",
                            localField: "directionID.entiteID",
                            foreignField: "_id",
                            as: "entiteID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "entiteID.clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$directionID' },
                    { $unwind: '$entiteID' },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listServices) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listServices: listServices,
                                    totalServices: services.length,
                                    totalPages: Math.ceil(services.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};