// ********************************************************** finalite controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const finaliteSchema = mongoose.model('finalite');
const emploiSchema = mongoose.model('emploi');


// ********************************************************* finalite API *********************************************** //


exports.createEditFinalite = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        finaliteSchema.findOne({
            _id: req.body.finaliteID
        })
            .select({ _id: 1 })
            .exec((err, finaliteInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!finaliteInfo) {
                    finaliteSchema.findOne({
                        labelFinalite: receivedValues.labelFinalite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, finalite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!finalite) {
                                let finaliteData;
                                finaliteData = {
                                    labelFinalite: !receivedValues.labelFinalite ? '' : receivedValues.labelFinalite.trim(),
                                    finaliteActivated: receivedValues.finaliteActivated,
                                    clientID: receivedValues.clientID
                                };
                                finaliteSchema.create(finaliteData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La finalité a été créée avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création de la finalité.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la finalité existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    finaliteSchema.findOne({
                        labelFinalite: receivedValues.labelFinalite.trim(),
                        clientID: receivedValues.clientID
                    }).select({ _id: 1 })
                        .exec((err, finalite) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (finalite) {
                                var finaliteJson = JSON.parse(JSON.stringify(finalite));
                                var finaliteInfoJson = JSON.parse(JSON.stringify(finaliteInfo));
                                if (finaliteJson._id == finaliteInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let finaliteData;
                                finaliteData = {
                                    labelFinalite: !receivedValues.labelFinalite ? '' : receivedValues.labelFinalite.trim(),
                                    finaliteActivated: receivedValues.finaliteActivated,
                                    clientID: receivedValues.clientID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                finaliteSchema.findByIdAndUpdate(finaliteInfo._id, finaliteData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "La finalité a été modifiée avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le contenu de la finalité existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getFinalitesClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelFinalite"] = { $regex: new RegExp('.*' + receivedValues.labelFinalite.toLowerCase() + '.*', "i") };
    match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    match["finaliteActivated"] = true;

    finaliteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },

        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listFinalitesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                finaliteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .then((listFinalites, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listFinalites: listFinalites,
                                    totalFinalites: listFinalitesTotal.length,
                                    totalPages: Math.ceil(listFinalitesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getFinalites = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};

    match["labelFinalite"] = { $regex: new RegExp('.*' + receivedValues.labelFinalite.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["finaliteActivated"] = true;

    finaliteSchema.aggregate([
        {
            $lookup:
            {
                from: "client",
                localField: "clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .collation({ locale: "fr" })
        .then((listFinalitesTotal, err) => {
            if (err) {
                console.log(err);
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": config.errMessage,
                });
                return;
            } else {
                finaliteSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])

                    .collation({ locale: "fr" })
                    .then((listFinalites, err) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listFinalites: listFinalites,
                                    totalFinalites: listFinalitesTotal.length,
                                    totalPages: Math.ceil(listFinalitesTotal.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteFinaliteByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["finaliteID", "clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'finaliteID') && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        emploiSchema.find({
            clientID: receivedValues.clientID
        })
            .populate("finalites")
            .then((emplois) => {
                if (emplois || emplois.length != 0) {

                    var emploiJson = JSON.parse(JSON.stringify(emplois));

                    for (var item of emploiJson) {
                        if (item.finalites.filter(e => e._id === receivedValues.finaliteID).length != 0) {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": "Impossible de supprimer la finalité, des emplois sont liés à cette dernière.",
                            });
                            return;
                        }
                    }
                }
                finaliteSchema.deleteOne({
                    _id: receivedValues.finaliteID
                }).exec((err, finaliteInfo) => {
                    if (err) {
                        console.log(err);
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                        return;
                    }
                    if (finaliteInfo.deletedCount === 1) {
                        res.json({
                            "code": config.successCode,
                            "status": "success",
                            "message": "La finalité a été supprimée avec succès."
                        });
                    } else {
                        res.json({
                            "code": config.errCode,
                            "status": "Error",
                            "message": config.errMessage,
                        });
                    }
                });


            });
    }
};

exports.importFinalites = async (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Invalid data enter",
            "dataDoublons": []
        });
    } else {
        var finalites = [];
        var finalitesDouble = [];
        for await (var item of receivedValues.data) {
            let finaliteData;
            finaliteData = {
                labelFinalite: !item.labelFinalite ? '' : item.labelFinalite.trim(),
                finaliteActivated: true,
                clientID: receivedValues.clientID
            };

            await finaliteSchema.findOne({
                labelFinalite: item.labelFinalite,
                clientID: mongoose.Types.ObjectId(receivedValues.clientID)
            })
                .lean()
                .then((finalite) => {
                    if (finalite) {
                        finalitesDouble.push(finaliteData);
                    } else {
                        finalites.push(finaliteData);
                    }
                });
        }

        if (finalitesDouble.length != 0) {
            res.json({
                "code": config.errCode,
                "status": "Error",
                "message": "Merci de bien vouloir supprimer le(s) doublon(s) avant d'impoter la liste.",
                "dataDoublons": finalitesDouble
            });
            return;
        } else {
            finaliteSchema.insertMany(finalites)
                .then(function (data) {
                    console.log(data);
                    res.json({
                        "code": 200,
                        "status": "Success",
                        "message": "Les finalités ont été importées avec succès."
                    });
                })
                .catch(function (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": err.message,
                        "dataDoublons": []
                    });
                    return;
                });
        }

    }
};


