// ********************************************************** client controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const clientSchema = mongoose.model('client');
const userSchema = mongoose.model('user');
const entiteSchema = mongoose.model('entite');
const activiteSchema = mongoose.model('activite');
const relationTravailSchema = mongoose.model('relationTravail');
const responsabiliteSchema = mongoose.model('responsabilite');


// ********************************************************* client API *********************************************** //
function getRandomInt(min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min)) + min;
}

exports.createEditClient = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        clientSchema.findOne({
            _id: req.body.clientID
        })
            .select({ _id: 1 })
            .exec((err, clientInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!clientInfo) {
                    clientSchema.findOne({
                        labelClient: receivedValues.labelClient.trim()
                    }).select({ _id: 1 })
                        .exec((err, client) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!client) {
                                var count = getRandomInt(101, 10000);
                                let clientData;
                                clientData = {
                                    labelClient: !receivedValues.labelClient ? '' : receivedValues.labelClient.trim(),
                                    acronymeClient: !receivedValues.labelClient ? '' : receivedValues.labelClient.trim().substr(0, 3).toUpperCase(),
                                    counterClient: count,
                                    clientActivated: receivedValues.clientActivated,
                                    mfaActivated : receivedValues.mfaActivated
                                };
                                clientSchema.create(clientData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le client a été créé avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création du client.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom du client existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    clientSchema.findOne({
                        labelClient: receivedValues.labelClient.trim()
                    }).select({ _id: 1 })
                        .exec((err, client) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }

                            var update = false;
                            if (client) {
                                var clientJson = JSON.parse(JSON.stringify(client));
                                var clientInfoJson = JSON.parse(JSON.stringify(clientInfo));
                                if (clientJson._id == clientInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }

                            if (update) {
                                let clientData;
                                clientData = {
                                    labelClient: !receivedValues.labelClient ? '' : receivedValues.labelClient.trim(),
                                    acronymeClient: !receivedValues.labelClient ? '' : receivedValues.labelClient.trim().substr(0, 3).toUpperCase(),
                                    clientActivated: receivedValues.clientActivated,
                                    updatedAt: config.utcDefault(),
                                    mfaActivated : receivedValues.mfaActivated
                                };
                                let Option = {
                                    new: true
                                };

                                clientSchema.findByIdAndUpdate(clientInfo._id, clientData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le client a été modifié avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom du client existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getClients = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    clientSchema.find({
        labelClient: { $regex: new RegExp('.*' + receivedValues.labelClient.toLowerCase() + '.*', "i") },
        clientActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalClients) => {
            if (!totalClients || totalClients === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucun client trouvée.",
                });
                return;
            } else {
                clientSchema.find({
                    labelClient: { $regex: new RegExp('.*' + receivedValues.labelClient.toLowerCase() + '.*', "i") },
                    clientActivated: true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listClients) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listClients: listClients,
                                    totalClients: totalClients,
                                    totalPages: Math.ceil(totalClients / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteClientByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["clientID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'clientID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }
        entiteSchema.find({
            clientID: req.body.clientID
        })
            .lean()
            .countDocuments()
            .then(counts => {
                return counts;
            }).then((totalEntite) => {
                if (!totalEntite || totalEntite === 0) {

                    userSchema.find({
                        clientID: req.body.clientID
                    })
                        .lean()
                        .countDocuments()
                        .then(counts => {
                            return counts;
                        }).then((totalUsers) => {
                            if (!totalUsers || totalUsers === 0) {

                                activiteSchema.find({
                                    clientID: req.body.clientID
                                })
                                    .lean()
                                    .countDocuments()
                                    .then(counts => {
                                        return counts;
                                    }).then((totalActivites) => {
                                        if (!totalActivites || totalActivites === 0) {

                                            relationTravailSchema.find({
                                                clientID: req.body.clientID
                                            })
                                                .lean()
                                                .countDocuments()
                                                .then(counts => {
                                                    return counts;
                                                }).then((totalRelationTravail) => {
                                                    if (!totalRelationTravail || totalRelationTravail === 0) {

                                                        responsabiliteSchema.find({
                                                            clientID: req.body.clientID
                                                        })
                                                            .lean()
                                                            .countDocuments()
                                                            .then(counts => {
                                                                return counts;
                                                            }).then((totalResponsabilites) => {
                                                                if (!totalResponsabilites || totalResponsabilites === 0) {

                                                                    //delete client
                                                                    clientSchema.deleteOne({
                                                                        _id: req.body.clientID
                                                                    }).exec((err, clientInfo) => {
                                                                        if (err) {
                                                                            console.log(err);
                                                                            res.json({
                                                                                "code": config.errCode,
                                                                                "status": "Error",
                                                                                "message": config.errMessage,
                                                                            });
                                                                            return;
                                                                        }
                                                                        if (clientInfo.deletedCount === 1) {
                                                                            res.json({
                                                                                "code": config.successCode,
                                                                                "status": "success",
                                                                                "message": "Le client a été supprimé avec succès."
                                                                            });
                                                                        } else {
                                                                            res.json({
                                                                                "code": config.errCode,
                                                                                "status": "Error",
                                                                                "message": config.errMessage,
                                                                            });
                                                                        }
                                                                    });

                                                                } else {
                                                                    res.json({
                                                                        "code": config.errCode,
                                                                        "status": "Error",
                                                                        "message": "Impossible de supprimer le client, des responsabilités sont liés à ce dernière.",
                                                                    });
                                                                    return;
                                                                }
                                                            });


                                                    } else {
                                                        res.json({
                                                            "code": config.errCode,
                                                            "status": "Error",
                                                            "message": "Impossible de supprimer le client, des relations de travail sont liées à ce dernière.",
                                                        });
                                                        return;
                                                    }
                                                });



                                        } else {
                                            res.json({
                                                "code": config.errCode,
                                                "status": "Error",
                                                "message": "Impossible de supprimer le client, des activités sont liées à ce dernière.",
                                            });
                                            return;
                                        }
                                    });



                            } else {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": "Impossible de supprimer le client, des utilisateurs sont liés à ce dernière.",
                                });
                                return;
                            }
                        });

                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Impossible de supprimer le client, des entités sont liées à ce dernière.",
                    });
                    return;
                }
            });
    }
};

exports.activateMfaClient = (req, res) => {
    if (req.user.userRole != "admin" && req.user.userRole != "superAdmin") {
      res.json({
        code: config.errCode,
        status: "Error",
        message: "Accès non autorisé.",
      });
    } else {
      var receivedValues = req.body;
      if (
        JSON.stringify(receivedValues) === "{}" ||
        receivedValues === undefined ||
        receivedValues === null
      ) {
        res.json({
          code: config.errCode,
          status: "Error",
          message: "Les données entrées ne sont pas valides.",
        });
        return;
      } else {
        clientSchema
          .findOne({
            _id: receivedValues._id,
          })
          .select({})
          .exec((err, client) => {
            if (err) {
              res.json({
                code: config.errCode,
                status: "Error",
                message: err.message,
              });
              return;
            }
            if (client) {
              let fieldToSet;
              fieldToSet = {
                mfaActivated: receivedValues.mfaActivated,
              };
              let Option = {
                new: true,
              };
              clientSchema.findByIdAndUpdate(
                receivedValues._id,
                fieldToSet,
                Option,
                (err, updatedData) => {
                  if (err) {
                    console.log(err);
                    res.json({
                      code: config.errCode,
                      status: "Error",
                      message: config.errMessage,
                    });
                    return;
                  } else {
                    res.json({
                      code: config.successCode,
                      status: "Success",
                      message: "Le client a été modifié avec succès.",
                      data: updatedData,
                    });
                  }
                }
              );
            } else {
              res.json({
                code: config.errCode,
                status: "Error",
                message: "Le client n'existe pas.",
              });
            }
          });
      }
    }
};

exports.getClientByID = (req, res) => {
    var receivedValues = req.body;
    clientID = receivedValues.clientID;
    clientSchema
    .findOne({
        _id: clientID,
    })
    .select({ __v: 0})
    .exec((err, client) => {
        if (err) {
        res.json({
            code: config.errCode,
            status: "Error",
            message: err.message,
        });
        return;
        }
        if (client) {
        res.json({
            code: config.successCode,
            status: "success",
            data: client,
        });
        } else {
        res.json({
            code: config.errCode,
            status: "Error",
            message: "Aucun client trouvé.",
        });
        }
    });
    
  };


