!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports):"function"==typeof define&&define.amd?define("crypto-ts",["exports"],factory):factory(global.CryptoTS={})}(this,function(exports){"use strict";var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])};function __extends(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}
/**
     * @license crypto-ts
     * MIT license
     */for(var Hex=function(){function Hex(){}return Hex.stringify=function(wordArray){for(var hexChars=[],i=0;i<wordArray.sigBytes;i++){var bite=wordArray.words[i>>>2]>>>24-i%4*8&255;hexChars.push((bite>>>4).toString(16)),hexChars.push((15&bite).toString(16))}return hexChars.join("")},Hex.parse=function(hexStr){for(var hexStrLength=hexStr.length,words=[],i=0;i<hexStrLength;i+=2)words[i>>>3]|=parseInt(hexStr.substr(i,2),16)<<24-i%8*4;return new WordArray(words,hexStrLength/2)},Hex}(),WordArray=function(){function WordArray(words,sigBytes){this.words=words||[],this.sigBytes=void 0!==sigBytes?sigBytes:4*this.words.length}return WordArray.random=function(nBytes){for(var words=[],r=function(m_w){var m_z=987654321,mask=4294967295;return function(){var result=((m_z=36969*(65535&m_z)+(m_z>>16)&mask)<<16)+(m_w=18e3*(65535&m_w)+(m_w>>16)&mask)&mask;return result/=4294967296,(result+=.5)*(.5<Math.random()?1:-1)}},i=0,rcache=void 0;i<nBytes;i+=4){var _r=r(4294967296*(rcache||Math.random()));rcache=987654071*_r(),words.push(4294967296*_r()|0)}return new WordArray(words,nBytes)},WordArray.prototype.toString=function(encoder){return(encoder||Hex).stringify(this)},WordArray.prototype.concat=function(wordArray){if(this.clamp(),this.sigBytes%4)for(var i=0;i<wordArray.sigBytes;i++){var thatByte=wordArray.words[i>>>2]>>>24-i%4*8&255;this.words[this.sigBytes+i>>>2]|=thatByte<<24-(this.sigBytes+i)%4*8}else for(i=0;i<wordArray.sigBytes;i+=4)this.words[this.sigBytes+i>>>2]=wordArray.words[i>>>2];return this.sigBytes+=wordArray.sigBytes,this},WordArray.prototype.clamp=function(){this.words[this.sigBytes>>>2]&=4294967295<<32-this.sigBytes%4*8,this.words.length=Math.ceil(this.sigBytes/4)},WordArray.prototype.clone=function(){return new WordArray(this.words.slice(0),this.sigBytes)},WordArray}(),Latin1=function(){function Latin1(){}return Latin1.stringify=function(wordArray){for(var latin1Chars=[],i=0;i<wordArray.sigBytes;i++){var bite=wordArray.words[i>>>2]>>>24-i%4*8&255;latin1Chars.push(String.fromCharCode(bite))}return latin1Chars.join("")},Latin1.parse=function(latin1Str){for(var latin1StrLength=latin1Str.length,words=[],i=0;i<latin1StrLength;i++)words[i>>>2]|=(255&latin1Str.charCodeAt(i))<<24-i%4*8;return new WordArray(words,latin1StrLength)},Latin1}(),Utf8=function(){function Utf8(){}return Utf8.stringify=function(wordArray){try{return decodeURIComponent(escape(Latin1.stringify(wordArray)))}catch(e){throw new Error("Malformed UTF-8 data")}},Utf8.parse=function(utf8Str){return Latin1.parse(unescape(encodeURIComponent(utf8Str)))},Utf8}(),BufferedBlockAlgorithm=function(){function BufferedBlockAlgorithm(cfg){this._minBufferSize=0,this.cfg=Object.assign({blockSize:1},cfg),this._data=new WordArray,this._nDataBytes=0}return BufferedBlockAlgorithm.prototype.reset=function(){this._data=new WordArray,this._nDataBytes=0},BufferedBlockAlgorithm.prototype._append=function(data){"string"==typeof data&&(data=Utf8.parse(data)),this._data.concat(data),this._nDataBytes+=data.sigBytes},BufferedBlockAlgorithm.prototype._process=function(doFlush){if(!this.cfg.blockSize)throw new Error("missing blockSize in config");var processedWords,blockSizeBytes=4*this.cfg.blockSize,nBlocksReady=this._data.sigBytes/blockSizeBytes,nWordsReady=(nBlocksReady=doFlush?Math.ceil(nBlocksReady):Math.max((0|nBlocksReady)-this._minBufferSize,0))*this.cfg.blockSize,nBytesReady=Math.min(4*nWordsReady,this._data.sigBytes);if(nWordsReady){for(var offset=0;offset<nWordsReady;offset+=this.cfg.blockSize)this._doProcessBlock(this._data.words,offset);processedWords=this._data.words.splice(0,nWordsReady),this._data.sigBytes-=nBytesReady}return new WordArray(processedWords,nBytesReady)},BufferedBlockAlgorithm.prototype.clone=function(){var clone=this.constructor();for(var attr in this)this.hasOwnProperty(attr)&&(clone[attr]=this[attr]);return clone._data=this._data.clone(),clone},BufferedBlockAlgorithm}(),Base=function(){},CipherParams=function(_super){function CipherParams(cipherParams){var _this=_super.call(this)||this;return _this.ciphertext=cipherParams.ciphertext,_this.key=cipherParams.key,_this.iv=cipherParams.iv,_this.salt=cipherParams.salt,_this.algorithm=cipherParams.algorithm,_this.mode=cipherParams.mode,_this.padding=cipherParams.padding,_this.blockSize=cipherParams.blockSize,_this.formatter=cipherParams.formatter,_this}return __extends(CipherParams,_super),CipherParams.prototype.extend=function(additionalParams){return void 0!==additionalParams.ciphertext&&(this.ciphertext=additionalParams.ciphertext),void 0!==additionalParams.key&&(this.key=additionalParams.key),void 0!==additionalParams.iv&&(this.iv=additionalParams.iv),void 0!==additionalParams.salt&&(this.salt=additionalParams.salt),void 0!==additionalParams.algorithm&&(this.algorithm=additionalParams.algorithm),void 0!==additionalParams.mode&&(this.mode=additionalParams.mode),void 0!==additionalParams.padding&&(this.padding=additionalParams.padding),void 0!==additionalParams.blockSize&&(this.blockSize=additionalParams.blockSize),void 0!==additionalParams.formatter&&(this.formatter=additionalParams.formatter),this},CipherParams.prototype.toString=function(formatter){if(formatter)return formatter.stringify(this);if(this.formatter)return this.formatter.stringify(this);throw new Error("cipher needs a formatter to be able to convert the result into a string")},CipherParams}(Base),Base64=function(){function Base64(){}return Base64.stringify=function(wordArray){wordArray.clamp();for(var base64Chars=[],i=0;i<wordArray.sigBytes;i+=3)for(var triplet=(wordArray.words[i>>>2]>>>24-i%4*8&255)<<16|(wordArray.words[i+1>>>2]>>>24-(i+1)%4*8&255)<<8|wordArray.words[i+2>>>2]>>>24-(i+2)%4*8&255,j=0;j<4&&i+.75*j<wordArray.sigBytes;j++)base64Chars.push(this._map.charAt(triplet>>>6*(3-j)&63));var paddingChar=this._map.charAt(64);if(paddingChar)for(;base64Chars.length%4;)base64Chars.push(paddingChar);return base64Chars.join("")},Base64.parse=function(base64Str){var base64StrLength=base64Str.length;if(void 0===this._reverseMap){this._reverseMap=[];for(var j=0;j<this._map.length;j++)this._reverseMap[this._map.charCodeAt(j)]=j}var paddingChar=this._map.charAt(64);if(paddingChar){var paddingIndex=base64Str.indexOf(paddingChar);-1!==paddingIndex&&(base64StrLength=paddingIndex)}return this.parseLoop(base64Str,base64StrLength,this._reverseMap)},Base64.parseLoop=function(base64Str,base64StrLength,reverseMap){for(var words=[],nBytes=0,i=0;i<base64StrLength;i++)if(i%4){var bits1=reverseMap[base64Str.charCodeAt(i-1)]<<i%4*2,bits2=reverseMap[base64Str.charCodeAt(i)]>>>6-i%4*2;words[nBytes>>>2]|=(bits1|bits2)<<24-nBytes%4*8,nBytes++}return new WordArray(words,nBytes)},Base64._map="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",Base64._reverseMap=void 0,Base64}(),OpenSSL=function(){function OpenSSL(){}return OpenSSL.stringify=function(cipherParams){if(!cipherParams.ciphertext)throw new Error("missing ciphertext in params");var wordArray,ciphertext=cipherParams.ciphertext,salt=cipherParams.salt;if(salt){if("string"==typeof salt)throw new Error("salt is expected to be a WordArray");wordArray=new WordArray([1398893684,1701076831]).concat(salt).concat(ciphertext)}else wordArray=ciphertext;return wordArray.toString(Base64)},OpenSSL.parse=function(openSSLStr){var salt,ciphertext=Base64.parse(openSSLStr);return 1398893684===ciphertext.words[0]&&1701076831===ciphertext.words[1]&&(salt=new WordArray(ciphertext.words.slice(2,4)),ciphertext.words.splice(0,4),ciphertext.sigBytes-=16),new CipherParams({ciphertext:ciphertext,salt:salt})},OpenSSL}(),SerializableCipher=function(){function SerializableCipher(){}return SerializableCipher.encrypt=function(cipher,message,key,cfg){var config=Object.assign({},this.cfg,cfg),encryptor=cipher.createEncryptor(key,config),ciphertext=encryptor.finalize(message);return new CipherParams({ciphertext:ciphertext,key:key,iv:encryptor.cfg.iv,algorithm:cipher,mode:encryptor.cfg.mode,padding:encryptor.cfg.padding,blockSize:encryptor.cfg.blockSize,formatter:config.format})},SerializableCipher.decrypt=function(cipher,ciphertext,key,optionalCfg){var cfg=Object.assign({},this.cfg,optionalCfg);if(!cfg.format)throw new Error("could not determine format");if(!(ciphertext=this._parse(ciphertext,cfg.format)).ciphertext)throw new Error("could not determine ciphertext");return cipher.createDecryptor(key,cfg).finalize(ciphertext.ciphertext)},SerializableCipher._parse=function(ciphertext,format){return"string"==typeof ciphertext?format.parse(ciphertext):ciphertext},SerializableCipher.cfg={blockSize:4,iv:new WordArray([]),format:OpenSSL},SerializableCipher}(),Hasher=function(_super){function Hasher(cfg){var _this=_super.call(this,Object.assign({blockSize:16},cfg))||this;return _this.reset(),_this}return __extends(Hasher,_super),Hasher._createHelper=function(hasher){return function(message,cfg){return new hasher(cfg).finalize(message)}},Hasher.prototype.update=function(messageUpdate){return this._append(messageUpdate),this._process(),this},Hasher.prototype.finalize=function(messageUpdate){return messageUpdate&&this._append(messageUpdate),this._doFinalize()},Hasher}(BufferedBlockAlgorithm),T=[],i=0;i<64;i++)T[i]=4294967296*Math.abs(Math.sin(i+1))|0;var MD5=function(_super){function MD5(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(MD5,_super),MD5.FF=function(a,b,c,d,x,s,t){var n=a+(b&c|~b&d)+x+t;return(n<<s|n>>>32-s)+b},MD5.GG=function(a,b,c,d,x,s,t){var n=a+(b&d|c&~d)+x+t;return(n<<s|n>>>32-s)+b},MD5.HH=function(a,b,c,d,x,s,t){var n=a+(b^c^d)+x+t;return(n<<s|n>>>32-s)+b},MD5.II=function(a,b,c,d,x,s,t){var n=a+(c^(b|~d))+x+t;return(n<<s|n>>>32-s)+b},MD5.prototype.reset=function(){_super.prototype.reset.call(this),this._hash=new WordArray([1732584193,4023233417,2562383102,271733878])},MD5.prototype._doProcessBlock=function(M,offset){for(var i=0;i<16;i++){var offset_i=offset+i,M_offset_i=M[offset_i];M[offset_i]=16711935&(M_offset_i<<8|M_offset_i>>>24)|4278255360&(M_offset_i<<24|M_offset_i>>>8)}var H=this._hash.words,M_offset_0=M[offset+0],M_offset_1=M[offset+1],M_offset_2=M[offset+2],M_offset_3=M[offset+3],M_offset_4=M[offset+4],M_offset_5=M[offset+5],M_offset_6=M[offset+6],M_offset_7=M[offset+7],M_offset_8=M[offset+8],M_offset_9=M[offset+9],M_offset_10=M[offset+10],M_offset_11=M[offset+11],M_offset_12=M[offset+12],M_offset_13=M[offset+13],M_offset_14=M[offset+14],M_offset_15=M[offset+15],a=H[0],b=H[1],c=H[2],d=H[3];a=MD5.FF(a,b,c,d,M_offset_0,7,T[0]),d=MD5.FF(d,a,b,c,M_offset_1,12,T[1]),c=MD5.FF(c,d,a,b,M_offset_2,17,T[2]),b=MD5.FF(b,c,d,a,M_offset_3,22,T[3]),a=MD5.FF(a,b,c,d,M_offset_4,7,T[4]),d=MD5.FF(d,a,b,c,M_offset_5,12,T[5]),c=MD5.FF(c,d,a,b,M_offset_6,17,T[6]),b=MD5.FF(b,c,d,a,M_offset_7,22,T[7]),a=MD5.FF(a,b,c,d,M_offset_8,7,T[8]),d=MD5.FF(d,a,b,c,M_offset_9,12,T[9]),c=MD5.FF(c,d,a,b,M_offset_10,17,T[10]),b=MD5.FF(b,c,d,a,M_offset_11,22,T[11]),a=MD5.FF(a,b,c,d,M_offset_12,7,T[12]),d=MD5.FF(d,a,b,c,M_offset_13,12,T[13]),c=MD5.FF(c,d,a,b,M_offset_14,17,T[14]),b=MD5.FF(b,c,d,a,M_offset_15,22,T[15]),a=MD5.GG(a,b,c,d,M_offset_1,5,T[16]),d=MD5.GG(d,a,b,c,M_offset_6,9,T[17]),c=MD5.GG(c,d,a,b,M_offset_11,14,T[18]),b=MD5.GG(b,c,d,a,M_offset_0,20,T[19]),a=MD5.GG(a,b,c,d,M_offset_5,5,T[20]),d=MD5.GG(d,a,b,c,M_offset_10,9,T[21]),c=MD5.GG(c,d,a,b,M_offset_15,14,T[22]),b=MD5.GG(b,c,d,a,M_offset_4,20,T[23]),a=MD5.GG(a,b,c,d,M_offset_9,5,T[24]),d=MD5.GG(d,a,b,c,M_offset_14,9,T[25]),c=MD5.GG(c,d,a,b,M_offset_3,14,T[26]),b=MD5.GG(b,c,d,a,M_offset_8,20,T[27]),a=MD5.GG(a,b,c,d,M_offset_13,5,T[28]),d=MD5.GG(d,a,b,c,M_offset_2,9,T[29]),c=MD5.GG(c,d,a,b,M_offset_7,14,T[30]),b=MD5.GG(b,c,d,a,M_offset_12,20,T[31]),a=MD5.HH(a,b,c,d,M_offset_5,4,T[32]),d=MD5.HH(d,a,b,c,M_offset_8,11,T[33]),c=MD5.HH(c,d,a,b,M_offset_11,16,T[34]),b=MD5.HH(b,c,d,a,M_offset_14,23,T[35]),a=MD5.HH(a,b,c,d,M_offset_1,4,T[36]),d=MD5.HH(d,a,b,c,M_offset_4,11,T[37]),c=MD5.HH(c,d,a,b,M_offset_7,16,T[38]),b=MD5.HH(b,c,d,a,M_offset_10,23,T[39]),a=MD5.HH(a,b,c,d,M_offset_13,4,T[40]),d=MD5.HH(d,a,b,c,M_offset_0,11,T[41]),c=MD5.HH(c,d,a,b,M_offset_3,16,T[42]),b=MD5.HH(b,c,d,a,M_offset_6,23,T[43]),a=MD5.HH(a,b,c,d,M_offset_9,4,T[44]),d=MD5.HH(d,a,b,c,M_offset_12,11,T[45]),c=MD5.HH(c,d,a,b,M_offset_15,16,T[46]),b=MD5.HH(b,c,d,a,M_offset_2,23,T[47]),a=MD5.II(a,b,c,d,M_offset_0,6,T[48]),d=MD5.II(d,a,b,c,M_offset_7,10,T[49]),c=MD5.II(c,d,a,b,M_offset_14,15,T[50]),b=MD5.II(b,c,d,a,M_offset_5,21,T[51]),a=MD5.II(a,b,c,d,M_offset_12,6,T[52]),d=MD5.II(d,a,b,c,M_offset_3,10,T[53]),c=MD5.II(c,d,a,b,M_offset_10,15,T[54]),b=MD5.II(b,c,d,a,M_offset_1,21,T[55]),a=MD5.II(a,b,c,d,M_offset_8,6,T[56]),d=MD5.II(d,a,b,c,M_offset_15,10,T[57]),c=MD5.II(c,d,a,b,M_offset_6,15,T[58]),b=MD5.II(b,c,d,a,M_offset_13,21,T[59]),a=MD5.II(a,b,c,d,M_offset_4,6,T[60]),d=MD5.II(d,a,b,c,M_offset_11,10,T[61]),c=MD5.II(c,d,a,b,M_offset_2,15,T[62]),b=MD5.II(b,c,d,a,M_offset_9,21,T[63]),H[0]=H[0]+a|0,H[1]=H[1]+b|0,H[2]=H[2]+c|0,H[3]=H[3]+d|0},MD5.prototype._doFinalize=function(){var data=this._data,dataWords=data.words,nBitsTotal=8*this._nDataBytes,nBitsLeft=8*data.sigBytes;dataWords[nBitsLeft>>>5]|=128<<24-nBitsLeft%32;var nBitsTotalH=Math.floor(nBitsTotal/4294967296),nBitsTotalL=nBitsTotal;dataWords[15+(nBitsLeft+64>>>9<<4)]=16711935&(nBitsTotalH<<8|nBitsTotalH>>>24)|4278255360&(nBitsTotalH<<24|nBitsTotalH>>>8),dataWords[14+(nBitsLeft+64>>>9<<4)]=16711935&(nBitsTotalL<<8|nBitsTotalL>>>24)|4278255360&(nBitsTotalL<<24|nBitsTotalL>>>8),data.sigBytes=4*(dataWords.length+1),this._process();for(var hash=this._hash,H=hash.words,i=0;i<4;i++){var H_i=H[i];H[i]=16711935&(H_i<<8|H_i>>>24)|4278255360&(H_i<<24|H_i>>>8)}return hash},MD5}(Hasher),EvpKDF=function(){function EvpKDF(cfg){this.cfg=Object.assign({keySize:4,hasher:MD5,iterations:1},cfg)}return EvpKDF.prototype.compute=function(password,salt){for(var block,hasher=new this.cfg.hasher,derivedKey=new WordArray;derivedKey.words.length<this.cfg.keySize;){block&&hasher.update(block),block=hasher.update(password).finalize(salt),hasher.reset();for(var i=1;i<this.cfg.iterations;i++)block=hasher.finalize(block),hasher.reset();derivedKey.concat(block)}return derivedKey.sigBytes=4*this.cfg.keySize,derivedKey},EvpKDF}(),OpenSSLKdf=function(){function OpenSSLKdf(){}return OpenSSLKdf.execute=function(password,keySize,ivSize,salt){salt||(salt=WordArray.random(8));var key=new EvpKDF({keySize:keySize+ivSize}).compute(password,salt),iv=new WordArray(key.words.slice(keySize),4*ivSize);return key.sigBytes=4*keySize,new CipherParams({key:key,iv:iv,salt:salt})},OpenSSLKdf}(),PasswordBasedCipher=function(){function PasswordBasedCipher(){}return PasswordBasedCipher.encrypt=function(cipher,message,password,cfg){var config=Object.assign({},this.cfg,cfg);if(void 0===config.kdf)throw new Error("missing kdf in config");var derivedParams=config.kdf.execute(password,cipher.keySize,cipher.ivSize);return void 0!==derivedParams.iv&&(config.iv=derivedParams.iv),SerializableCipher.encrypt.call(this,cipher,message,derivedParams.key,config).extend(derivedParams)},PasswordBasedCipher.decrypt=function(cipher,ciphertext,password,cfg){var config=Object.assign({},this.cfg,cfg);if(void 0===config.format)throw new Error("missing format in config");if(ciphertext=this._parse(ciphertext,config.format),void 0===config.kdf)throw new Error("the key derivation function must be set");var derivedParams=config.kdf.execute(password,cipher.keySize,cipher.ivSize,ciphertext.salt);return void 0!==derivedParams.iv&&(config.iv=derivedParams.iv),SerializableCipher.decrypt.call(this,cipher,ciphertext,derivedParams.key,config)},PasswordBasedCipher._parse=function(ciphertext,format){return"string"==typeof ciphertext?format.parse(ciphertext):ciphertext},PasswordBasedCipher.cfg={blockSize:4,iv:new WordArray([]),format:OpenSSL,kdf:OpenSSLKdf},PasswordBasedCipher}(),Cipher=function(_super){function Cipher(xformMode,key,cfg){var _this=_super.call(this,Object.assign({blockSize:1},cfg))||this;return _this._xformMode=xformMode,_this._key=key,_this.reset(),_this}return __extends(Cipher,_super),Cipher.createEncryptor=function(key,cfg){return new this(this._ENC_XFORM_MODE,key,cfg)},Cipher.createDecryptor=function(key,cfg){return new this(this._DEC_XFORM_MODE,key,cfg)},Cipher._createHelper=function(cipher){return{encrypt:function(message,key,cfg){return"string"==typeof key?PasswordBasedCipher.encrypt(cipher,message,key,cfg):SerializableCipher.encrypt(cipher,message,key,cfg)},decrypt:function(ciphertext,key,cfg){return"string"==typeof key?PasswordBasedCipher.decrypt(cipher,ciphertext,key,cfg):SerializableCipher.decrypt(cipher,ciphertext,key,cfg)}}},Cipher.prototype.process=function(dataUpdate){return this._append(dataUpdate),this._process()},Cipher.prototype.finalize=function(dataUpdate){return dataUpdate&&this._append(dataUpdate),this._doFinalize()},Cipher._ENC_XFORM_MODE=1,Cipher._DEC_XFORM_MODE=2,Cipher.keySize=4,Cipher.ivSize=4,Cipher}(BufferedBlockAlgorithm),BlockCipherModeAlgorithm=function(){function BlockCipherModeAlgorithm(cipher,iv){this.init(cipher,iv)}return BlockCipherModeAlgorithm.prototype.init=function(cipher,iv){this._cipher=cipher,this._iv=iv},BlockCipherModeAlgorithm}(),BlockCipherMode=function(){function BlockCipherMode(){}return BlockCipherMode.createEncryptor=function(cipher,iv){return new(0,this.Encryptor)(cipher,iv)},BlockCipherMode.createDecryptor=function(cipher,iv){return new(0,this.Decryptor)(cipher,iv)},BlockCipherMode.Encryptor=BlockCipherModeAlgorithm,BlockCipherMode.Decryptor=BlockCipherModeAlgorithm,BlockCipherMode}(),CBCEncryptor=function(_super){function CBCEncryptor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(CBCEncryptor,_super),CBCEncryptor.prototype.processBlock=function(words,offset){if(void 0===this._cipher.cfg.blockSize)throw new Error("missing blockSize in cipher config");this.xorBlock(words,offset,this._cipher.cfg.blockSize),this._cipher.encryptBlock(words,offset),this._prevBlock=words.slice(offset,offset+this._cipher.cfg.blockSize)},CBCEncryptor.prototype.xorBlock=function(words,offset,blockSize){var block;if(this._iv?(block=this._iv,this._iv=void 0):block=this._prevBlock,void 0!==block)for(var i=0;i<blockSize;i++)words[offset+i]^=block[i]},CBCEncryptor}(BlockCipherModeAlgorithm),CBCDecryptor=function(_super){function CBCDecryptor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(CBCDecryptor,_super),CBCDecryptor.prototype.processBlock=function(words,offset){if(void 0===this._cipher.cfg.blockSize)throw new Error("missing blockSize in cipher config");var thisBlock=words.slice(offset,offset+this._cipher.cfg.blockSize);this._cipher.decryptBlock(words,offset),this.xorBlock(words,offset,this._cipher.cfg.blockSize),this._prevBlock=thisBlock},CBCDecryptor.prototype.xorBlock=function(words,offset,blockSize){var block;if(this._iv?(block=this._iv,this._iv=void 0):block=this._prevBlock,void 0!==block)for(var i=0;i<blockSize;i++)words[offset+i]^=block[i]},CBCDecryptor}(BlockCipherModeAlgorithm),CBC=function(_super){function CBC(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(CBC,_super),CBC.Encryptor=CBCEncryptor,CBC.Decryptor=CBCDecryptor,CBC}(BlockCipherMode),PKCS7=function(){function PKCS7(){}return PKCS7.pad=function(data,blockSize){for(var blockSizeBytes=4*blockSize,nPaddingBytes=blockSizeBytes-data.sigBytes%blockSizeBytes,paddingWord=nPaddingBytes<<24|nPaddingBytes<<16|nPaddingBytes<<8|nPaddingBytes,paddingWords=[],i=0;i<nPaddingBytes;i+=4)paddingWords.push(paddingWord);var padding=new WordArray(paddingWords,nPaddingBytes);data.concat(padding)},PKCS7.unpad=function(data){var nPaddingBytes=255&data.words[data.sigBytes-1>>>2];data.sigBytes-=nPaddingBytes},PKCS7}(),BlockCipher=function(_super){function BlockCipher(xformMode,key,cfg){return _super.call(this,xformMode,key,Object.assign({blockSize:4,mode:CBC,padding:PKCS7},cfg))||this}return __extends(BlockCipher,_super),BlockCipher.prototype.reset=function(){if(_super.prototype.reset.call(this),void 0===this.cfg.mode)throw new Error("missing mode in config");var modeCreator;this._xformMode===this.constructor._ENC_XFORM_MODE?modeCreator=this.cfg.mode.createEncryptor:(modeCreator=this.cfg.mode.createDecryptor,this._minBufferSize=1),this._mode&&this._mode.__creator===modeCreator?this._mode.init(this,this.cfg.iv&&this.cfg.iv.words):(this._mode=modeCreator.call(this.cfg.mode,this,this.cfg.iv&&this.cfg.iv.words),this._mode.__creator=modeCreator)},BlockCipher.prototype._doProcessBlock=function(words,offset){this._mode.processBlock(words,offset)},BlockCipher.prototype._doFinalize=function(){if(void 0===this.cfg.padding)throw new Error("missing padding in config");var finalProcessedBlocks;if(this._xformMode===this.constructor._ENC_XFORM_MODE){if(void 0===this.cfg.blockSize)throw new Error("missing blockSize in config");this.cfg.padding.pad(this._data,this.cfg.blockSize),finalProcessedBlocks=this._process(!0)}else finalProcessedBlocks=this._process(!0),this.cfg.padding.unpad(finalProcessedBlocks);return finalProcessedBlocks},BlockCipher}(Cipher),SBOX=[],INV_SBOX=[],SUB_MIX_0=[],SUB_MIX_1=[],SUB_MIX_2=[],SUB_MIX_3=[],INV_SUB_MIX_0=[],INV_SUB_MIX_1=[],INV_SUB_MIX_2=[],INV_SUB_MIX_3=[];!function(){for(var d=[],i=0;i<256;i++)d[i]=i<128?i<<1:i<<1^283;var x=0,xi=0;for(i=0;i<256;i++){var sx=xi^xi<<1^xi<<2^xi<<3^xi<<4;sx=sx>>>8^255&sx^99,SBOX[x]=sx;var x2=d[INV_SBOX[sx]=x],x4=d[x2],x8=d[x4],t=257*d[sx]^16843008*sx;SUB_MIX_0[x]=t<<24|t>>>8,SUB_MIX_1[x]=t<<16|t>>>16,SUB_MIX_2[x]=t<<8|t>>>24,SUB_MIX_3[x]=t,t=16843009*x8^65537*x4^257*x2^16843008*x,INV_SUB_MIX_0[sx]=t<<24|t>>>8,INV_SUB_MIX_1[sx]=t<<16|t>>>16,INV_SUB_MIX_2[sx]=t<<8|t>>>24,INV_SUB_MIX_3[sx]=t,x?(x=x2^d[d[d[x8^x2]]],xi^=d[d[xi]]):x=xi=1}}();var RCON=[0,1,2,4,8,16,32,64,128,27,54],AES=function(_super){function AES(xformMode,key,cfg){return _super.call(this,xformMode,key,cfg)||this}return __extends(AES,_super),AES.prototype.reset=function(){if(_super.prototype.reset.call(this),!this._nRounds||this._keyPriorReset!==this._key){for(var key=this._keyPriorReset=this._key,keyWords=key.words,keySize=key.sigBytes/4,ksRows=4*((this._nRounds=keySize+6)+1),keySchedule=this._keySchedule=[],ksRow=0;ksRow<ksRows;ksRow++)if(ksRow<keySize)keySchedule[ksRow]=keyWords[ksRow];else{var t=keySchedule[ksRow-1];ksRow%keySize?6<keySize&&ksRow%keySize==4&&(t=SBOX[t>>>24]<<24|SBOX[t>>>16&255]<<16|SBOX[t>>>8&255]<<8|SBOX[255&t]):(t=SBOX[(t=t<<8|t>>>24)>>>24]<<24|SBOX[t>>>16&255]<<16|SBOX[t>>>8&255]<<8|SBOX[255&t],t^=RCON[ksRow/keySize|0]<<24),keySchedule[ksRow]=keySchedule[ksRow-keySize]^t}for(var invKeySchedule=this._invKeySchedule=[],invKsRow=0;invKsRow<ksRows;invKsRow++){ksRow=ksRows-invKsRow,t=void 0;t=invKsRow%4?keySchedule[ksRow]:keySchedule[ksRow-4],invKeySchedule[invKsRow]=invKsRow<4||ksRow<=4?t:INV_SUB_MIX_0[SBOX[t>>>24]]^INV_SUB_MIX_1[SBOX[t>>>16&255]]^INV_SUB_MIX_2[SBOX[t>>>8&255]]^INV_SUB_MIX_3[SBOX[255&t]]}}},AES.prototype.encryptBlock=function(M,offset){this._doCryptBlock(M,offset,this._keySchedule,SUB_MIX_0,SUB_MIX_1,SUB_MIX_2,SUB_MIX_3,SBOX)},AES.prototype.decryptBlock=function(M,offset){var t=M[offset+1];M[offset+1]=M[offset+3],M[offset+3]=t,this._doCryptBlock(M,offset,this._invKeySchedule,INV_SUB_MIX_0,INV_SUB_MIX_1,INV_SUB_MIX_2,INV_SUB_MIX_3,INV_SBOX),t=M[offset+1],M[offset+1]=M[offset+3],M[offset+3]=t},AES.prototype._doCryptBlock=function(M,offset,keySchedule,sub_mix_0,sub_mix_1,sub_mix_2,sub_mix_3,sbox){for(var s0=M[offset]^keySchedule[0],s1=M[offset+1]^keySchedule[1],s2=M[offset+2]^keySchedule[2],s3=M[offset+3]^keySchedule[3],ksRow=4,round=1;round<this._nRounds;round++){var t0=sub_mix_0[s0>>>24]^sub_mix_1[s1>>>16&255]^sub_mix_2[s2>>>8&255]^sub_mix_3[255&s3]^keySchedule[ksRow++],t1=sub_mix_0[s1>>>24]^sub_mix_1[s2>>>16&255]^sub_mix_2[s3>>>8&255]^sub_mix_3[255&s0]^keySchedule[ksRow++],t2=sub_mix_0[s2>>>24]^sub_mix_1[s3>>>16&255]^sub_mix_2[s0>>>8&255]^sub_mix_3[255&s1]^keySchedule[ksRow++],t3=sub_mix_0[s3>>>24]^sub_mix_1[s0>>>16&255]^sub_mix_2[s1>>>8&255]^sub_mix_3[255&s2]^keySchedule[ksRow++];s0=t0,s1=t1,s2=t2,s3=t3}var t0g=(sbox[s0>>>24]<<24|sbox[s1>>>16&255]<<16|sbox[s2>>>8&255]<<8|sbox[255&s3])^keySchedule[ksRow++],t1g=(sbox[s1>>>24]<<24|sbox[s2>>>16&255]<<16|sbox[s3>>>8&255]<<8|sbox[255&s0])^keySchedule[ksRow++],t2g=(sbox[s2>>>24]<<24|sbox[s3>>>16&255]<<16|sbox[s0>>>8&255]<<8|sbox[255&s1])^keySchedule[ksRow++],t3g=(sbox[s3>>>24]<<24|sbox[s0>>>16&255]<<16|sbox[s1>>>8&255]<<8|sbox[255&s2])^keySchedule[ksRow++];M[offset]=t0g,M[offset+1]=t1g,M[offset+2]=t2g,M[offset+3]=t3g},AES.keySize=8,AES}(BlockCipher),H=[],K=[],W=[],SHA256=function(_super){function SHA256(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(SHA256,_super),SHA256.prototype.reset=function(){_super.prototype.reset.call(this),this._hash=new WordArray(H.slice(0))},SHA256.prototype._doProcessBlock=function(M,offset){for(var Hl=this._hash.words,a=Hl[0],b=Hl[1],c=Hl[2],d=Hl[3],e=Hl[4],f=Hl[5],g=Hl[6],h=Hl[7],i=0;i<64;i++){if(i<16)W[i]=0|M[offset+i];else{var gamma0x=W[i-15],gamma0=(gamma0x<<25|gamma0x>>>7)^(gamma0x<<14|gamma0x>>>18)^gamma0x>>>3,gamma1x=W[i-2],gamma1=(gamma1x<<15|gamma1x>>>17)^(gamma1x<<13|gamma1x>>>19)^gamma1x>>>10;W[i]=gamma0+W[i-7]+gamma1+W[i-16]}var maj=a&b^a&c^b&c,sigma0=(a<<30|a>>>2)^(a<<19|a>>>13)^(a<<10|a>>>22),t1=h+((e<<26|e>>>6)^(e<<21|e>>>11)^(e<<7|e>>>25))+(e&f^~e&g)+K[i]+W[i];h=g,g=f,f=e,e=d+t1|0,d=c,c=b,b=a,a=t1+(sigma0+maj)|0}Hl[0]=Hl[0]+a|0,Hl[1]=Hl[1]+b|0,Hl[2]=Hl[2]+c|0,Hl[3]=Hl[3]+d|0,Hl[4]=Hl[4]+e|0,Hl[5]=Hl[5]+f|0,Hl[6]=Hl[6]+g|0,Hl[7]=Hl[7]+h|0},SHA256.prototype._doFinalize=function(){var nBitsTotal=8*this._nDataBytes,nBitsLeft=8*this._data.sigBytes;return this._data.words[nBitsLeft>>>5]|=128<<24-nBitsLeft%32,this._data.words[14+(nBitsLeft+64>>>9<<4)]=Math.floor(nBitsTotal/4294967296),this._data.words[15+(nBitsLeft+64>>>9<<4)]=nBitsTotal,this._data.sigBytes=4*this._data.words.length,this._process(),this._hash},SHA256}(Hasher),NoPadding=function(){function NoPadding(){}return NoPadding.pad=function(data,blockSize){},NoPadding.unpad=function(data){},NoPadding}(),ECBEncryptor=function(_super){function ECBEncryptor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ECBEncryptor,_super),ECBEncryptor.prototype.processBlock=function(words,offset){this._cipher.encryptBlock(words,offset)},ECBEncryptor}(BlockCipherModeAlgorithm),ECBDecryptor=function(_super){function ECBDecryptor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ECBDecryptor,_super),ECBDecryptor.prototype.processBlock=function(words,offset){this._cipher.decryptBlock(words,offset)},ECBDecryptor}(BlockCipherModeAlgorithm),ECB=function(_super){function ECB(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ECB,_super),ECB.Encryptor=ECBEncryptor,ECB.Decryptor=ECBDecryptor,ECB}(BlockCipherMode),lib={BlockCipher:BlockCipher,WordArray:WordArray,CipherParams:CipherParams,Hasher:Hasher,SerializableCipher:SerializableCipher,PasswordBasedCipher:PasswordBasedCipher},algo={AES:AES,SHA256:SHA256},enc={Utf8:Utf8,Hex:Hex},pad={NoPadding:NoPadding,PKCS7:PKCS7},mode={CBC:CBC,ECB:ECB},AES$1=lib.BlockCipher._createHelper(algo.AES),SHA256$1=lib.Hasher._createHelper(algo.SHA256);exports.lib=lib,exports.algo=algo,exports.enc=enc,exports.pad=pad,exports.mode=mode,exports.AES=AES$1,exports.SHA256=SHA256$1,exports.ɵl=AES,exports.ɵm=SHA256,exports.ɵp=Hex,exports.ɵo=Latin1,exports.ɵn=Utf8,exports.ɵg=Base,exports.ɵa=BlockCipher,exports.ɵc=BufferedBlockAlgorithm,exports.ɵb=Cipher,exports.ɵf=CipherParams,exports.ɵi=Hasher,exports.ɵk=PasswordBasedCipher,exports.ɵj=SerializableCipher,exports.ɵe=WordArray,exports.ɵt=BlockCipherMode,exports.ɵs=CBC,exports.ɵu=ECB,exports.ɵq=NoPadding,exports.ɵr=PKCS7,Object.defineProperty(exports,"__esModule",{value:!0})});