// ********************************************************** direction controller ********************************************* //

const mongoose = require('mongoose');
const config = require('../config');
const directionSchema = mongoose.model('direction');
const userSchema = mongoose.model('user');
const serviceSchema = mongoose.model('service');


// ********************************************************* direction API *********************************************** //


exports.createEditDirection = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        directionSchema.findOne({
            _id: req.body.directionID
        })
            .select({ _id: 1 })
            .exec((err, directionInfo) => {
                if (err) {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": config.errMessage,
                    });
                    return;
                }
                if (!directionInfo) {
                    directionSchema.findOne({
                        labelDirection: receivedValues.labelDirection.trim(),
                        entiteID: receivedValues.entiteID
                    }).select({ _id: 1 })
                        .exec((err, direction) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            if (!direction) {
                                let directionData;
                                directionData = {
                                    labelDirection: !receivedValues.labelDirection ? '' : receivedValues.labelDirection.trim(),
                                    directionActivated: receivedValues.directionActivated,
                                    entiteID: receivedValues.entiteID
                                };
                                directionSchema.create(directionData, (err, data) => {
                                    if (!err) {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le métier a été créé avec succès.",
                                            data: data
                                        });
                                    } else {
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": "Erreur lors de la création du métier.",
                                        });
                                        return;
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom de le métier existe déjà."
                                });
                                return;
                            }
                        });
                } else {
                    directionSchema.findOne({
                        labelDirection: receivedValues.labelDirection.trim(),
                        entiteID: receivedValues.entiteID
                    }).select({ _id: 1 })
                        .exec((err, direction) => {
                            if (err) {
                                res.json({
                                    "code": config.errCode,
                                    "status": "Error",
                                    "message": err.message
                                });
                                return;
                            }
                            var update = false;
                            if (direction) {
                                var directionJson = JSON.parse(JSON.stringify(direction));
                                var directionInfoJson = JSON.parse(JSON.stringify(directionInfo));
                                if (directionJson._id == directionInfoJson._id) {
                                    update = true;
                                } else {
                                    update = false;
                                }
                            } else {
                                update = true;
                            }
                            if (update) {
                                let directionData;
                                directionData = {
                                    labelDirection: !receivedValues.labelDirection ? '' : receivedValues.labelDirection.trim(),
                                    directionActivated: receivedValues.directionActivated,
                                    entiteID: receivedValues.entiteID,
                                    updatedAt: config.utcDefault()
                                };
                                let Option = {
                                    new: true
                                };

                                directionSchema.findByIdAndUpdate(directionInfo._id, directionData, Option, (err, updatedData) => {
                                    if (err) {
                                        console.log(err);
                                        res.json({
                                            "code": config.errCode,
                                            "status": "Error",
                                            "message": config.errMessage,
                                        });
                                        return;
                                    } else {
                                        res.json({
                                            "code": config.successCode,
                                            "status": "Success",
                                            "message": "Le métier a été modifié avec succès.",
                                            "data": updatedData
                                        });
                                    }
                                });
                            } else {
                                res.json({
                                    "code": config.errCodeNameExist,
                                    "status": "Error",
                                    "message": "Le nom du métier existe déjà."
                                });
                                return;
                            }
                        });
                }
            });
    }
};

exports.getDirectionsEntite = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    directionSchema.find({
        labelDirection: { $regex: new RegExp('.*' + receivedValues.labelDirection.toLowerCase() + '.*', "i") },
        entiteID: receivedValues.entiteID,
        directionActivated: true
    })
        .lean()
        .countDocuments()
        .then(counts => {
            return counts;
        }).then((totalDirections) => {
            if (!totalDirections || totalDirections === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune direction trouvée.",
                });
                return;
            } else {
                directionSchema.find({
                    labelDirection: { $regex: new RegExp('.*' + receivedValues.labelDirection.toLowerCase() + '.*', "i") },
                    entiteID: receivedValues.entiteID,
                    directionActivated: true
                })
                    .sort({ [req.body.sortBy]: req.body.orderBy })
                    .skip(offset)
                    .limit(req.body.limit)
                    .select({ __v: 0 })
                    .lean()
                    .exec((err, listDirections) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listDirections: listDirections,
                                    totalDirections: totalDirections,
                                    totalPages: Math.ceil(totalDirections / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getDirectionsEntiteUser = (req, res) => {
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .populate("permissionServicesCreate")
        .populate({
            path: 'permissionServicesCreate',
            populate: [
                { path: 'directionID' }
            ]
        })
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));

                var listDirections = [];
                for (var item of userJSON.permissionServicesCreate) {
                    if (item.directionID.entiteID == req.body.entiteID) {
                        if (listDirections.findIndex(x => x._id === item.directionID._id) == -1)
                            listDirections.push(item.directionID)
                    }
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listDirections: listDirections,
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });

};

exports.getDirectionsEntiteUserFilterEmploi = (req, res) => {
    var userID = req.user._id;
    userSchema.findOne({
        _id: userID
    })
        .select({ __v: 0, password: 0 })
        .populate("clientID")
        .populate("permissionServicesShow")
        .populate({
            path: 'permissionServicesShow',
            populate: [
                { path: 'directionID' }
            ]
        })
        .exec((err, user) => {
            if (err) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": err.message
                });
                return;
            }
            if (user) {

                var userJSON = JSON.parse(JSON.stringify(user));

                var listDirections = [];
                for (var item of userJSON.permissionServicesShow) {
                    if (listDirections.findIndex(x => x._id === item.directionID._id) == -1)
                        listDirections.push(item.directionID)
                }

                res.json({
                    "code": config.successCode,
                    "status": "success",
                    "data": {
                        listDirections: listDirections,
                    }
                });

            } else {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Aucun utilisateur trouvé."
                });
            }
        });

};

exports.getDirectionsClient = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    directionSchema.aggregate([
        {
            $lookup:
            {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID"
            }
        },
        {
            $lookup:
            {
                from: "client",
                localField: "entiteID.clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$entiteID' },
        { $unwind: '$clientID' },
        {
            '$match': {
                'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                labelDirection: { $regex: new RegExp('.*' + receivedValues.labelDirection.toLowerCase() + '.*', "i") },
                directionActivated: true,
            }
        }
    ])
        .then((directions) => {
            if (!directions || directions.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune direction trouvée.",
                });
                return;
            } else {
                directionSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "entite",
                            localField: "entiteID",
                            foreignField: "_id",
                            as: "entiteID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "entiteID.clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$entiteID' },
                    { $unwind: '$clientID' },
                    {
                        '$match': {
                            'clientID._id': mongoose.Types.ObjectId(receivedValues.clientID),
                            labelDirection: { $regex: new RegExp('.*' + receivedValues.labelDirection.toLowerCase() + '.*', "i") },
                            directionActivated: true,
                        }
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listDirections) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listDirections: listDirections,
                                    totalDirections: directions.length,
                                    totalPages: Math.ceil(directions.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.getDirections = (req, res) => {
    var offset = (req.body.pageOffset - 1) * req.body.pageLimit;
    var receivedValues = req.body;

    var orderby = 1;
    if (receivedValues.orderBy == "desc") {
        orderby = -1;
    }

    var match = {};
    match["labelDirection"] = { $regex: new RegExp('.*' + receivedValues.labelDirection.toLowerCase() + '.*', "i") };
    if (receivedValues.clientID != undefined && receivedValues.clientID.trim() != "") {
        match["clientID._id"] = mongoose.Types.ObjectId(receivedValues.clientID);
    }
    match["directionActivated"] = true;

    directionSchema.aggregate([
        {
            $lookup:
            {
                from: "entite",
                localField: "entiteID",
                foreignField: "_id",
                as: "entiteID"
            }
        },
        {
            $lookup:
            {
                from: "client",
                localField: "entiteID.clientID",
                foreignField: "_id",
                as: "clientID"
            }
        },
        { $unwind: '$entiteID' },
        { $unwind: '$clientID' },
        {
            '$match': match
        }
    ])
        .then((directions) => {
            if (!directions || directions.length === 0) {
                res.json({
                    "code": config.successCode,
                    "status": "Error",
                    "message": "Aucune direction trouvée.",
                });
                return;
            } else {
                directionSchema.aggregate([
                    {
                        $lookup:
                        {
                            from: "entite",
                            localField: "entiteID",
                            foreignField: "_id",
                            as: "entiteID"
                        }
                    },
                    {
                        $lookup:
                        {
                            from: "client",
                            localField: "entiteID.clientID",
                            foreignField: "_id",
                            as: "clientID"
                        }
                    },
                    { $unwind: '$entiteID' },
                    { $unwind: '$clientID' },
                    {
                        '$match': match
                    },
                    { "$sort": { [req.body.sortBy]: orderby } },
                    { "$limit": req.body.limit + offset },
                    { $skip: offset }
                ])
                    .collation({ locale: "fr" })
                    .exec((err, listDirections) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        } else {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "data": {
                                    listDirections: listDirections,
                                    totalDirections: directions.length,
                                    totalPages: Math.ceil(directions.length / req.body.limit)
                                }
                            });
                        }
                    });
            }
        })
};

exports.deleteDirectionByID = (req, res) => {
    const receivedValues = req.body;
    if (JSON.stringify(receivedValues) === '{}') {
        res.json({
            "code": config.errCode,
            "status": "Error",
            "message": "Les données entrées ne sont pas valides."
        });
    } else {
        let columns = ["directionID"];
        for (let iter = 0; iter < columns.length; iter++) {
            let columnName = columns[iter];
            if (receivedValues[columnName] === undefined && (columnName === 'directionID')) {
                res.json({
                    "code": config.errCode,
                    "status": "Error",
                    "message": "Le champ " + columnName + " n'est pas défini."
                });
                return;
            }
        }

        serviceSchema.find({
            directionID: req.body.directionID
        })
            .lean()
            .countDocuments()
            .then(counts => {
                return counts;
            }).then((totalService) => {
                if (!totalService || totalService === 0) {
                    // delete direction 
                    directionSchema.deleteOne({
                        _id: req.body.directionID
                    }).exec((err, directionInfo) => {
                        if (err) {
                            console.log(err);
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                            return;
                        }
                        if (directionInfo.deletedCount === 1) {
                            res.json({
                                "code": config.successCode,
                                "status": "success",
                                "message": "Le métier a été supprimé avec succès."
                            });
                        } else {
                            res.json({
                                "code": config.errCode,
                                "status": "Error",
                                "message": config.errMessage,
                            });
                        }
                    });

                } else {
                    res.json({
                        "code": config.errCode,
                        "status": "Error",
                        "message": "Impossible de supprimer le métier, des filières sont liées à ce dernier.",
                    });
                    return;
                }
            });
    }
};


